/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.WorkspaceListResource;
import org.geoserver.catalog.rest.WorkspaceResource;
import org.geoserver.rest.RestletException;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class WorkspaceFinder
extends AbstractCatalogFinder {
    public WorkspaceFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String workspace = this.getAttribute(request, "workspace");
        if (workspace == null && request.getMethod() == Method.GET) {
            return new WorkspaceListResource(null, request, response, this.catalog);
        }
        if (workspace != null) {
            boolean quietOnNotFound = this.quietOnNotFoundEnabled(request);
            if (this.catalog.getWorkspaceByName(workspace) == null) {
                if (quietOnNotFound) {
                    return null;
                }
                throw new RestletException("No such workspace: " + workspace, Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        return new WorkspaceResource(null, request, response, this.catalog);
    }
}

