/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.CatalogFreemarkerHTMLFormat;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.ReflectiveHTMLFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class WMSStoreResource
extends AbstractCatalogResource {
    public WMSStoreResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, WMSStoreInfo.class, catalog);
    }

    @Override
    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new WMSStoreHTMLFormat(request, response, (Resource)this, this.catalog);
    }

    protected Object handleObjectGet() {
        String ws = this.getAttribute("workspace");
        String wms = this.getAttribute("wmsstore");
        WorkspaceInfo wsInfo = this.catalog.getWorkspaceByName(ws);
        LOGGER.fine("GET wms store " + ws + "," + wms);
        return this.catalog.getStoreByName(wsInfo, wms, WMSStoreInfo.class);
    }

    public boolean allowPost() {
        return this.getAttribute("wmsstore") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        String workspace = this.getAttribute("workspace");
        WMSStoreInfo wms = (WMSStoreInfo)object;
        if (wms.getWorkspace() != null) {
            WorkspaceInfo ws = wms.getWorkspace();
            if (!workspace.equals(ws.getName())) {
                throw new RestletException("Expected workspace " + workspace + " but client specified " + ws.getName(), Status.CLIENT_ERROR_FORBIDDEN);
            }
        } else {
            wms.setWorkspace(this.catalog.getWorkspaceByName(workspace));
        }
        wms.setEnabled(true);
        this.catalog.validate((StoreInfo)wms, false).throwIfInvalid();
        this.catalog.add((StoreInfo)wms);
        LOGGER.info("POST WSM store " + wms.getName());
        return wms.getName();
    }

    public boolean allowPut() {
        return this.getAttribute("wmsstore") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        String workspace = this.getAttribute("workspace");
        String wmsstore = this.getAttribute("wmsstore");
        WMSStoreInfo wms = (WMSStoreInfo)object;
        WMSStoreInfo original = (WMSStoreInfo)this.catalog.getStoreByName(workspace, wmsstore, WMSStoreInfo.class);
        if (wms.getName() != null && !wms.getName().equals(original.getName())) {
            throw new RestletException("Can't change name of data store.", Status.CLIENT_ERROR_FORBIDDEN);
        }
        if (wms.getWorkspace() != null && !wms.getWorkspace().equals(original.getWorkspace())) {
            throw new RestletException("Can't change workspace of data store.", Status.CLIENT_ERROR_FORBIDDEN);
        }
        new CatalogBuilder(this.catalog).updateWMSStore(original, wms);
        this.catalog.validate((StoreInfo)original, false).throwIfInvalid();
        this.catalog.save((StoreInfo)original);
        LOGGER.info("PUT wms store " + workspace + "," + wmsstore);
    }

    public boolean allowDelete() {
        return this.getAttribute("wmsstore") != null;
    }

    protected void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        String wmsstore = this.getAttribute("wmsstore");
        boolean recurse = (Boolean)this.getQueryStringValue("recurse", Boolean.class, false);
        WMSStoreInfo wms = (WMSStoreInfo)this.catalog.getStoreByName(workspace, wmsstore, WMSStoreInfo.class);
        if (!recurse) {
            if (!this.catalog.getResourcesByStore((StoreInfo)wms, WMSLayerInfo.class).isEmpty()) {
                throw new RestletException("store not empty", Status.CLIENT_ERROR_FORBIDDEN);
            }
            this.catalog.remove((StoreInfo)wms);
        } else {
            new CascadeDeleteVisitor(this.catalog).visit(wms);
        }
        LOGGER.info("DELETE wms store " + workspace + "," + wmsstore);
    }

    @Override
    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeWMSStore(WMSStoreInfo ds, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.startNode("wmsLayers");
                WMSStoreResource.this.encodeCollectionLink("wmslayers", writer);
                writer.endNode();
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof WorkspaceInfo) {
                    WMSStoreResource.this.encodeLink("/workspaces/" + ref, writer);
                }
            }
        });
    }

    static class WMSStoreHTMLFormat
    extends CatalogFreemarkerHTMLFormat {
        Catalog catalog;

        public WMSStoreHTMLFormat(Request request, Response response, Resource resource, Catalog catalog) {
            super(WMSStoreInfo.class, request, response, resource);
            this.catalog = catalog;
        }

        @Override
        protected Configuration createConfiguration(Object data, Class clazz) {
            Configuration cfg = super.createConfiguration(data, clazz);
            cfg.setObjectWrapper((ObjectWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper<WMSStoreInfo>(WMSStoreInfo.class){

                protected void wrapInternal(Map properties, SimpleHash model, WMSStoreInfo object) {
                    List wmsLayers = WMSStoreHTMLFormat.this.catalog.getResourcesByStore((StoreInfo)object, WMSLayerInfo.class);
                    properties.put("wmsLayers", new CollectionModel((Collection)wmsLayers, (BeansWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper((ReflectiveHTMLFormat)WMSStoreHTMLFormat.this, WMSLayerInfo.class)));
                }
            });
            return cfg;
        }
    }
}

