/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.WMSStoreListResource;
import org.geoserver.catalog.rest.WMSStoreResource;
import org.geoserver.rest.RestletException;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class WMSStoreFinder
extends AbstractCatalogFinder {
    public WMSStoreFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String ws = (String)request.getAttributes().get("workspace");
        String wms = (String)request.getAttributes().get("wmsstore");
        if (ws != null && this.catalog.getWorkspaceByName(ws) == null) {
            throw new RestletException("No such workspace: " + ws, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (wms != null && this.catalog.getStoreByName(ws, wms, WMSStoreInfo.class) == null) {
            boolean quietOnNotFound = this.quietOnNotFoundEnabled(request);
            if (quietOnNotFound) {
                return null;
            }
            throw new RestletException("No such wms store: " + ws + "," + wms, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (wms == null && request.getMethod() == Method.GET) {
            return new WMSStoreListResource(this.getContext(), request, response, this.catalog);
        }
        return new WMSStoreResource(null, request, response, this.catalog);
    }
}

