/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.AvailableWMSLayerResource;
import org.geoserver.catalog.rest.WMSLayerListResource;
import org.geoserver.catalog.rest.WMSLayerResource;
import org.geoserver.rest.RestletException;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class WMSLayerFinder
extends AbstractCatalogFinder {
    protected WMSLayerFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String ws = (String)request.getAttributes().get("workspace");
        String wms = (String)request.getAttributes().get("wmsstore");
        String wl = (String)request.getAttributes().get("wmslayer");
        if (ws != null && this.catalog.getWorkspaceByName(ws) == null) {
            throw new RestletException("No such workspace: " + ws, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (wms != null && this.catalog.getStoreByName(ws, wms, WMSStoreInfo.class) == null) {
            throw new RestletException("No such wms store: " + ws + "," + wms, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (wl != null) {
            boolean quietOnNotFound = this.quietOnNotFoundEnabled(request);
            if (wms != null && this.catalog.getResourceByStore(this.catalog.getStoreByName(ws, wms, WMSStoreInfo.class), wl, WMSLayerInfo.class) == null) {
                if (quietOnNotFound) {
                    return null;
                }
                throw new RestletException("No such cascaded wms layer: " + ws + "," + wms + "," + wl, Status.CLIENT_ERROR_NOT_FOUND);
            }
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(ws);
            if (ns == null || this.catalog.getResourceByName(ns, wl, WMSLayerInfo.class) == null) {
                if (quietOnNotFound) {
                    return null;
                }
                throw new RestletException("No such cascaded wms: " + ws + "," + wl, Status.CLIENT_ERROR_NOT_FOUND);
            }
        } else {
            Form form = request.getResourceRef().getQueryAsForm();
            if ("available".equalsIgnoreCase(form.getFirstValue("list"))) {
                return new AvailableWMSLayerResource(null, request, response, this.catalog);
            }
            if (request.getMethod() == Method.GET) {
                return new WMSLayerListResource(this.getContext(), request, response, this.catalog);
            }
        }
        return new WMSLayerResource(null, request, response, this.catalog);
    }
}

