/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.StyleFormat;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.util.Converters;
import org.geotools.util.Version;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class StyleResource
extends AbstractCatalogResource {
    private List<String> validImageFileExtensions = Arrays.asList("svg", "png", "jpg");

    public StyleResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, StyleInfo.class, catalog);
    }

    protected List<DataFormat> createSupportedFormats(Request request, Response response) {
        List formats = super.createSupportedFormats(request, response);
        boolean prettyPrint = this.isPrettyPrint(request);
        for (StyleHandler sh : Styles.handlers()) {
            for (Version ver : sh.getVersions()) {
                formats.add(new StyleFormat(sh.mimeType(ver), ver, prettyPrint, sh, request));
            }
        }
        return formats;
    }

    boolean isPrettyPrint(Request request) {
        Form q = request.getResourceRef().getQueryAsForm();
        String pretty = q.getFirstValue("pretty");
        return pretty != null && Boolean.TRUE.equals(Converters.convert((Object)pretty, Boolean.class));
    }

    protected Object handleObjectGet() {
        String workspace = this.getAttribute("workspace");
        String style = this.getAttribute("style");
        LOGGER.fine("GET style " + style);
        StyleInfo sinfo = workspace == null ? this.catalog.getStyleByName(style) : this.catalog.getStyleByName(workspace, style);
        return sinfo;
    }

    public boolean allowPost() {
        if (this.getAttribute("workspace") == null && !this.isAuthenticatedAsAdmin()) {
            return false;
        }
        return this.getAttribute("style") == null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String handleObjectPost(Object object) throws Exception {
        GeoServerDataDirectory dataDir;
        String name;
        String workspace = this.getAttribute("workspace");
        String layer = this.getAttribute("layer");
        if (object instanceof StyleInfo) {
            StyleInfo style = (StyleInfo)object;
            if (layer != null) {
                StyleInfo existing = this.catalog.getStyleByName(style.getName());
                if (existing == null) {
                    throw new RestletException("No such style: " + style.getName(), Status.CLIENT_ERROR_NOT_FOUND);
                }
                LayerInfo l = this.catalog.getLayerByName(layer);
                l.getStyles().add(existing);
                String def = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("default");
                if ("true".equals(def)) {
                    l.setDefaultStyle(existing);
                }
                this.catalog.save(l);
                LOGGER.info("POST style " + style.getName() + " to layer " + layer);
                return style.getName();
            }
            if (workspace != null) {
                style.setWorkspace(this.catalog.getWorkspaceByName(workspace));
            }
            this.catalog.add(style);
            LOGGER.info("POST style " + style.getName());
            return style.getName();
        }
        if (this.getRequest().getEntity().getMediaType().equals((Object)MediaType.APPLICATION_ZIP) && object instanceof InputStream) {
            String string;
            File directory = null;
            try {
                GeoServerDataDirectory dataDir2;
                directory = this.unzipSldPackage((InputStream)object);
                File uploadedFile = this.retrieveSldFile(directory);
                Style styleSld = this.parseSld(uploadedFile);
                String name2 = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("name");
                if (name2 == null) {
                    name2 = this.findNameFromObject(styleSld);
                }
                if (this.catalog.getStyleByName(workspace, name2) != null) {
                    throw new RestletException("Style " + name2 + " already exists.", Status.CLIENT_ERROR_FORBIDDEN);
                }
                this.saveImageResources(directory, workspace);
                StyleInfo styleInfo = this.catalog.getFactory().createStyle();
                styleInfo.setName(name2);
                styleInfo.setFilename(name2 + ".sld");
                if (workspace != null) {
                    styleInfo.setWorkspace(this.catalog.getWorkspaceByName(workspace));
                }
                if ((dataDir2 = new GeoServerDataDirectory(this.catalog.getResourceLoader())).style(styleInfo).getType() != Resource.Type.UNDEFINED) {
                    String msg = "Style resource " + styleInfo.getFilename() + " already exists.";
                    throw new RestletException(msg, Status.CLIENT_ERROR_FORBIDDEN);
                }
                this.serializeSldFileInCatalog(new File(this.getStylePath(styleInfo)), uploadedFile);
                this.catalog.add(styleInfo);
                LOGGER.info("POST Style Package: " + name2 + ", workspace: " + workspace);
                string = name2;
            }
            catch (RestletException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        e2.printStackTrace();
                        LOGGER.severe("Error processing the style package (POST): " + e2.getMessage());
                        throw new RestletException("Error processing the style", Status.SERVER_ERROR_INTERNAL, (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.deleteQuietly(directory);
                    throw throwable;
                }
            }
            FileUtils.deleteQuietly((File)directory);
            return string;
        }
        if (!(object instanceof Style)) {
            if (!(object instanceof InputStream)) return null;
        }
        if ((name = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("name")) == null) {
            name = this.findNameFromObject(object);
        }
        if (this.catalog.getStyleByName(workspace, name) != null) {
            throw new RestletException("Style " + name + " already exists.", Status.CLIENT_ERROR_FORBIDDEN);
        }
        StyleHandler styleFormat = ((StyleFormat)this.getFormatPostOrPut()).getHandler();
        StyleInfo sinfo = this.catalog.getFactory().createStyle();
        sinfo.setName(name);
        sinfo.setFilename(name + "." + styleFormat.getFileExtension());
        sinfo.setFormat(styleFormat.getFormat());
        sinfo.setFormatVersion(styleFormat.versionForMimeType(this.getRequest().getEntity().getMediaType().getName()));
        if (workspace != null) {
            sinfo.setWorkspace(this.catalog.getWorkspaceByName(workspace));
        }
        if ((dataDir = new GeoServerDataDirectory(this.catalog.getResourceLoader())).style(sinfo).getType() != Resource.Type.UNDEFINED) {
            String msg = "Style resource " + sinfo.getFilename() + " already exists.";
            throw new RestletException(msg, Status.CLIENT_ERROR_FORBIDDEN);
        }
        ResourcePool resourcePool = this.catalog.getResourcePool();
        try {
            if (object instanceof Style) {
                resourcePool.writeStyle(sinfo, (Style)object);
            } else {
                resourcePool.writeStyle(sinfo, (InputStream)object);
            }
        }
        catch (IOException e) {
            throw new RestletException("Error writing style", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        this.catalog.add(sinfo);
        LOGGER.info("POST Style " + name);
        return name;
    }

    String findNameFromObject(Object object) {
        String name = null;
        if (object instanceof Style) {
            name = ((Style)object).getName();
        }
        if (name == null) {
            for (int i = 0; name == null && i < 100; ++i) {
                String candidate = "style-" + UUID.randomUUID().toString().substring(0, 7);
                if (this.catalog.getStyleByName(candidate) != null) continue;
                name = candidate;
            }
        }
        if (name == null) {
            throw new RestletException("Unable to generate style name, specify one with 'name' parameter", Status.SERVER_ERROR_INTERNAL);
        }
        return name;
    }

    public boolean allowPut() {
        if (this.getAttribute("workspace") == null && !this.isAuthenticatedAsAdmin()) {
            return false;
        }
        return this.getAttribute("style") != null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleObjectPut(Object object) throws Exception {
        String style = this.getAttribute("style");
        String workspace = this.getAttribute("workspace");
        if (object instanceof StyleInfo) {
            StyleInfo s = (StyleInfo)object;
            StyleInfo original = this.catalog.getStyleByName(workspace, style);
            if (s.getWorkspace() != null && !s.getWorkspace().equals(original.getWorkspace())) {
                throw new RestletException("Can't change the workspace of a style, instead DELETE from existing workspace and POST to new workspace", Status.CLIENT_ERROR_FORBIDDEN);
            }
            new CatalogBuilder(this.catalog).updateStyle(original, s);
            this.catalog.save(original);
        } else if (this.getRequest().getEntity().getMediaType().equals((Object)MediaType.APPLICATION_ZIP) && object instanceof InputStream) {
            File directory = null;
            try {
                directory = this.unzipSldPackage((InputStream)object);
                File uploadedFile = this.retrieveSldFile(directory);
                Style styleSld = this.parseSld(uploadedFile);
                String name = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("name");
                if (name == null) {
                    name = this.findNameFromObject(styleSld);
                }
                if (name == null) {
                    throw new RestletException("Style must have a name.", Status.CLIENT_ERROR_BAD_REQUEST);
                }
                if (!this.existsStyleInCatalog(workspace, name)) {
                    throw new RestletException("Style " + name + " doesn't exists.", Status.CLIENT_ERROR_FORBIDDEN);
                }
                this.saveImageResources(directory, workspace);
                StyleInfo styleInfo = this.catalog.getStyleByName(workspace, style);
                this.serializeSldFileInCatalog(new File(this.getStylePath(styleInfo)), uploadedFile);
                LOGGER.info("PUT Style Package: " + name + ", workspace: " + workspace);
            }
            catch (RestletException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        e2.printStackTrace();
                        LOGGER.severe("Error processing the style package (PUT): " + e2.getMessage());
                        throw new RestletException("Error processing the style", Status.SERVER_ERROR_INTERNAL, (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.deleteQuietly(directory);
                    throw throwable;
                }
            }
            FileUtils.deleteQuietly((File)directory);
        } else if (object instanceof Style || object instanceof InputStream) {
            StyleInfo s = this.catalog.getStyleByName(workspace, style);
            ResourcePool resourcePool = this.catalog.getResourcePool();
            if (object instanceof Style) {
                resourcePool.writeStyle(s, (Style)object, true);
            } else {
                resourcePool.writeStyle(s, (InputStream)object);
            }
            this.catalog.save(s);
        } else if (object instanceof InputStream) {
            LOGGER.info("PUT style InputStream");
        }
        LOGGER.info("PUT style " + style);
    }

    public boolean allowDelete() {
        return this.getAttribute("style") != null;
    }

    protected void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        String style = this.getAttribute("style");
        StyleInfo s = workspace != null ? this.catalog.getStyleByName(workspace, style) : this.catalog.getStyleByName(style);
        List layers = this.catalog.getLayers(s);
        if (!layers.isEmpty()) {
            throw new RestletException("Can't delete style referenced by existing layers.", Status.CLIENT_ERROR_FORBIDDEN);
        }
        this.catalog.remove(s);
        String p = this.getRequest().getResourceRef().getQueryAsForm().getFirstValue("purge");
        boolean purge = p != null ? Boolean.parseBoolean(p) : false;
        this.catalog.getResourcePool().deleteStyle(s, purge);
        LOGGER.info("DELETE style " + style);
    }

    private File unzipSldPackage(InputStream object) throws IOException {
        File tempDir = Files.createTempDir();
        org.geoserver.data.util.IOUtils.decompress((InputStream)object, (File)tempDir);
        return tempDir;
    }

    private File retrieveSldFile(File directory) {
        File[] matchingFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("sld");
            }
        });
        if (matchingFiles.length == 0) {
            throw new RestletException("No sld file provided:", Status.CLIENT_ERROR_FORBIDDEN);
        }
        LOGGER.fine("retrieveSldFile (sldFile): " + matchingFiles[0].getAbsolutePath());
        return matchingFiles[0];
    }

    private void saveImageResources(File directory, String workspace) throws IOException {
        File stylesDir = new File(this.getStylesFolderPath(workspace));
        File[] imageFiles = this.retrieveImageFiles(directory);
        for (int i = 0; i < imageFiles.length; ++i) {
            FileUtils.copyFileToDirectory((File)imageFiles[i], (File)stylesDir);
        }
    }

    private File[] retrieveImageFiles(File directory) {
        File[] matchingFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return StyleResource.this.validImageFileExtensions.contains(FilenameUtils.getExtension((String)name).toLowerCase());
            }
        });
        return matchingFiles;
    }

    private Style parseSld(File sldFile) {
        Style style;
        Style style2 = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(sldFile);
            SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null), (InputStream)is);
            Style[] styles = parser.readXML();
            if (styles.length > 0) {
                style2 = styles[0];
            }
            if (style2 == null) {
                throw new RestletException("Style error.", Status.CLIENT_ERROR_BAD_REQUEST);
            }
            style = style2;
        }
        catch (Exception ex) {
            try {
                LOGGER.severe(ex.getMessage());
                throw new RestletException("Style error.", Status.CLIENT_ERROR_BAD_REQUEST);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return style;
    }

    private boolean existsStyleInCatalog(String workspaceName, String name) {
        return this.catalog.getStyleByName(workspaceName, name) != null;
    }

    private void serializeSldFileInCatalog(File sldFile, File uploadedSldFile) {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(sldFile));
            byte[] sldContent = FileUtils.readFileToByteArray((File)uploadedSldFile);
            out.write(sldContent);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new RestletException("Error creating file", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private String getStylePath(StyleInfo styleInfo) {
        String workspaceName = styleInfo.getWorkspace() != null ? styleInfo.getWorkspace().getName() : null;
        String stylesFolder = this.getStylesFolderPath(workspaceName);
        String stylePath = stylesFolder + "/" + styleInfo.getFilename();
        return stylePath;
    }

    private String getStylesFolderPath(String workspace) {
        String path = "styles" + File.separator;
        if (workspace != null) {
            path = "workspaces" + File.separator + workspace + File.separator + path;
        }
        path = this.catalog.getResourceLoader().getBaseDirectory().getAbsolutePath() + File.separator + path;
        return path;
    }
}

