/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.format.StreamDataFormat;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.Converters;
import org.geotools.util.Version;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;

public class StyleFormat
extends StreamDataFormat {
    StyleHandler handler;
    Version version;
    boolean prettyPrint;
    Request request;

    public StyleFormat(String mimeType, Version version, boolean prettyPrint, StyleHandler handler, Request request) {
        super(new MediaType(mimeType));
        this.version = version;
        this.prettyPrint = prettyPrint;
        this.handler = handler;
        this.request = request;
    }

    public StyleHandler getHandler() {
        return this.handler;
    }

    protected void write(Object object, OutputStream out) throws IOException {
        StyleInfo style;
        if (object instanceof StyleInfo) {
            style = (StyleInfo)object;
            if (this.handler.getFormat().equalsIgnoreCase(style.getFormat())) {
                this.copyFromFile(style, out);
                return;
            }
        }
        style = object instanceof StyleInfo ? ((StyleInfo)object).getStyle() : (Style)object;
        StyledLayerDescriptor sld = Styles.sld((Style)style);
        this.handler.encode(sld, this.version, this.prettyPrint, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyFromFile(StyleInfo style, OutputStream out) throws IOException {
        GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerExtensions.bean(GeoServerDataDirectory.class);
        Resource resource = dd.style(style);
        try (InputStream in = resource.in();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    protected Object read(InputStream in) throws IOException {
        if (this.request.getEntity().getMediaType().equals((Object)MediaType.APPLICATION_ZIP)) {
            return in;
        }
        if (this.isRawUpload(this.request)) {
            return in;
        }
        return Styles.style((StyledLayerDescriptor)this.handler.parse((Object)in, this.version, null, null));
    }

    boolean isRawUpload(Request request) {
        Form q = request.getResourceRef().getQueryAsForm();
        String raw = q.getFirstValue("raw");
        return raw != null && Boolean.TRUE.equals(Converters.convert((Object)raw, Boolean.class));
    }
}

