/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.StyleListResource;
import org.geoserver.catalog.rest.StyleResource;
import org.geoserver.platform.ContextLoadedEvent;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.MediaTypes;
import org.geotools.util.Version;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class StyleFinder
extends AbstractCatalogFinder
implements ApplicationListener {
    public StyleFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String workspace = this.getAttribute(request, "workspace");
        String style = this.getAttribute(request, "style");
        String layer = this.getAttribute(request, "layer");
        if (workspace != null && this.catalog.getWorkspaceByName(workspace) == null) {
            throw new RestletException("No such workspace: " + workspace, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (style != null) {
            boolean quietOnNotFound = this.quietOnNotFoundEnabled(request);
            if (workspace != null && this.catalog.getStyleByName(workspace, style) == null) {
                if (quietOnNotFound) {
                    return null;
                }
                throw new RestletException(String.format("No such style %s in workspace %s", style, workspace), Status.CLIENT_ERROR_NOT_FOUND);
            }
            if (workspace == null && this.catalog.getStyleByName(style) == null) {
                if (quietOnNotFound) {
                    return null;
                }
                throw new RestletException("No such style: " + style, Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        if (layer != null && this.catalog.getLayerByName(layer) == null) {
            throw new RestletException("No such layer: " + layer, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (style == null && request.getMethod() == Method.GET) {
            return new StyleListResource(this.getContext(), request, response, this.catalog);
        }
        return new StyleResource(this.getContext(), request, response, this.catalog);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextLoadedEvent) {
            for (StyleHandler sh : Styles.handlers()) {
                Version ver = (Version)sh.getVersions().iterator().next();
                MediaTypes.registerExtension((String)sh.getFileExtension(), (MediaType)new MediaType(sh.mimeType(ver)));
            }
        }
    }
}

