/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.List;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.impl.AttributeTypeInfoImpl;
import org.geoserver.catalog.rest.CatalogResourceBase;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class StructuredGridCoverageIndexResource
extends CatalogResourceBase {
    private CoverageInfo coverage;

    public StructuredGridCoverageIndexResource(Context context, Request request, Response response, Catalog catalog, CoverageInfo coverage) {
        super(context, request, response, IndexSchema.class, catalog);
        this.coverage = coverage;
    }

    protected Object handleObjectGet() throws Exception {
        String nativeCoverageName = this.coverage.getNativeCoverageName();
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)this.coverage.getGridCoverageReader(null, null);
        if (nativeCoverageName == null) {
            if (reader.getGridCoverageNames().length > 1) {
                throw new IllegalStateException("The grid coverage configuration for " + this.coverage.getName() + " does not specify a native coverage name, yet the reader provides more than one coverage. " + "Please assign a native coverage name (the GUI does so automatically)");
            }
            nativeCoverageName = reader.getGridCoverageNames()[0];
        }
        GranuleSource source = reader.getGranules(nativeCoverageName, true);
        SimpleFeatureType schema = source.getSchema();
        List attributes = new CatalogBuilder(this.catalog).getAttributes((FeatureType)schema, null);
        return new IndexSchema(attributes);
    }

    protected void configureXStream(XStream xstream) {
        super.configureXStream(xstream);
        xstream.alias("Schema", IndexSchema.class);
        xstream.alias("Attribute", AttributeTypeInfoImpl.class);
        xstream.omitField(AttributeTypeInfoImpl.class, "featureType");
        xstream.omitField(AttributeTypeInfoImpl.class, "metadata");
        xstream.registerConverter((Converter)new IndexSchemaConverter(xstream));
    }

    static class IndexSchema {
        List<AttributeTypeInfo> attributes;

        public IndexSchema(List<AttributeTypeInfo> attributes) {
            this.attributes = attributes;
        }
    }

    class IndexSchemaConverter
    extends ReflectionConverter {
        public IndexSchemaConverter(XStream xstream) {
            super(xstream.getMapper(), xstream.getReflectionProvider());
        }

        public boolean canConvert(Class type) {
            return type.equals(IndexSchema.class);
        }

        public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.marshal(original, writer, context);
            StructuredGridCoverageIndexResource.this.encodeLink("granules", writer);
        }
    }
}

