/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.GranuleResource;
import org.geoserver.catalog.rest.GranulesResource;
import org.geoserver.catalog.rest.StructuredGridCoverageIndexResource;
import org.geoserver.rest.RestletException;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.opengis.coverage.grid.GridCoverageReader;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class StructuredGridCoverageFinder
extends AbstractCatalogFinder {
    public StructuredGridCoverageFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String ws = this.getAttribute(request, "workspace");
        String cs = this.getAttribute(request, "coveragestore");
        String c = this.getAttribute(request, "coverage");
        String lastSegment = request.getResourceRef().getLastSegment();
        boolean granules = lastSegment.equals("granules") || lastSegment.matches("granules\\..*");
        String granule = this.getAttribute(request, "granule");
        if (ws == null || cs == null || c == null) {
            throw new RestletException("Invalid path, workspace, store and coverage name must be specified", Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (this.catalog.getWorkspaceByName(ws) == null) {
            throw new RestletException("No such workspace: " + ws, Status.CLIENT_ERROR_NOT_FOUND);
        }
        CoverageStoreInfo store = this.catalog.getCoverageStoreByName(ws, cs);
        if (store == null) {
            throw new RestletException("No such coveragestore: " + ws + "," + cs, Status.CLIENT_ERROR_NOT_FOUND);
        }
        CoverageInfo coverage = this.catalog.getCoverageByCoverageStore(store, c);
        if (coverage == null) {
            throw new RestletException("No such coverage: " + c + " in store " + ws + "/" + cs, Status.CLIENT_ERROR_NOT_FOUND);
        }
        try {
            GridCoverageReader reader = coverage.getGridCoverageReader(null, null);
            if (!(reader instanceof StructuredGridCoverage2DReader)) {
                throw new RestletException("Coverage exists, but is no structured grid coverage, no index and inner granules are available", Status.CLIENT_ERROR_NOT_FOUND);
            }
            if (!granules && granule == null) {
                return new StructuredGridCoverageIndexResource(this.getContext(), request, response, this.catalog, coverage);
            }
            if (granule == null) {
                if (granules) {
                    return new GranulesResource(this.getContext(), request, response, this.catalog, coverage);
                }
                throw new RestletException("Invalid path", Status.CLIENT_ERROR_NOT_FOUND);
            }
            boolean quietOnNotFound = this.quietOnNotFoundEnabled(request);
            GranuleResource granuleResource = new GranuleResource(this.getContext(), request, response, this.catalog, coverage, granule);
            try {
                granuleResource.handleObjectGet();
            }
            catch (Exception e) {
                if (e instanceof RestletException && ((RestletException)((Object)e)).getStatus().equals((Object)Status.CLIENT_ERROR_NOT_FOUND)) {
                    if (quietOnNotFound) {
                        return null;
                    }
                    throw (RestletException)((Object)e);
                }
                throw new IOException(e);
            }
            return granuleResource;
        }
        catch (IOException e) {
            throw new RestletException("Failed to load coverage information", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
    }
}

