/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.util.RESTUploadPathMapper;
import org.geoserver.rest.util.RESTUtils;
import org.geotools.data.DataUtilities;
import org.geotools.util.logging.Logging;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public abstract class StoreFileResource
extends Resource {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog.rest");
    protected Catalog catalog;

    public StoreFileResource(Request request, Response response, Catalog catalog) {
        super(null, request, response);
        this.catalog = catalog;
    }

    public boolean allowPut() {
        return true;
    }

    protected String getAttribute(String attribute) {
        return RESTUtils.getAttribute((Request)this.getRequest(), (String)attribute);
    }

    protected String getUploadMethod(Request request) {
        return request.getResourceRef().getLastSegment().toLowerCase();
    }

    protected boolean isInlineUpload(String method) {
        return method != null && (method.startsWith("file.") || method.startsWith("url."));
    }

    protected List<File> doFileUpload(String method, String workspaceName, String storeName, String format) {
        File directory = null;
        if (this.isInlineUpload(method)) {
            try {
                directory = method.startsWith("url.") ? this.createFinalRoot(null, null) : this.createFinalRoot(workspaceName, storeName);
            }
            catch (IOException e) {
                throw new RestletException(e.getMessage(), Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
        }
        return this.handleFileUpload(storeName, workspaceName, format, directory);
    }

    private File createFinalRoot(String workspaceName, String storeName) throws IOException {
        CoverageStoreInfo coverage;
        Method method = this.getRequest().getMethod();
        boolean isPost = method.equals((Object)Method.POST);
        File directory = null;
        if (isPost && storeName != null && (coverage = this.catalog.getCoverageStoreByName(storeName)) != null && (workspaceName == null || workspaceName != null && coverage.getWorkspace().getName().equalsIgnoreCase(workspaceName))) {
            File dirFile = DataUtilities.urlToFile((URL)new URL(coverage.getURL()));
            directory = !dirFile.exists() ? this.catalog.getResourceLoader().findOrCreateDirectory(dirFile, "") : dirFile;
        }
        if (directory == null) {
            directory = this.catalog.getResourceLoader().findOrCreateDirectory(new String[]{"data", workspaceName, storeName});
        }
        StringBuilder root = new StringBuilder(directory.getAbsolutePath());
        HashMap storeParams = new HashMap();
        List mappers = GeoServerExtensions.extensions(RESTUploadPathMapper.class);
        for (RESTUploadPathMapper mapper : mappers) {
            mapper.mapStorePath(root, workspaceName, storeName, storeParams);
        }
        directory = new File(root.toString());
        directory.mkdirs();
        return directory;
    }

    protected List<File> handleFileUpload(String store, String workspace, String format, File directory) {
        boolean external;
        File uploadedFile;
        ArrayList<File> files;
        MediaType mediaType;
        block15: {
            this.getResponse().setStatus(Status.SUCCESS_ACCEPTED);
            mediaType = this.getRequest().getEntity().getMediaType();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("PUT file, mimetype: " + mediaType);
            }
            files = new ArrayList<File>();
            uploadedFile = null;
            external = false;
            try {
                String method = this.getRequest().getResourceRef().getLastSegment();
                if (method != null && method.toLowerCase().startsWith("file.")) {
                    uploadedFile = RESTUtils.handleBinUpload((String)(store + "." + format), (String)workspace, (File)directory, (Request)this.getRequest());
                    break block15;
                }
                if (method != null && method.toLowerCase().startsWith("url.")) {
                    uploadedFile = RESTUtils.handleURLUpload((String)(store + "." + format), (String)workspace, (File)directory, (Request)this.getRequest());
                    break block15;
                }
                if (method != null && method.toLowerCase().startsWith("external.")) {
                    uploadedFile = RESTUtils.handleEXTERNALUpload((Request)this.getRequest());
                    external = true;
                    break block15;
                }
                StringBuilder builder = new StringBuilder("Unrecognized file upload method: ").append(method);
                throw new RestletException(builder.toString(), Status.CLIENT_ERROR_BAD_REQUEST);
            }
            catch (Throwable t) {
                if (t instanceof RestletException) {
                    throw (RestletException)t;
                }
                throw new RestletException("Error while storing uploaded file:", Status.SERVER_ERROR_INTERNAL, t);
            }
        }
        if (mediaType != null && RESTUtils.isZipMediaType((MediaType)mediaType)) {
            if (!uploadedFile.getName().endsWith(".zip")) {
                File newUploadedFile = new File(uploadedFile.getParentFile(), FilenameUtils.getBaseName((String)uploadedFile.getAbsolutePath()) + ".zip");
                String oldFileName = uploadedFile.getName();
                if (!uploadedFile.renameTo(newUploadedFile)) {
                    String errorMessage = "Error renaming zip file from " + oldFileName + " -> " + newUploadedFile.getName();
                    throw new RestletException(errorMessage, Status.SERVER_ERROR_INTERNAL);
                }
                uploadedFile = newUploadedFile;
            }
            try {
                RESTUtils.unzipFile((File)uploadedFile, (File)directory, (String)workspace, (String)store, (Request)this.getRequest(), files, (boolean)external);
                File primaryFile = this.findPrimaryFile(directory, format);
                if (primaryFile == null) {
                    throw new RestletException("Could not find appropriate " + format + " file in archive", Status.CLIENT_ERROR_BAD_REQUEST);
                }
                uploadedFile = primaryFile;
            }
            catch (RestletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestletException("Error occured unzipping file", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
        }
        if (files.isEmpty() && uploadedFile != null) {
            files.add(uploadedFile);
        }
        return files;
    }

    protected File findPrimaryFile(File directory, String format) {
        Iterator i$ = FileUtils.listFiles((File)directory, (String[])new String[]{format}, (boolean)true).iterator();
        if (i$.hasNext()) {
            File f = (File)i$.next();
            return f;
        }
        return null;
    }
}

