/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.format.DataFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class LayerResource
extends AbstractCatalogResource {
    public LayerResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, LayerInfo.class, catalog);
    }

    protected Object handleObjectGet() throws Exception {
        String layer = this.getAttribute("layer");
        if (layer == null) {
            return this.catalog.getLayers();
        }
        return this.catalog.getLayerByName(layer);
    }

    protected String handleObjectPost(Object object) throws Exception {
        return null;
    }

    public boolean allowPut() {
        return this.getAttribute("layer") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        String l = this.getAttribute("layer");
        LayerInfo original = this.catalog.getLayerByName(l);
        LayerInfo layer = (LayerInfo)object;
        layer.setResource(original.getResource());
        new CatalogBuilder(this.catalog).updateLayer(original, layer);
        this.catalog.save(original);
        LOGGER.info("PUT layer " + l);
    }

    public boolean allowDelete() {
        return this.getAttribute("layer") != null;
    }

    protected void handleObjectDelete() throws Exception {
        String l = this.getAttribute("layer");
        boolean recurse = (Boolean)this.getQueryStringValue("recurse", Boolean.class, false);
        LayerInfo layer = this.catalog.getLayerByName(l);
        if (!recurse) {
            this.catalog.remove(layer);
        } else {
            new CascadeDeleteVisitor(this.catalog).visit(layer);
        }
        LOGGER.info("DELETE layer " + l);
    }

    @Override
    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                StringBuffer link;
                if (obj instanceof StyleInfo) {
                    StyleInfo style = (StyleInfo)obj;
                    link = new StringBuffer();
                    if (style.getWorkspace() != null) {
                        String wsName = style.getWorkspace().getName();
                        writer.startNode("workspace");
                        writer.setValue(wsName);
                        writer.endNode();
                        link.append("/workspaces/").append(LayerResource.this.encode(wsName));
                    }
                    link.append("/styles/").append(LayerResource.this.encode(style.getName()));
                    LayerResource.this.encodeLink(link.toString(), writer);
                }
                if (obj instanceof ResourceInfo) {
                    ResourceInfo r = (ResourceInfo)obj;
                    link = new StringBuffer("/workspaces/").append(LayerResource.this.encode(r.getStore().getWorkspace().getName())).append("/");
                    if (r instanceof FeatureTypeInfo) {
                        link.append("datastores/").append(LayerResource.this.encode(r.getStore().getName())).append("/featuretypes/");
                    } else if (r instanceof CoverageInfo) {
                        link.append("coveragestores/").append(LayerResource.this.encode(r.getStore().getName())).append("/coverages/");
                    } else if (r instanceof WMSLayerInfo) {
                        link.append("wmsstores/").append(LayerResource.this.encode(r.getStore().getName())).append("/wmslayers/");
                    } else {
                        return;
                    }
                    link.append(LayerResource.this.encode(r.getName()));
                    LayerResource.this.encodeLink(link.toString(), writer);
                }
            }
        });
    }
}

