/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class LayerGroupResource
extends AbstractCatalogResource {
    public LayerGroupResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, LayerGroupInfo.class, catalog);
    }

    protected Object handleObjectGet() throws Exception {
        String ws = this.getAttribute("workspace");
        String lg = this.getAttribute("layergroup");
        LOGGER.fine("GET layer group " + lg);
        return ws == null ? this.catalog.getLayerGroupByName(lg) : this.catalog.getLayerGroupByName(ws, lg);
    }

    public boolean allowPost() {
        if (this.getAttribute("workspace") == null && !this.isAuthenticatedAsAdmin()) {
            return false;
        }
        return this.getAttribute("layergroup") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        String ws = this.getAttribute("workspace");
        LayerGroupInfo lg = (LayerGroupInfo)object;
        LOGGER.info("POST layer group " + lg.getName() + ws != null ? " to workspace " + ws : "");
        if (lg.getLayers().isEmpty()) {
            throw new RestletException("layer group must not be empty", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        if (lg.getBounds() == null) {
            LOGGER.fine("Auto calculating layer group bounds");
            new CatalogBuilder(this.catalog).calculateLayerGroupBounds(lg);
        }
        if (ws != null) {
            lg.setWorkspace(this.catalog.getWorkspaceByName(ws));
        }
        if (lg.getMode() == null) {
            LOGGER.fine("Setting layer group mode SINGLE");
            lg.setMode(LayerGroupInfo.Mode.SINGLE);
        }
        this.catalog.add(lg);
        return lg.getName();
    }

    public boolean allowPut() {
        if (this.getAttribute("workspace") == null && !this.isAuthenticatedAsAdmin()) {
            return false;
        }
        return this.getAttribute("layergroup") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        String workspace = this.getAttribute("workspace");
        String layergroup = this.getAttribute("layergroup");
        LOGGER.info("PUT layer group " + layergroup + workspace == null ? ", workspace " + workspace : "");
        LayerGroupInfo lg = (LayerGroupInfo)object;
        LayerGroupInfo original = this.catalog.getLayerGroupByName(workspace, layergroup);
        if (lg.getName() != null && !lg.getName().equals(original.getName())) {
            throw new RestletException("Can't change name of a layer group", Status.CLIENT_ERROR_FORBIDDEN);
        }
        if (lg.getWorkspace() != null && !lg.getWorkspace().equals(original.getWorkspace())) {
            throw new RestletException("Can't change the workspace of a layer group, instead DELETE from existing workspace and POST to new workspace", Status.CLIENT_ERROR_FORBIDDEN);
        }
        new CatalogBuilder(this.catalog).updateLayerGroup(original, lg);
        this.catalog.save(original);
    }

    public boolean allowDelete() {
        return this.getAttribute("layergroup") != null;
    }

    protected void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        String layergroup = this.getAttribute("layergroup");
        LOGGER.info("DELETE layer group " + layergroup);
        LayerGroupInfo lg = workspace == null ? this.catalog.getLayerGroupByName(layergroup) : this.catalog.getLayerGroupByName(workspace, layergroup);
        this.catalog.remove(lg);
    }

    @Override
    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof StyleInfo) {
                    StringBuffer link = new StringBuffer();
                    if (prefix != null) {
                        link.append("/workspaces/").append(LayerGroupResource.this.encode(prefix));
                    }
                    link.append("/styles/").append(LayerGroupResource.this.encode(ref));
                    LayerGroupResource.this.encodeLink(link.toString(), writer);
                }
                if (obj instanceof LayerInfo) {
                    LayerGroupResource.this.encodeLink("/layers/" + LayerGroupResource.this.encode(ref), writer);
                }
            }
        });
    }
}

