/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.ResourceHTMLFormat;
import org.geoserver.config.util.SecureXStream;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.ReflectiveXMLFormat;
import org.opengis.coverage.grid.GridCoverageReader;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Resource;

public class HarvestedCoveragesResource
extends AbstractCatalogResource {
    public HarvestedCoveragesResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, CoverageInfo.class, catalog);
    }

    @Override
    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new ResourceHTMLFormat(CoverageInfo.class, request, response, (Resource)this);
    }

    protected Object handleObjectGet() throws Exception {
        String workspace = this.getAttribute("workspace");
        String coveragestore = this.getAttribute("coveragestore");
        String coverage = this.getAttribute("coverage");
        LOGGER.fine("GET coverage " + coveragestore + "," + coverage);
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName(workspace, coveragestore);
        GridCoverageReader reader = cs.getGridCoverageReader(null, null);
        String[] coverageNames = reader.getGridCoverageNames();
        ArrayList<String> coverages = new ArrayList<String>();
        for (String name : coverageNames) {
            coverages.add(name);
        }
        return coverages;
    }

    @Override
    protected ReflectiveXMLFormat createXMLFormat(Request request, Response response) {
        return new ReflectiveXMLFormat(){

            protected void write(Object data, OutputStream output) throws IOException {
                SecureXStream xstream = new SecureXStream();
                xstream.alias("coverageName", String.class);
                xstream.toXML(data, output);
            }
        };
    }

    void clear(CoverageInfo info) {
        this.catalog.getResourcePool().clear(info.getStore());
    }
}

