/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.rest.AbstractGranuleResource;
import org.geoserver.rest.RestletException;
import org.geotools.data.Query;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.filter.Filter;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class GranulesResource
extends AbstractGranuleResource {
    public GranulesResource(Context context, Request request, Response response, Catalog catalog, CoverageInfo coverage) {
        super(context, request, response, catalog, coverage);
    }

    @Override
    protected Query getResourceQuery() {
        Query q = new Query(Query.ALL);
        Form form = this.getRequest().getResourceRef().getQueryAsForm();
        Filter filter = this.parseFilter(form);
        if (filter != null) {
            q.setFilter(filter);
        }
        Integer offset = this.getNonNegativeVariable(form, "offset", true);
        q.setStartIndex(offset);
        Integer limit = this.getNonNegativeVariable(form, "limit", true);
        if (limit != null) {
            q.setMaxFeatures(limit.intValue());
        }
        return q;
    }

    private Filter parseFilter(Form form) {
        String cql = form.getFirstValue("filter");
        if (cql != null) {
            try {
                return ECQL.toFilter((String)cql);
            }
            catch (CQLException e) {
                throw new RestletException("Invalid cql syntax: " + e.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
            }
        }
        return null;
    }

    private Integer getNonNegativeVariable(Form form, String variable, boolean allowZero) {
        String offset = form.getFirstValue(variable);
        if (offset != null) {
            try {
                int value = Integer.parseInt(offset);
                if (value < 0 || !allowZero && value == 0) {
                    throw new RestletException("Invalid " + variable + " value, : " + value, Status.CLIENT_ERROR_BAD_REQUEST);
                }
                return value;
            }
            catch (NumberFormatException e) {
                throw new RestletException("Invalid " + variable + " value, must be a positive integer: " + e.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
            }
        }
        return null;
    }
}

