/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.rest.AbstractGranuleResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class GranuleResource
extends AbstractGranuleResource {
    private String granuleId;
    private String format = "xml";

    public GranuleResource(Context context, Request request, Response response, Catalog catalog, CoverageInfo coverage, String granuleId) {
        super(context, request, response, catalog, coverage);
        if (granuleId.endsWith(".xml")) {
            this.format = "xml";
            granuleId = granuleId.substring(0, granuleId.length() - 4);
        } else if (granuleId.endsWith(".json")) {
            this.format = "json";
            granuleId = granuleId.substring(0, granuleId.length() - 5);
        }
        this.granuleId = granuleId;
    }

    protected DataFormat getFormatGet() {
        if ("xml".equals(this.format)) {
            return new AbstractGranuleResource.FeaturesGMLFormat(this);
        }
        if ("json".equals(this.format)) {
            return new AbstractGranuleResource.FeaturesJSONFormat(this);
        }
        throw new IllegalArgumentException("Only supported formats are xml and json, this one is not supported: " + this.format);
    }

    @Override
    protected Object handleObjectGet() throws Exception {
        SimpleFeatureCollection fc = (SimpleFeatureCollection)super.handleObjectGet();
        if (fc.size() == 0) {
            throw new RestletException("Could not find a granule with id " + this.granuleId + " in coveage " + this.coverage.getPrefixedName(), Status.CLIENT_ERROR_NOT_FOUND);
        }
        return fc;
    }

    @Override
    protected Query getResourceQuery() {
        Id filter = FF.id(new FeatureId[]{FF.featureId(this.granuleId)});
        return new Query(null, (Filter)filter);
    }
}

