/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.StoreFileResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.MediaTypes;
import org.geoserver.rest.util.RESTUtils;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.FileRepresentation;
import org.restlet.resource.Representation;

public class FreemarkerTemplateResource
extends StoreFileResource {
    public static final String MEDIATYPE_FTL_EXTENSION = "ftl";
    public static final MediaType MEDIATYPE_FTL = new MediaType("text/plain");

    public FreemarkerTemplateResource(Request request, Response response, Catalog catalog) {
        super(request, response, catalog);
    }

    public boolean allowGet() {
        return true;
    }

    @Override
    public boolean allowPut() {
        return true;
    }

    public boolean allowDelete() {
        return true;
    }

    public boolean allowPost() {
        return false;
    }

    public void handleGet() {
        this.getResponse().setEntity((Representation)new FileRepresentation(this.getTemplateFile(), MEDIATYPE_FTL, 0));
    }

    public void handlePut() {
        this.doFileUpload();
        this.getResponse().setStatus(Status.SUCCESS_CREATED);
    }

    public void handleDelete() {
        if (this.getTemplateFile().delete()) {
            this.getResponse().setStatus(Status.SUCCESS_OK);
        } else {
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
        }
    }

    private File doFileUpload() {
        try {
            this.getResponse().setStatus(Status.SUCCESS_ACCEPTED);
            File directory = this.catalog.getResourceLoader().findOrCreateDirectory(FreemarkerTemplateResource.getDirectoryPath(this.getRequest()));
            if (LOGGER.isLoggable(Level.INFO)) {
                MediaType mediaType = this.getRequest().getEntity().getMediaType();
                LOGGER.info("PUT file: mimetype=" + mediaType + ", path=" + directory.getAbsolutePath());
            }
            return RESTUtils.handleBinUpload((String)(this.getAttribute("template") + "." + MEDIATYPE_FTL_EXTENSION), (File)directory, (boolean)false, (Request)this.getRequest());
        }
        catch (IOException e) {
            throw new RestletException(e.getMessage(), Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
    }

    private File getTemplateFile() {
        try {
            File directory = this.catalog.getResourceLoader().find(FreemarkerTemplateResource.getDirectoryPath(this.getRequest()));
            File templateFile = this.catalog.getResourceLoader().find(directory, this.getAttribute("template") + "." + MEDIATYPE_FTL_EXTENSION);
            if (templateFile == null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("File not found: " + FreemarkerTemplateResource.getDirectoryPathAsString(this.getRequest()) + "/" + this.getAttribute("template") + "." + MEDIATYPE_FTL_EXTENSION);
                }
                throw new RestletException("File Not Found", Status.CLIENT_ERROR_NOT_FOUND);
            }
            return templateFile;
        }
        catch (IOException e) {
            throw new RestletException(e.getMessage(), Status.CLIENT_ERROR_NOT_FOUND, (Throwable)e);
        }
    }

    public static String getDirectoryPathAsString(Request request) {
        StringBuilder buff = new StringBuilder();
        for (String path : FreemarkerTemplateResource.getDirectoryPath(request)) {
            buff.append("/").append(path);
        }
        return buff.toString();
    }

    public static String[] getDirectoryPath(Request request) {
        String workspace = RESTUtils.getAttribute((Request)request, (String)"workspace");
        String datastore = RESTUtils.getAttribute((Request)request, (String)"datastore");
        String featureType = RESTUtils.getAttribute((Request)request, (String)"featuretype");
        String coveragestore = RESTUtils.getAttribute((Request)request, (String)"coveragestore");
        String coverage = RESTUtils.getAttribute((Request)request, (String)"coverage");
        ArrayList<String> path = new ArrayList<String>();
        path.add("workspaces");
        if (workspace != null) {
            path.add(workspace);
            if (datastore != null) {
                path.add(datastore);
                if (featureType != null) {
                    path.add(featureType);
                }
            } else if (coveragestore != null) {
                path.add(coveragestore);
                if (coverage != null) {
                    path.add(coverage);
                }
            }
        }
        return path.toArray(new String[0]);
    }

    static {
        MediaTypes.registerExtension((String)MEDIATYPE_FTL_EXTENSION, (MediaType)MEDIATYPE_FTL);
    }
}

