/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.AbstractCatalogListResource;
import org.geoserver.catalog.rest.FreemarkerTemplateInfo;
import org.geoserver.catalog.rest.FreemarkerTemplateResource;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.format.DataFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class FreemarkerTemplateListResource
extends AbstractCatalogListResource {
    private Catalog catalog;

    protected FreemarkerTemplateListResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, FreemarkerTemplateInfo.class, catalog);
        this.catalog = catalog;
    }

    public boolean allowGet() {
        return true;
    }

    public boolean allowPut() {
        return false;
    }

    public boolean allowDelete() {
        return false;
    }

    public boolean allowPost() {
        return false;
    }

    @Override
    protected String getItemName(XStreamPersister xp) {
        return "template";
    }

    @Override
    protected Collection<FreemarkerTemplateInfo> handleListGet() throws Exception {
        File directory = this.catalog.getResourceLoader().find(FreemarkerTemplateResource.getDirectoryPath(this.getRequest()));
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".ftl");
            }
        });
        ArrayList<FreemarkerTemplateInfo> list = new ArrayList<FreemarkerTemplateInfo>();
        for (File file : files) {
            list.add(new FreemarkerTemplateInfo(file));
        }
        return list;
    }

    @Override
    String href(String link, DataFormat format) {
        return this.getPageInfo().getBaseURL() + this.getPageInfo().getRootPath() + FreemarkerTemplateResource.getDirectoryPathAsString(this.getRequest()) + "/templates/" + link;
    }
}

