/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.rest.StoreFileResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.StreamDataFormat;
import org.geoserver.rest.util.RESTUtils;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.vfny.geoserver.util.DataStoreUtils;

public class DataStoreFileResource
extends StoreFileResource {
    protected static final HashMap<String, String> formatToDataStoreFactory = new HashMap();
    protected static final HashMap<String, Map> dataStoreFactoryToDefaultParams;
    String dataStoreFormat;
    DataAccessFactory factory;

    public static DataAccessFactory lookupDataStoreFactory(String format) {
        String factoryClassName = formatToDataStoreFactory.get(format);
        if (factoryClassName != null) {
            try {
                Class<?> factoryClass = Class.forName(factoryClassName);
                DataAccessFactory factory = (DataAccessFactory)factoryClass.newInstance();
                return factory;
            }
            catch (Exception e) {
                throw new RestletException("Datastore format unavailable: " + factoryClassName, Status.SERVER_ERROR_INTERNAL);
            }
        }
        String extension = "." + format;
        for (DataAccessFactory dataAccessFactory : DataStoreUtils.getAvailableDataStoreFactories()) {
            if (!(dataAccessFactory instanceof FileDataStoreFactorySpi)) continue;
            FileDataStoreFactorySpi factory = (FileDataStoreFactorySpi)dataAccessFactory;
            for (String handledExtension : factory.getFileExtensions()) {
                if (!extension.equalsIgnoreCase(handledExtension)) continue;
                return factory;
            }
        }
        throw new RestletException("Unsupported format: " + format, Status.CLIENT_ERROR_BAD_REQUEST);
    }

    public static String lookupDataStoreFactoryFormat(String type) {
        for (DataAccessFactory factory : DataStoreUtils.getAvailableDataStoreFactories()) {
            if (!(factory instanceof DataAccessFactory) || factory.getDisplayName() == null || !factory.getDisplayName().equals(type)) continue;
            for (Map.Entry<String, String> e : formatToDataStoreFactory.entrySet()) {
                if (!e.getValue().equals(factory.getClass().getCanonicalName())) continue;
                return e.getKey();
            }
            return factory.getDisplayName();
        }
        return null;
    }

    public DataStoreFileResource(Request request, Response response, String dataStoreFormat, Catalog catalog) {
        super(request, response, catalog);
        this.dataStoreFormat = dataStoreFormat;
        this.factory = DataStoreFileResource.lookupDataStoreFactory(dataStoreFormat);
    }

    public void handleGet() {
        String datastore;
        String workspace = this.getAttribute("workspace");
        DataStoreInfo info = this.catalog.getDataStoreByName(workspace, datastore = this.getAttribute("datastore"));
        if (info == null) {
            throw new RestletException("No such datastore " + datastore, Status.CLIENT_ERROR_NOT_FOUND);
        }
        Map params = info.getConnectionParameters();
        File directory = null;
        for (Map.Entry e : params.entrySet()) {
            if (e.getValue() instanceof File) {
                directory = (File)e.getValue();
            } else if (e.getValue() instanceof URL) {
                directory = new File(((URL)e.getValue()).getFile());
            }
            if (directory != null && !"directory".equals(e.getKey())) {
                directory = directory.getParentFile();
            }
            if (directory == null) continue;
            break;
        }
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new RestletException("No files for datastore " + datastore, Status.CLIENT_ERROR_NOT_FOUND);
        }
        StreamDataFormat fmt = new StreamDataFormat(MediaType.APPLICATION_ZIP){

            protected Object read(InputStream in) throws IOException {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void write(Object object, OutputStream out) throws IOException {
                ZipOutputStream zout = new ZipOutputStream(out);
                File directory = (File)object;
                for (File f : directory.listFiles()) {
                    ZipEntry entry = new ZipEntry(f.getName());
                    zout.putNextEntry(entry);
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(f);
                        IOUtils.copy((InputStream)fis, (OutputStream)zout);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                    zout.closeEntry();
                }
                zout.flush();
                zout.close();
            }
        };
        this.getResponse().setEntity(fmt.toRepresentation((Object)directory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePut() {
        String workspace = this.getAttribute("workspace");
        String datastore = this.getAttribute("datastore");
        String format = this.getAttribute("format");
        String method = this.getUploadMethod(this.getRequest());
        this.getResponse().setStatus(Status.SUCCESS_ACCEPTED);
        Form form = this.getRequest().getResourceRef().getQueryAsForm();
        File uploadedFile = this.doFileUpload(method, workspace, datastore, format).get(0);
        String sourceDataStoreFormat = this.dataStoreFormat;
        String targetDataStoreFormat = RESTUtils.getQueryStringValue((Request)this.getRequest(), (String)"target");
        if (targetDataStoreFormat == null) {
            targetDataStoreFormat = sourceDataStoreFormat;
        }
        sourceDataStoreFormat = sourceDataStoreFormat.toLowerCase();
        targetDataStoreFormat = targetDataStoreFormat.toLowerCase();
        CatalogBuilder builder = new CatalogBuilder(this.catalog);
        builder.setWorkspace(this.catalog.getWorkspaceByName(workspace));
        DataStoreInfo info = this.catalog.getDataStoreByName(workspace, datastore);
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace);
        boolean add = false;
        boolean save = false;
        boolean canRemoveFiles = false;
        String charset = form.getFirstValue("charset");
        if (info == null) {
            LOGGER.info("Auto-configuring datastore: " + datastore);
            info = builder.buildDataStore(datastore);
            add = true;
            if (charset != null && charset.length() > 0) {
                info.getConnectionParameters().put("charset", charset);
            }
            DataAccessFactory targetFactory = this.factory;
            if (!targetDataStoreFormat.equals(sourceDataStoreFormat)) {
                targetFactory = DataStoreFileResource.lookupDataStoreFactory(targetDataStoreFormat);
                if (targetFactory == null) {
                    throw new RestletException("Unable to create data store of type " + targetDataStoreFormat, Status.CLIENT_ERROR_BAD_REQUEST);
                }
                this.autoCreateParameters(info, namespace, targetFactory);
                canRemoveFiles = true;
            } else {
                this.updateParameters(info, namespace, targetFactory, uploadedFile);
            }
            info.setType(targetFactory.getDisplayName());
        } else {
            LOGGER.info("Using existing datastore: " + datastore);
            targetDataStoreFormat = DataStoreFileResource.lookupDataStoreFactoryFormat(info.getType());
            if (targetDataStoreFormat == null) {
                throw new RuntimeException("Unable to locate data store factory of type " + info.getType());
            }
            if (targetDataStoreFormat.equals(sourceDataStoreFormat)) {
                save = true;
                this.updateParameters(info, namespace, this.factory, uploadedFile);
            } else {
                canRemoveFiles = true;
            }
        }
        builder.setStore((StoreInfo)info);
        if (add) {
            this.catalog.validate((StoreInfo)info, true).throwIfInvalid();
            this.catalog.add((StoreInfo)info);
        } else if (save) {
            this.catalog.validate((StoreInfo)info, false).throwIfInvalid();
            this.catalog.save((StoreInfo)info);
        }
        boolean createNewSource = false;
        DataAccess source = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            if (charset != null && charset.length() > 0) {
                params.put("charset", charset);
            }
            params.put("namespace", namespace.getURI());
            this.updateParameters(params, this.factory, uploadedFile);
            createNewSource = !this.sameTypeAndUrl(params, info.getConnectionParameters());
            source = createNewSource ? this.factory.createDataStore(params) : info.getDataStore(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create source data store", e);
        }
        try {
            String configure;
            DataAccess ds = info.getDataStore(null);
            if (!targetDataStoreFormat.equals(sourceDataStoreFormat) && source instanceof DataStore && ds instanceof DataStore) {
                DataStore sourceDataStore = (DataStore)source;
                DataStore targetDataStore = (DataStore)ds;
                for (String featureTypeName : sourceDataStore.getTypeNames()) {
                    SimpleFeatureType featureType = null;
                    try {
                        featureType = targetDataStore.getSchema(featureTypeName);
                    }
                    catch (Exception e) {
                        LOGGER.info(featureTypeName + " does not exist in data store " + datastore + ". Attempting to create it");
                        targetDataStore.createSchema((FeatureType)sourceDataStore.getSchema(featureTypeName));
                        featureType = sourceDataStore.getSchema(featureTypeName);
                    }
                    SimpleFeatureSource featureSource = targetDataStore.getFeatureSource(featureTypeName);
                    if (!(featureSource instanceof FeatureStore)) {
                        LOGGER.warning(featureTypeName + " is not writable, skipping");
                        continue;
                    }
                    DefaultTransaction tx = new DefaultTransaction();
                    FeatureStore featureStore = (FeatureStore)featureSource;
                    featureStore.setTransaction((Transaction)tx);
                    try {
                        String update = form.getFirstValue("update");
                        if ("overwrite".equalsIgnoreCase(update)) {
                            LOGGER.fine("Removing existing features from " + featureTypeName);
                            featureStore.removeFeatures((Filter)Filter.INCLUDE);
                        }
                        LOGGER.fine("Adding features to " + featureTypeName);
                        SimpleFeatureCollection features = sourceDataStore.getFeatureSource(featureTypeName).getFeatures();
                        featureStore.addFeatures((FeatureCollection)features);
                        tx.commit();
                    }
                    catch (Exception e) {
                        tx.rollback();
                    }
                    finally {
                        tx.close();
                    }
                }
            }
            if ("none".equalsIgnoreCase(configure = form.getFirstValue("configure"))) {
                this.getResponse().setStatus(Status.SUCCESS_CREATED);
                return;
            }
            HashMap<String, FeatureTypeInfo> featureTypesByNativeName = new HashMap<String, FeatureTypeInfo>();
            for (FeatureTypeInfo ftInfo : this.catalog.getFeatureTypesByDataStore(info)) {
                featureTypesByNativeName.put(ftInfo.getNativeName(), ftInfo);
            }
            List featureTypeNames = source.getNames();
            for (int i = 0; i < featureTypeNames.size(); ++i) {
                if (!"all".equalsIgnoreCase(configure) && i > 0) {
                    break;
                }
                FeatureSource fs = ds.getFeatureSource((Name)featureTypeNames.get(i));
                FeatureTypeInfo ftinfo = (FeatureTypeInfo)featureTypesByNativeName.get(((Name)featureTypeNames.get(i)).getLocalPart());
                if (ftinfo == null) {
                    ftinfo = builder.buildFeatureType(fs);
                    builder.lookupSRS(ftinfo, true);
                    builder.setupBounds((ResourceInfo)ftinfo);
                }
                ReferencedEnvelope bounds = fs.getBounds();
                ftinfo.setNativeBoundingBox(bounds);
                if (ftinfo.getId() == null) {
                    if (this.catalog.getFeatureTypeByName(namespace, ftinfo.getName()) != null) {
                        LOGGER.warning(String.format("Feature type %s already exists in namespace %s, attempting to rename", ftinfo.getName(), namespace.getPrefix()));
                        int x = 1;
                        String originalName = ftinfo.getName();
                        do {
                            ftinfo.setName(originalName + x);
                        } while (++x < 10 && this.catalog.getFeatureTypeByName(namespace, ftinfo.getName()) != null);
                    }
                    this.catalog.validate((ResourceInfo)ftinfo, true).throwIfInvalid();
                    this.catalog.add((ResourceInfo)ftinfo);
                    LayerInfo layer = builder.buildLayer(ftinfo);
                    boolean valid = true;
                    try {
                        if (!this.catalog.validate(layer, true).isValid()) {
                            valid = false;
                        }
                    }
                    catch (Exception e) {
                        valid = false;
                    }
                    layer.setEnabled(valid);
                    this.catalog.add(layer);
                    LOGGER.info("Added feature type " + ftinfo.getName());
                } else {
                    LOGGER.info("Updated feature type " + ftinfo.getName());
                    this.catalog.validate((ResourceInfo)ftinfo, false).throwIfInvalid();
                    this.catalog.save((ResourceInfo)ftinfo);
                }
                this.getResponse().setStatus(Status.SUCCESS_CREATED);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            block55: {
                if (createNewSource) {
                    source.dispose();
                }
                if (this.isInlineUpload(method) && canRemoveFiles) {
                    if (uploadedFile.isFile()) {
                        uploadedFile = uploadedFile.getParentFile();
                    }
                    try {
                        FileUtils.deleteDirectory((File)uploadedFile);
                    }
                    catch (IOException ie) {
                        LOGGER.info("Unable to delete " + uploadedFile.getAbsolutePath());
                        if (!LOGGER.isLoggable(Level.FINE)) break block55;
                        LOGGER.log(Level.FINE, "", ie);
                    }
                }
            }
        }
    }

    @Override
    protected File findPrimaryFile(File directory, String format) {
        if ("shp".equalsIgnoreCase(format)) {
            return directory;
        }
        return super.findPrimaryFile(directory, format);
    }

    void updateParameters(DataStoreInfo info, NamespaceInfo namespace, DataAccessFactory factory, File uploadedFile) {
        Map connectionParameters = info.getConnectionParameters();
        this.updateParameters(connectionParameters, factory, uploadedFile);
        connectionParameters.put("namespace", namespace.getURI());
        if (!factory.canProcess(connectionParameters)) {
            throw new RestletException("Unable to configure datastore, bad parameters.", Status.SERVER_ERROR_INTERNAL);
        }
    }

    void updateParameters(Map connectionParameters, DataAccessFactory factory, File uploadedFile) {
        for (DataAccessFactory.Param p : factory.getParametersInfo()) {
            if (File.class == p.type || URL.class == p.type) {
                File f = uploadedFile;
                if ("directory".equals(p.key)) {
                    f = f.getParentFile();
                }
                Serializable converted = null;
                if (URI.class.equals((Object)p.type)) {
                    converted = f.toURI();
                } else if (URL.class.equals((Object)p.type)) {
                    converted = DataUtilities.fileToURL((File)f);
                }
                if (converted != null) {
                    connectionParameters.put(p.key, converted);
                    continue;
                }
                connectionParameters.put(p.key, f);
                continue;
            }
            if (!p.required) continue;
            try {
                p.lookUp(connectionParameters);
            }
            catch (Exception e) {
                connectionParameters.put(p.key, p.sample);
            }
        }
    }

    void autoCreateParameters(DataStoreInfo info, NamespaceInfo namespace, DataAccessFactory factory) {
        Map defaultParams = dataStoreFactoryToDefaultParams.get(factory.getClass().getCanonicalName());
        if (defaultParams == null) {
            throw new RuntimeException("Unable to auto create parameters for " + factory.getDisplayName());
        }
        HashMap<String, String> params = new HashMap<String, String>(defaultParams);
        String dataDirRoot = this.catalog.getResourceLoader().getBaseDirectory().getAbsolutePath();
        for (Map.Entry entry : params.entrySet()) {
            Map.Entry e = entry;
            if (!(e.getValue() instanceof String)) continue;
            String string = (String)e.getValue();
            string = string.replace("@NAME@", info.getName()).replace("@DATA_DIR@", dataDirRoot);
            e.setValue(string);
        }
        params.put("namespace", namespace.getURI());
        info.getConnectionParameters().putAll(params);
    }

    private boolean sameTypeAndUrl(Map sourceParams, Map targetParams) {
        boolean sameType = sourceParams.get("dbtype") != null && targetParams.get("dbtype") != null && sourceParams.get("dbtype").equals(targetParams.get("dbtype"));
        boolean sameUrl = sourceParams.get("url") != null && targetParams.get("url") != null && sourceParams.get("url").equals(targetParams.get("url"));
        return sameType && sameUrl;
    }

    static {
        formatToDataStoreFactory.put("shp", "org.geotools.data.shapefile.ShapefileDataStoreFactory");
        formatToDataStoreFactory.put("properties", "org.geotools.data.property.PropertyDataStoreFactory");
        formatToDataStoreFactory.put("h2", "org.geotools.data.h2.H2DataStoreFactory");
        formatToDataStoreFactory.put("spatialite", "org.geotools.data.spatialite.SpatiaLiteDataStoreFactory");
        formatToDataStoreFactory.put("appschema", "org.geotools.data.complex.AppSchemaDataAccessFactory");
        formatToDataStoreFactory.put("gpkg", "org.geotools.geopkg.GeoPkgDataStoreFactory");
        dataStoreFactoryToDefaultParams = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("database", "@DATA_DIR@/@NAME@");
        map.put("dbtype", "h2");
        dataStoreFactoryToDefaultParams.put("org.geotools.data.h2.H2DataStoreFactory", map);
        map = new HashMap();
        map.put("database", "@DATA_DIR@/@NAME@");
        map.put("dbtype", "spatialite");
        dataStoreFactoryToDefaultParams.put("org.geotools.data.spatialite.SpatiaLiteDataStoreFactory", map);
    }
}

