/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.CoverageStoreListResource;
import org.geoserver.catalog.rest.CoverageStoreResource;
import org.geoserver.rest.RestletException;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class CoverageStoreFinder
extends AbstractCatalogFinder {
    public CoverageStoreFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String ws = this.getAttribute(request, "workspace");
        String cs = this.getAttribute(request, "coveragestore");
        if (ws != null && this.catalog.getWorkspaceByName(ws) == null) {
            throw new RestletException("No such workspace: " + ws, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (cs != null && this.catalog.getCoverageStoreByName(ws, cs) == null) {
            boolean quietOnNotFound = this.quietOnNotFoundEnabled(request);
            if (quietOnNotFound) {
                return null;
            }
            throw new RestletException("No such coverage store: " + ws + "," + cs, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (cs == null && request.getMethod() == Method.GET) {
            return new CoverageStoreListResource(this.getContext(), request, response, this.catalog);
        }
        return new CoverageStoreResource(null, request, response, this.catalog);
    }
}

