/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.SingleGridCoverage2DReader;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.rest.CoverageStoreResource;
import org.geoserver.catalog.rest.StoreFileResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.ReflectiveXMLFormat;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.factory.GeoTools;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class CoverageStoreFileResource
extends StoreFileResource {
    Format coverageFormat;

    public CoverageStoreFileResource(Request request, Response response, Format coverageFormat, Catalog catalog) {
        super(request, response, catalog);
        this.coverageFormat = coverageFormat;
    }

    public boolean allowPost() {
        String coveragestore;
        String workspace = this.getAttribute("workspace");
        CoverageStoreInfo info = this.catalog.getCoverageStoreByName(workspace, coveragestore = this.getAttribute("coveragestore"));
        if (info == null) {
            return false;
        }
        try {
            GridCoverageReader reader = info.getGridCoverageReader(null, null);
            if (reader instanceof StructuredGridCoverage2DReader) {
                StructuredGridCoverage2DReader sr = (StructuredGridCoverage2DReader)reader;
                return !sr.isReadOnly();
            }
            return false;
        }
        catch (IOException e) {
            throw new RestletException("Failed to access the existing reader to check if it can harvest new files", Status.SERVER_ERROR_INTERNAL);
        }
    }

    public void handlePost() {
        String workspace = this.getAttribute("workspace");
        String coveragestore = this.getAttribute("coveragestore");
        String format = this.getAttribute("format");
        Request request = this.getRequest();
        String method = this.getUploadMethod(request);
        try {
            CoverageStoreInfo info = this.catalog.getCoverageStoreByName(workspace, coveragestore);
            GridCoverageReader reader = info.getGridCoverageReader(null, null);
            StructuredGridCoverage2DReader sr = (StructuredGridCoverage2DReader)reader;
            List<File> uploadedFiles = this.doFileUpload(method, workspace, coveragestore, format);
            sr.harvest(null, uploadedFiles, GeoTools.getDefaultHints());
        }
        catch (IOException e) {
            throw new RestletException("File harvest failed", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
    }

    public void handlePut() {
        Request request = this.getRequest();
        Response response = this.getResponse();
        String workspace = this.getAttribute("workspace");
        String coveragestore = this.getAttribute("coveragestore");
        String format = this.getAttribute("format");
        String method = this.getUploadMethod(request);
        File uploadedFile = this.doFileUpload(method, workspace, coveragestore, format).get(0);
        Form form = request.getResourceRef().getQueryAsForm();
        if ("yes".equalsIgnoreCase(form.getFirstValue("overviews"))) {
            // empty if block
        }
        CatalogBuilder builder = new CatalogBuilder(this.catalog);
        builder.setWorkspace(this.catalog.getWorkspaceByName(workspace));
        CoverageStoreInfo info = this.catalog.getCoverageStoreByName(workspace, coveragestore);
        boolean add = false;
        if (info == null) {
            LOGGER.info("Auto-configuring coverage store: " + coveragestore);
            info = builder.buildCoverageStore(coveragestore);
            add = true;
        } else {
            LOGGER.info("Using existing coverage store: " + coveragestore);
        }
        info.setType(this.coverageFormat.getName());
        URL uploadedFileURL = DataUtilities.fileToURL((File)uploadedFile);
        if (this.isInlineUpload(method)) {
            String url;
            int def;
            String defaultRoot = File.separator + "data" + File.separator + workspace + File.separator + coveragestore;
            StringBuilder fileBuilder = new StringBuilder(uploadedFile.getAbsolutePath());
            if (uploadedFile.isDirectory() && uploadedFile.getName().equals(coveragestore)) {
                def = fileBuilder.indexOf(defaultRoot);
                url = def >= 0 ? "file:data/" + workspace + "/" + coveragestore : fileBuilder.toString();
            } else {
                def = fileBuilder.indexOf(defaultRoot);
                if (def >= 0) {
                    String itemPath = fileBuilder.substring(def + defaultRoot.length());
                    url = "file:data/" + workspace + "/" + coveragestore + "/" + itemPath;
                } else {
                    url = fileBuilder.toString();
                }
            }
            if (url.contains("+")) {
                url = url.replace("+", "%2B");
            }
            if (url.contains(" ")) {
                url = url.replace(" ", "%20");
            }
            info.setURL(url);
        } else {
            info.setURL(uploadedFileURL.toExternalForm());
        }
        if (add) {
            if (!this.catalog.validate((StoreInfo)info, true).isValid()) {
                throw new RuntimeException("Validation failed");
            }
            this.catalog.add((StoreInfo)info);
        } else {
            if (!this.catalog.validate((StoreInfo)info, false).isValid()) {
                throw new RuntimeException("Validation failed");
            }
            this.catalog.save((StoreInfo)info);
        }
        builder.setStore((StoreInfo)info);
        String configure = form.getFirstValue("configure");
        if ("none".equalsIgnoreCase(configure)) {
            this.getResponse().setStatus(Status.SUCCESS_CREATED);
            return;
        }
        AbstractGridCoverage2DReader reader = null;
        try {
            reader = ((AbstractGridFormat)this.coverageFormat).getReader((Object)DataUtilities.fileToURL((File)uploadedFile));
            if (reader == null) {
                throw new RestletException("Could not aquire reader for coverage.", Status.SERVER_ERROR_INTERNAL);
            }
            HashMap<String, Boolean> customParameters = new HashMap<String, Boolean>();
            String useJAIImageReadParam = form.getFirstValue("USE_JAI_IMAGEREAD");
            if (useJAIImageReadParam != null) {
                customParameters.put(AbstractGridFormat.USE_JAI_IMAGEREAD.getName().toString(), Boolean.valueOf(useJAIImageReadParam));
            }
            String coverageName = form.getFirstValue("coverageName");
            String[] names = reader.getGridCoverageNames();
            if (names.length > 1 && coverageName != null) {
                throw new RestletException("The reader found more than one coverage, coverageName cannot be used in this case (it would generate the same name for all coverages found", Status.CLIENT_ERROR_BAD_REQUEST);
            }
            if (names.length > 1) {
                for (String name : names) {
                    SingleGridCoverage2DReader singleReader = new SingleGridCoverage2DReader((GridCoverage2DReader)reader, name);
                    this.configureCoverageInfo(builder, info, add, name, name, (GridCoverage2DReader)singleReader, customParameters);
                }
            } else {
                this.configureCoverageInfo(builder, info, add, names[0], coverageName, (GridCoverage2DReader)reader, customParameters);
            }
            ReflectiveXMLFormat df = new CoverageStoreResource(this.getContext(), request, response, this.catalog).createXMLFormat(request, response);
            response.setEntity(df.toRepresentation((Object)info));
            response.setStatus(Status.SUCCESS_CREATED);
        }
        catch (Exception e) {
            if (e instanceof RestletException) {
                throw (RestletException)((Object)e);
            }
            throw new RestletException("Error auto-configuring coverage", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (IOException e) {}
            }
        }
    }

    private void configureCoverageInfo(CatalogBuilder builder, CoverageStoreInfo storeInfo, boolean add, String nativeName, String coverageName, GridCoverage2DReader reader, Map customParameters) throws Exception, IOException {
        CoverageInfo cinfo = builder.buildCoverage(reader, customParameters);
        if (coverageName != null) {
            cinfo.setName(coverageName);
        }
        if (nativeName != null) {
            cinfo.setNativeCoverageName(nativeName);
        }
        if (!add) {
            String name = coverageName != null ? coverageName : nativeName;
            CoverageInfo existing = this.catalog.getCoverageByCoverageStore(storeInfo, name);
            if (existing == null) {
                List coverages = this.catalog.getCoveragesByCoverageStore(storeInfo);
                if (coverages.size() == 1 && ((CoverageInfo)coverages.get(0)).getNativeName() == null) {
                    existing = (CoverageInfo)coverages.get(0);
                }
                if (coverages.size() == 0) {
                    add = true;
                } else {
                    for (CoverageInfo ci : coverages) {
                        if (!ci.getNativeName().equals(name)) continue;
                        existing = ci;
                    }
                    if (existing == null) {
                        add = true;
                    }
                }
            }
            if (existing != null) {
                builder.updateCoverage(existing, cinfo);
                this.catalog.validate((ResourceInfo)existing, false).throwIfInvalid();
                this.catalog.save((ResourceInfo)existing);
                cinfo = existing;
            }
        }
        if ("UNKNOWN".equals(cinfo.getSRS())) {
            cinfo.setSRS("EPSG:4326");
        }
        if (add) {
            this.catalog.validate((ResourceInfo)cinfo, true).throwIfInvalid();
            this.catalog.add((ResourceInfo)cinfo);
            LayerInfo layerInfo = builder.buildLayer(cinfo);
            boolean valid = true;
            try {
                if (!this.catalog.validate(layerInfo, true).isValid()) {
                    valid = false;
                }
            }
            catch (Exception e) {
                valid = false;
            }
            layerInfo.setEnabled(valid);
            this.catalog.add(layerInfo);
        } else {
            this.catalog.save((ResourceInfo)cinfo);
        }
    }

    @Override
    protected File findPrimaryFile(File directory, String format) {
        if (((AbstractGridFormat)this.coverageFormat).accepts((Object)directory)) {
            return directory;
        }
        for (File f : directory.listFiles()) {
            if (f.isDirectory()) {
                File result = this.findPrimaryFile(f, format);
                if (result == null) continue;
                return result;
            }
            if (!((AbstractGridFormat)this.coverageFormat).accepts((Object)f)) continue;
            return f;
        }
        return null;
    }
}

