/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.ResourceHTMLFormat;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class CoverageResource
extends AbstractCatalogResource {
    public CoverageResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, CoverageInfo.class, catalog);
    }

    @Override
    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new ResourceHTMLFormat(CoverageInfo.class, request, response, (Resource)this);
    }

    protected Object handleObjectGet() throws Exception {
        String workspace = this.getAttribute("workspace");
        String coveragestore = this.getAttribute("coveragestore");
        String coverage = this.getAttribute("coverage");
        if (coveragestore == null) {
            LOGGER.fine("GET coverage " + workspace + "," + coverage);
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspace);
            if (ns != null) {
                return this.catalog.getCoverageByName(ns, coverage);
            }
            throw new RestletException("", Status.CLIENT_ERROR_NOT_FOUND);
        }
        LOGGER.fine("GET coverage " + coveragestore + "," + coverage);
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName(workspace, coveragestore);
        return this.catalog.getCoverageByCoverageStore(cs, coverage);
    }

    public boolean allowPost() {
        return this.getAttribute("coverage") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        String workspace = this.getAttribute("workspace");
        String coveragestore = this.getAttribute("coveragestore");
        CoverageInfo coverage = (CoverageInfo)object;
        if (coverage.getStore() == null) {
            CoverageStoreInfo ds = this.catalog.getCoverageStoreByName(workspace, coveragestore);
            coverage.setStore((StoreInfo)ds);
        }
        boolean isNew = this.isNewCoverage(coverage);
        String name = coverage.getNativeCoverageName();
        CatalogBuilder builder = new CatalogBuilder(this.catalog);
        CoverageStoreInfo store = coverage.getStore();
        builder.setStore((StoreInfo)store);
        if (!isNew) {
            builder.initCoverage(coverage, name);
        } else {
            coverage = builder.buildCoverage(name);
        }
        NamespaceInfo ns = coverage.getNamespace();
        if (ns != null && !ns.getPrefix().equals(workspace)) {
            LOGGER.warning("Namespace: " + ns.getPrefix() + " does not match workspace: " + workspace + ", overriding.");
            ns = null;
        }
        if (ns == null) {
            ns = this.catalog.getNamespaceByPrefix(workspace);
            coverage.setNamespace(ns);
        }
        coverage.setEnabled(true);
        this.catalog.validate((ResourceInfo)coverage, true).throwIfInvalid();
        this.catalog.add((ResourceInfo)coverage);
        this.catalog.add(builder.buildLayer(coverage));
        LOGGER.info("POST coverage " + coveragestore + "," + coverage.getName());
        return coverage.getName();
    }

    private boolean isNewCoverage(CoverageInfo coverage) {
        return coverage.getName() != null && coverage.isAdvertised() && !coverage.isEnabled() && coverage.getAlias() == null && coverage.getCRS() == null && coverage.getDefaultInterpolationMethod() == null && coverage.getDescription() == null && coverage.getDimensions() == null && coverage.getGrid() == null && coverage.getInterpolationMethods() == null && coverage.getKeywords() == null && coverage.getLatLonBoundingBox() == null && coverage.getMetadata() == null && coverage.getNativeBoundingBox() == null && coverage.getNativeCRS() == null && coverage.getNativeFormat() == null && coverage.getProjectionPolicy() == null && coverage.getSRS() == null && coverage.getResponseSRS() == null && coverage.getRequestSRS() == null;
    }

    public boolean allowPut() {
        return this.getAttribute("coverage") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        CoverageInfo c = (CoverageInfo)object;
        String workspace = this.getAttribute("workspace");
        String coveragestore = this.getAttribute("coveragestore");
        String coverage = this.getAttribute("coverage");
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName(workspace, coveragestore);
        CoverageInfo original = this.catalog.getCoverageByCoverageStore(cs, coverage);
        new CatalogBuilder(this.catalog).updateCoverage(original, c);
        this.calculateOptionalFields((ResourceInfo)c, (ResourceInfo)original);
        this.catalog.validate((ResourceInfo)original, false).throwIfInvalid();
        this.catalog.save((ResourceInfo)original);
        this.clear(original);
        LOGGER.info("PUT coverage " + coveragestore + "," + coverage);
    }

    public boolean allowDelete() {
        return this.getAttribute("coverage") != null;
    }

    protected void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        String coveragestore = this.getAttribute("coveragestore");
        String coverage = this.getAttribute("coverage");
        boolean recurse = (Boolean)this.getQueryStringValue("recurse", Boolean.class, false);
        CoverageStoreInfo ds = this.catalog.getCoverageStoreByName(workspace, coveragestore);
        CoverageInfo c = this.catalog.getCoverageByCoverageStore(ds, coverage);
        List layers = this.catalog.getLayers((ResourceInfo)c);
        if (recurse) {
            for (LayerInfo l : layers) {
                this.catalog.remove(l);
                LOGGER.info("DELETE layer " + l.getName());
            }
        } else if (!layers.isEmpty()) {
            throw new RestletException("coverage referenced by layer(s)", Status.CLIENT_ERROR_FORBIDDEN);
        }
        this.catalog.remove((ResourceInfo)c);
        this.clear(c);
        LOGGER.info("DELETE coverage " + coveragestore + "," + coverage);
    }

    void clear(CoverageInfo info) {
        this.catalog.getResourcePool().clear(info.getStore());
    }

    @Override
    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof NamespaceInfo) {
                    NamespaceInfo ns = (NamespaceInfo)obj;
                    CoverageResource.this.encodeLink("/namespaces/" + CoverageResource.this.encode(ns.getPrefix()), writer);
                }
                if (obj instanceof CoverageStoreInfo) {
                    CoverageStoreInfo cs = (CoverageStoreInfo)obj;
                    CoverageResource.this.encodeLink("/workspaces/" + CoverageResource.this.encode(cs.getWorkspace().getName()) + "/coveragestores/" + CoverageResource.this.encode(cs.getName()), writer);
                }
            }
        });
    }
}

