/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.CoverageListResource;
import org.geoserver.catalog.rest.CoverageResource;
import org.geoserver.catalog.rest.HarvestedCoveragesResource;
import org.geoserver.rest.RestletException;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class CoverageFinder
extends AbstractCatalogFinder {
    public CoverageFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String ws = this.getAttribute(request, "workspace");
        String cs = this.getAttribute(request, "coveragestore");
        String c = this.getAttribute(request, "coverage");
        if (ws != null && this.catalog.getWorkspaceByName(ws) == null) {
            throw new RestletException("No such workspace: " + ws, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (cs != null && this.catalog.getCoverageStoreByName(ws, cs) == null) {
            throw new RestletException("No such coveragestore: " + ws + "," + cs, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (c == null && request.getMethod() == Method.GET) {
            Form form = request.getResourceRef().getQueryAsForm();
            String list = form.getFirstValue("list");
            if ("all".equalsIgnoreCase(list)) {
                return new HarvestedCoveragesResource(this.getContext(), request, response, this.catalog);
            }
            return new CoverageListResource(this.getContext(), request, response, this.catalog);
        }
        if (c != null) {
            boolean quietOnNotFound = this.quietOnNotFoundEnabled(request);
            if (cs != null && this.catalog.getCoverageByCoverageStore(this.catalog.getCoverageStoreByName(ws, cs), c) == null) {
                if (quietOnNotFound) {
                    return null;
                }
                throw new RestletException("No such coverage: " + ws + "," + cs + "," + c, Status.CLIENT_ERROR_NOT_FOUND);
            }
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(ws);
            if (ns == null || this.catalog.getCoverageByName(ns, c) == null) {
                if (quietOnNotFound) {
                    return null;
                }
                throw new RestletException("No such coverage: " + ws + "," + c, Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        return new CoverageResource(null, request, response, this.catalog);
    }
}

