/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.rest.CatalogResourceBase;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.StreamDataFormat;
import org.geotools.GML;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.geojson.feature.FeatureJSON;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory2;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public abstract class AbstractGranuleResource
extends CatalogResourceBase {
    protected static FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    protected CoverageInfo coverage;

    public AbstractGranuleResource(Context context, Request request, Response response, Catalog catalog, CoverageInfo coverage) {
        super(context, request, response, SimpleFeatureCollection.class, catalog);
        this.coverage = coverage;
    }

    public boolean allowDelete() {
        try {
            StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)this.coverage.getGridCoverageReader(null, null);
            return !reader.isReadOnly();
        }
        catch (IOException e) {
            throw new RestletException("Failed to determine if the reader index can be written to", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
    }

    protected void handleObjectDelete() throws Exception {
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)this.coverage.getGridCoverageReader(null, null);
        String nativeCoverageName = this.getNativeCoverageName(reader);
        Query q = this.getResourceQuery();
        GranuleStore store = (GranuleStore)reader.getGranules(nativeCoverageName, false);
        int removed = store.removeGranules(q.getFilter());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Removed " + removed + " granules from the reader granule store");
        }
    }

    protected abstract Query getResourceQuery();

    protected Object handleObjectGet() throws Exception {
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)this.coverage.getGridCoverageReader(null, null);
        String nativeCoverageName = this.getNativeCoverageName(reader);
        GranuleSource source = reader.getGranules(nativeCoverageName, true);
        Query q = this.getResourceQuery();
        return this.forceNonNullNamespace(source.getGranules(q));
    }

    private String getNativeCoverageName(StructuredGridCoverage2DReader reader) throws IOException {
        String nativeCoverageName = this.coverage.getNativeCoverageName();
        if (nativeCoverageName == null) {
            if (reader.getGridCoverageNames().length > 1) {
                throw new IllegalStateException("The grid coverage configuration for " + this.coverage.getName() + " does not specify a native coverage name, yet the reader provides more than one coverage. " + "Please assign a native coverage name (the GUI does so automatically)");
            }
            nativeCoverageName = reader.getGridCoverageNames()[0];
        }
        return nativeCoverageName;
    }

    private SimpleFeatureCollection forceNonNullNamespace(SimpleFeatureCollection features) throws IOException {
        SimpleFeatureType sourceSchema = (SimpleFeatureType)features.getSchema();
        if (sourceSchema.getName().getNamespaceURI() == null) {
            try {
                String targetNs = "http://www.geoserver.org/rest/granules";
                AttributeDescriptor[] attributes = sourceSchema.getAttributeDescriptors().toArray(new AttributeDescriptor[sourceSchema.getAttributeDescriptors().size()]);
                SimpleFeatureType targetSchema = FeatureTypes.newFeatureType((AttributeDescriptor[])attributes, (String)sourceSchema.getName().getLocalPart(), (URI)new URI(targetNs));
                RetypingFeatureCollection retyped = new RetypingFeatureCollection(features, targetSchema);
                return retyped;
            }
            catch (Exception e) {
                throw new IOException("Failed to retype the granules feature schema, in order to force it having a non null namespace", e);
            }
        }
        return features;
    }

    protected List<DataFormat> createSupportedFormats(Request request, Response response) {
        ArrayList<DataFormat> formats = new ArrayList<DataFormat>();
        formats.add((DataFormat)new FeaturesJSONFormat());
        formats.add((DataFormat)new FeaturesGMLFormat());
        return formats;
    }

    public class FeaturesGMLFormat
    extends StreamDataFormat {
        protected FeaturesGMLFormat() {
            super(MediaType.TEXT_XML);
        }

        protected Object read(InputStream in) throws IOException {
            throw new UnsupportedOperationException("Can't read GML documents yet");
        }

        protected void write(Object object, OutputStream out) throws IOException {
            SimpleFeatureCollection features = (SimpleFeatureCollection)object;
            GML gml = new GML(GML.Version.WFS1_0);
            gml.setNamespace("gf", ((SimpleFeatureType)features.getSchema()).getName().getNamespaceURI());
            gml.encode(out, features);
        }
    }

    public class FeaturesJSONFormat
    extends StreamDataFormat {
        protected FeaturesJSONFormat() {
            super(MediaType.APPLICATION_JSON);
        }

        protected Object read(InputStream in) throws IOException {
            throw new UnsupportedOperationException("Can't read JSON documents yet");
        }

        protected void write(Object object, OutputStream out) throws IOException {
            SimpleFeatureCollection features = (SimpleFeatureCollection)object;
            FeatureJSON json = new FeatureJSON();
            boolean geometryless = ((SimpleFeatureType)features.getSchema()).getGeometryDescriptor() == null;
            json.setEncodeFeatureCollectionBounds(!geometryless);
            json.setEncodeFeatureCollectionCRS(!geometryless);
            json.writeFeatureCollection((FeatureCollection)features, out);
        }
    }
}

