/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.util.RESTUtils;
import org.restlet.Finder;
import org.restlet.data.Form;
import org.restlet.data.Request;

public abstract class AbstractCatalogFinder
extends Finder {
    public static final boolean DEFAULT_QUIET_ON_NOT_FOUND = false;
    protected Catalog catalog;

    protected AbstractCatalogFinder(Catalog catalog) {
        this.catalog = catalog;
    }

    protected String getAttribute(Request request, String attribute) {
        return RESTUtils.getAttribute((Request)request, (String)attribute);
    }

    protected boolean quietOnNotFoundEnabled(Request request) {
        Boolean quietOnNotFound = null;
        Form form = request.getResourceRef().getQueryAsForm();
        String quietOnNotFoundS = form.getFirstValue("quietOnNotFound");
        if (quietOnNotFoundS != null && !quietOnNotFoundS.isEmpty()) {
            quietOnNotFound = Boolean.parseBoolean(quietOnNotFoundS);
        } else {
            GeoServerInfo gsInfo = ((GeoServer)GeoServerExtensions.bean(GeoServer.class)).getGlobal();
            if (gsInfo != null) {
                MetadataMap map;
                SettingsInfo info = gsInfo.getSettings();
                MetadataMap metadataMap = map = info != null ? info.getMetadata() : null;
                if (map != null && map.containsKey((Object)"quietOnNotFound")) {
                    quietOnNotFound = (Boolean)map.get("quietOnNotFound", Boolean.class);
                }
            }
        }
        if (quietOnNotFound == null) {
            quietOnNotFound = false;
        }
        return quietOnNotFound;
    }
}

