/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.FilterWriteStrategy;
import ar.com.hjg.pngj.IFilterWriteStrategy;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineSet;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngIDatChunkOutputStream;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.PngjUnsupportedException;
import ar.com.hjg.pngj.chunks.ChunkCopyBehaviour;
import ar.com.hjg.pngj.chunks.ChunkPredicate;
import ar.com.hjg.pngj.chunks.ChunksList;
import ar.com.hjg.pngj.chunks.ChunksListForWrite;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkIEND;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import ar.com.hjg.pngj.chunks.PngMetadata;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngWriter {
    public final ImageInfo imgInfo;
    protected int rowNum = -1;
    private final ChunksListForWrite chunksList;
    private final PngMetadata metadata;
    protected int currentChunkGroup = -1;
    protected IFilterWriteStrategy filterStrat;
    protected boolean filterPreserve = false;
    private int compLevel = 6;
    private boolean shouldCloseStream = true;
    private PngIDatChunkOutputStream datStream;
    private DeflaterOutputStream datStreamDeflated;
    private int deflaterStrategy = 1;
    private int idatMaxSize = 0;
    private final OutputStream os;
    private byte[] rowb = null;
    private byte[] rowbfilter = null;
    private byte[] rowbprev = null;
    private ChunkPredicate copyFromPredicate = null;
    private ChunksList copyFromList = null;

    public PngWriter(File file, ImageInfo imgInfo, boolean allowoverwrite) {
        this(PngHelperInternal.ostreamFromFile(file, allowoverwrite), imgInfo);
        this.setShouldCloseStream(true);
    }

    public PngWriter(File file, ImageInfo imgInfo) {
        this(file, imgInfo, true);
    }

    public PngWriter(OutputStream outputStream, ImageInfo imgInfo) {
        this.os = outputStream;
        this.imgInfo = imgInfo;
        this.chunksList = new ChunksListForWrite(imgInfo);
        this.metadata = new PngMetadata(this.chunksList);
        this.filterStrat = new FilterWriteStrategy(imgInfo, FilterType.FILTER_DEFAULT);
    }

    private void initIdat() {
        if (this.rowb == null || this.rowb.length < this.imgInfo.bytesPerRow + 1) {
            this.rowb = new byte[this.imgInfo.bytesPerRow + 1];
            this.rowbprev = new byte[this.rowb.length];
            this.rowbfilter = new byte[this.rowb.length];
        }
        this.datStream = new PngIDatChunkOutputStream(this.os, this.idatMaxSize);
        Deflater def = new Deflater(this.compLevel);
        def.setStrategy(this.deflaterStrategy);
        this.datStreamDeflated = new DeflaterOutputStream((OutputStream)this.datStream, def);
        this.writeSignatureAndIHDR();
        this.writeFirstChunks();
    }

    private void writeEndChunk() {
        PngChunkIEND c = new PngChunkIEND(this.imgInfo);
        c.createRawChunk().writeChunk(this.os);
        this.chunksList.getChunks().add(c);
    }

    private void writeFirstChunks() {
        int nw = 0;
        this.currentChunkGroup = 1;
        this.queueChunksFromOther();
        nw = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 2;
        nw = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        if (nw > 0 && this.imgInfo.greyscale) {
            throw new PngjOutputException("cannot write palette for this format");
        }
        if (nw == 0 && this.imgInfo.indexed) {
            throw new PngjOutputException("missing palette");
        }
        this.currentChunkGroup = 3;
        nw = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 4;
    }

    private void writeLastChunks() {
        this.queueChunksFromOther();
        this.currentChunkGroup = 5;
        this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        List<PngChunk> pending = this.chunksList.getQueuedChunks();
        if (!pending.isEmpty()) {
            throw new PngjOutputException(pending.size() + " chunks were not written! Eg: " + pending.get(0).toString());
        }
        this.currentChunkGroup = 6;
    }

    private void writeSignatureAndIHDR() {
        this.currentChunkGroup = 0;
        PngHelperInternal.writeBytes(this.os, PngHelperInternal.getPngIdSignature());
        PngChunkIHDR ihdr = new PngChunkIHDR(this.imgInfo);
        ihdr.setCols(this.imgInfo.cols);
        ihdr.setRows(this.imgInfo.rows);
        ihdr.setBitspc(this.imgInfo.bitDepth);
        int colormodel = 0;
        if (this.imgInfo.alpha) {
            colormodel += 4;
        }
        if (this.imgInfo.indexed) {
            ++colormodel;
        }
        if (!this.imgInfo.greyscale) {
            colormodel += 2;
        }
        ihdr.setColormodel(colormodel);
        ihdr.setCompmeth(0);
        ihdr.setFilmeth(0);
        ihdr.setInterlaced(0);
        ihdr.createRawChunk().writeChunk(this.os);
        this.chunksList.getChunks().add(ihdr);
    }

    private void filterRow() {
        FilterType filterType = FilterType.FILTER_UNKNOWN;
        if (this.filterPreserve && FilterType.isValidStandard(this.rowb[0])) {
            filterType = FilterType.getByVal(this.rowb[0]);
        } else {
            for (FilterType ftype : this.filterStrat.shouldTest(this.rowNum)) {
                this.filterRowWithFilterType(ftype);
                this.filterStrat.reportResultsForFilter(this.rowNum, ftype, this.rowbfilter, true);
            }
            filterType = this.filterStrat.preferedType(this.rowNum);
        }
        this.filterRowWithFilterType(filterType);
        this.filterStrat.reportResultsForFilter(this.rowNum, filterType, this.rowbfilter, false);
    }

    private void filterRowWithFilterType(FilterType filterType) {
        this.rowbfilter[0] = (byte)filterType.val;
        switch (filterType) {
            case FILTER_NONE: {
                this.filterRowNone();
                break;
            }
            case FILTER_SUB: {
                this.filterRowSub();
                break;
            }
            case FILTER_UP: {
                this.filterRowUp();
                break;
            }
            case FILTER_AVERAGE: {
                this.filterRowAverage();
                break;
            }
            case FILTER_PAETH: {
                this.filterRowPaeth();
                break;
            }
            default: {
                throw new PngjUnsupportedException("Filter type " + (Object)((Object)filterType) + " not recognized");
            }
        }
    }

    private void filterAndSend() {
        this.filterRow();
        try {
            this.datStreamDeflated.write(this.rowbfilter, 0, this.imgInfo.bytesPerRow + 1);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    private void filterRowAverage() {
        int imax = this.imgInfo.bytesPerRow;
        int j = 1 - this.imgInfo.bytesPixel;
        int i = 1;
        while (i <= imax) {
            this.rowbfilter[i] = (byte)(this.rowb[i] - ((this.rowbprev[i] & 0xFF) + (j > 0 ? this.rowb[j] & 0xFF : 0)) / 2);
            ++i;
            ++j;
        }
    }

    private void filterRowNone() {
        System.arraycopy(this.rowb, 1, this.rowbfilter, 1, this.imgInfo.bytesPerRow);
    }

    private void filterRowPaeth() {
        int imax = this.imgInfo.bytesPerRow;
        int j = 1 - this.imgInfo.bytesPixel;
        int i = 1;
        while (i <= imax) {
            this.rowbfilter[i] = (byte)PngHelperInternal.filterRowPaeth(this.rowb[i], j > 0 ? this.rowb[j] & 0xFF : 0, this.rowbprev[i] & 0xFF, j > 0 ? this.rowbprev[j] & 0xFF : 0);
            ++i;
            ++j;
        }
    }

    private void filterRowSub() {
        int i;
        for (i = 1; i <= this.imgInfo.bytesPixel; ++i) {
            this.rowbfilter[i] = this.rowb[i];
        }
        int j = 1;
        i = this.imgInfo.bytesPixel + 1;
        while (i <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[i] = (byte)(this.rowb[i] - this.rowb[j]);
            ++i;
            ++j;
        }
    }

    private void filterRowUp() {
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            this.rowbfilter[i] = (byte)(this.rowb[i] - this.rowbprev[i]);
        }
    }

    private void queueChunksFromOther() {
        if (this.copyFromList == null || this.copyFromPredicate == null) {
            return;
        }
        boolean idatDone = this.currentChunkGroup >= 4;
        for (PngChunk chunk : this.copyFromList.getChunks()) {
            boolean copy;
            int group;
            if (chunk.getRaw().data == null || (group = chunk.getChunkGroup()) <= 4 && idatDone || group >= 4 && !idatDone || chunk.crit && !chunk.id.equals("PLTE") || !(copy = this.copyFromPredicate.match(chunk)) || !this.chunksList.getEquivalent(chunk).isEmpty() || !this.chunksList.getQueuedEquivalent(chunk).isEmpty()) continue;
            this.chunksList.queue(chunk);
        }
    }

    public void queueChunk(PngChunk chunk) {
        for (PngChunk other : this.chunksList.getQueuedEquivalent(chunk)) {
            this.getChunksList().removeChunk(other);
        }
        this.chunksList.queue(chunk);
    }

    public void copyChunksFrom(ChunksList chunks, int copyMask) {
        this.copyChunksFrom(chunks, ChunkCopyBehaviour.createPredicate(copyMask, this.imgInfo));
    }

    public void copyChunksFrom(ChunksList chunks) {
        this.copyChunksFrom(chunks, 8);
    }

    public void copyChunksFrom(ChunksList chunks, ChunkPredicate predicate) {
        if (this.copyFromList != null && chunks != null) {
            PngHelperInternal.LOGGER.warning("copyChunksFrom should only be called once");
        }
        if (predicate == null) {
            throw new PngjOutputException("copyChunksFrom requires a predicate");
        }
        this.copyFromList = chunks;
        this.copyFromPredicate = predicate;
    }

    public double computeCompressionRatio() {
        if (this.currentChunkGroup < 6) {
            throw new PngjOutputException("must be called after end()");
        }
        double compressed = this.datStream.getCountFlushed();
        double raw = (this.imgInfo.bytesPerRow + 1) * this.imgInfo.rows;
        return compressed / raw;
    }

    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            this.datStreamDeflated.finish();
            this.datStream.flush();
            this.writeLastChunks();
            this.writeEndChunk();
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
        finally {
            this.close();
        }
    }

    public void close() {
        try {
            this.datStreamDeflated.close();
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            this.datStream.close();
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (this.shouldCloseStream) {
            try {
                this.os.close();
            }
            catch (Exception e) {
                PngHelperInternal.LOGGER.warning("Error closing writer " + e.toString());
            }
        }
        this.datStreamDeflated = null;
    }

    public ChunksListForWrite getChunksList() {
        return this.chunksList;
    }

    public PngMetadata getMetadata() {
        return this.metadata;
    }

    public void setCompLevel(int compLevel) {
        if (compLevel < 0 || compLevel > 9) {
            throw new PngjOutputException("Compression level invalid (" + compLevel + ") Must be 0..9");
        }
        this.compLevel = compLevel;
    }

    public void setFilterType(FilterType filterType) {
        ((FilterWriteStrategy)this.filterStrat).setConfiguredType(filterType);
        if (filterType == FilterType.FILTER_NONE) {
            this.setDeflaterStrategy(0);
        }
    }

    public void setFilterStrategy(IFilterWriteStrategy filterS) {
        this.filterStrat = filterS;
    }

    public boolean isFilterPreserve() {
        return this.filterPreserve;
    }

    public void setFilterPreserve(boolean filterPreserve) {
        this.filterPreserve = filterPreserve;
    }

    public void setIdatMaxSize(int idatMaxSize) {
        this.idatMaxSize = idatMaxSize;
    }

    public void setShouldCloseStream(boolean shouldCloseStream) {
        this.shouldCloseStream = shouldCloseStream;
    }

    public void setDeflaterStrategy(int deflaterStrategy) {
        this.deflaterStrategy = deflaterStrategy;
    }

    public void writeRow(IImageLine imgline) {
        this.writeRow(imgline, this.rowNum + 1);
    }

    public void writeRows(IImageLineSet<? extends IImageLine> imglines) {
        for (int i = 0; i < this.imgInfo.rows; ++i) {
            this.writeRow(imglines.getImageLine(i));
        }
    }

    public void writeRow(IImageLine imgline, int rownumber) {
        ++this.rowNum;
        if (rownumber >= 0 && this.rowNum != rownumber) {
            throw new PngjOutputException("rows must be written in order: expected:" + this.rowNum + " passed:" + rownumber);
        }
        if (this.datStream == null) {
            this.initIdat();
        }
        byte[] tmp = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = tmp;
        this.rowb[0] = (byte)FilterType.FILTER_UNKNOWN.val;
        imgline.writeToPngRaw(this.rowb);
        this.filterAndSend();
    }

    public void writeRowInt(int[] buf) {
        this.writeRow(new ImageLineInt(this.imgInfo, buf));
    }
}

