/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.BufferedStreamFeeder;
import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.ChunkSeqReader;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngReaderDummy {
    protected ChunkSeqReader chunkseq;
    protected final BufferedStreamFeeder streamFeeder;
    protected List<ChunkRaw> chunks = new ArrayList<ChunkRaw>();
    protected boolean includeIdat = true;

    public PngReaderDummy(InputStream inputStream) {
        this.streamFeeder = new BufferedStreamFeeder(inputStream);
    }

    public PngReaderDummy(File file) {
        this(PngHelperInternal.istreamFromFile(file));
        this.setShouldCloseStream(true);
    }

    public void setShouldCloseStream(boolean shouldCloseStream) {
        this.streamFeeder.setCloseStream(shouldCloseStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAll() {
        this.chunkseq = this.createChunkSeqReader();
        try {
            while (!this.chunkseq.isDone()) {
                this.streamFeeder.feed(this.chunkseq);
            }
        }
        finally {
            this.chunkseq.close();
            this.streamFeeder.close();
        }
    }

    protected boolean shouldStoreChunkOnList(ChunkRaw raw) {
        return !raw.id.equals("IDAT") || this.includeIdat;
    }

    private ChunkSeqReader createChunkSeqReader() {
        return new ChunkSeqReader(){

            protected void postProcessChunk(ChunkReader chunkR) {
                super.postProcessChunk(chunkR);
                if (PngReaderDummy.this.shouldStoreChunkOnList(chunkR.getChunkRaw())) {
                    PngReaderDummy.this.chunks.add(chunkR.getChunkRaw());
                }
            }

            protected boolean shouldSkipContent(int len, String id) {
                return true;
            }
        };
    }

    public List<ChunkRaw> getChunks() {
        return this.chunks;
    }

    public void setIncludeIdat(boolean includeIdat) {
        this.includeIdat = includeIdat;
    }
}

