/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import org.geotools.filter.function.FilterFunction_Convert;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class ExpressionTypeEvaluator
implements ExpressionVisitor {
    private SimpleFeatureType schema;
    private CoordinateReferenceSystem crs;

    public ExpressionTypeEvaluator(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Object visit(NilExpression expression, Object extraData) {
        return null;
    }

    public Object visit(Function f, Object extraData) {
        FunctionName fn = f.getFunctionName();
        if (fn != null && fn.getReturn() != null && fn.getReturn().getType() != Object.class) {
            return fn.getReturn().getType();
        }
        if (f instanceof FilterFunction_Convert) {
            return ((Expression)f.getParameters().get(1)).evaluate(null, Class.class);
        }
        return null;
    }

    public Object visit(Literal expression, Object extraData) {
        if (expression.getValue() == null) {
            return null;
        }
        return expression.getValue().getClass();
    }

    public Object visit(PropertyName expression, Object extraData) {
        AttributeDescriptor result = (AttributeDescriptor)expression.evaluate((Object)this.schema, AttributeDescriptor.class);
        if (result == null) {
            throw new IllegalArgumentException("Original feature type does not have a property named " + expression.getPropertyName());
        }
        if (result instanceof GeometryDescriptor) {
            this.crs = ((GeometryDescriptor)result).getCoordinateReferenceSystem();
        }
        return result.getType().getBinding();
    }

    private Object visitMathExpression(BinaryExpression expression) {
        Expression ex1 = expression.getExpression1();
        Expression ex2 = expression.getExpression2();
        Class c1 = this.getMathOperandType(ex1);
        Class c2 = this.getMathOperandType(ex2);
        if (c1 == Integer.class && c2 == Integer.class) {
            return Integer.class;
        }
        if (!(c1 != Integer.class && c1 != Long.class || c2 != Integer.class && c2 != Long.class)) {
            return Long.class;
        }
        return Double.class;
    }

    private Class getMathOperandType(Expression expression) {
        Class result = (Class<Double>)expression.accept((ExpressionVisitor)this, null);
        if (!Number.class.isAssignableFrom(result) && expression instanceof Literal) {
            Double value = (Double)expression.evaluate(null, Double.class);
            if (value != null) {
                if ((double)value.longValue() == value) {
                    result = value < 2.147483647E9 && value > -2.147483648E9 ? Integer.class : Long.class;
                }
            } else {
                result = Double.class;
            }
        }
        return result;
    }

    public Object visit(Multiply expression, Object extraData) {
        return this.visitMathExpression((BinaryExpression)expression);
    }

    public Object visit(Add expression, Object extraData) {
        return this.visitMathExpression((BinaryExpression)expression);
    }

    public Object visit(Divide expression, Object extraData) {
        return this.visitMathExpression((BinaryExpression)expression);
    }

    public Object visit(Subtract expression, Object extraData) {
        return this.visitMathExpression((BinaryExpression)expression);
    }
}

