/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.FeatureSource;
import org.geotools.data.ResourceInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class DefaultResourceInfo
implements ResourceInfo {
    FeatureSource fs;
    Set<String> words;

    public DefaultResourceInfo(FeatureSource fs) {
        this.fs = fs;
        this.words = new HashSet<String>();
        this.words.add("features");
        this.words.add(fs.getSchema().getName().toString());
    }

    @Override
    public ReferencedEnvelope getBounds() {
        try {
            return this.fs.getBounds();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        return this.fs.getSchema().getCoordinateReferenceSystem();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Set<String> getKeywords() {
        return this.words;
    }

    @Override
    public String getName() {
        return this.fs.getSchema().getName().getLocalPart();
    }

    @Override
    public URI getSchema() {
        Name name = this.fs.getSchema().getName();
        try {
            URI namespace = new URI(name.getNamespaceURI());
            return namespace;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public String getTitle() {
        Name name = this.fs.getSchema().getName();
        return name.getLocalPart();
    }
}

