/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.wfs.internal.parsers.XmlComplexFeatureParser;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;

public class ComplexFeatureIteratorImpl
implements FeatureIterator<Feature> {
    private static final Logger LOGGER = Logging.getLogger(ComplexFeatureIteratorImpl.class);
    private XmlComplexFeatureParser parser;
    private Feature parsedFeature;
    private boolean hasNextCalled;

    public ComplexFeatureIteratorImpl(XmlComplexFeatureParser parser) {
        this.parser = parser;
        this.parsedFeature = null;
        this.hasNextCalled = false;
    }

    public boolean hasNext() {
        this.hasNextCalled = true;
        try {
            this.parsedFeature = this.parser.parse();
            return this.parsedFeature != null;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
            this.close();
            return false;
        }
    }

    public Feature next() throws NoSuchElementException {
        if (!this.hasNextCalled) {
            if (this.hasNext()) {
                this.hasNextCalled = false;
                return this.parsedFeature;
            }
            this.close();
            return null;
        }
        this.hasNextCalled = false;
        return this.parsedFeature;
    }

    public void close() {
        try {
            this.parser.close();
            this.parsedFeature = null;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
        }
    }
}

