/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v2_0.storedquery;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class ParameterMappingContext {
    private final Filter filter;
    private final Map<String, String> viewParams;
    private final FeatureTypeInfo featureTypeInfo;
    private Envelope bbox;

    public ParameterMappingContext(Filter filter, Map<String, String> viewParams, FeatureTypeInfo featureTypeInfo) {
        this.filter = filter;
        if (viewParams == null) {
            viewParams = Collections.emptyMap();
        }
        this.viewParams = viewParams;
        this.featureTypeInfo = featureTypeInfo;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Map<String, String> getViewParams() {
        return this.viewParams;
    }

    public FeatureTypeInfo getFeatureTypeInfo() {
        return this.featureTypeInfo;
    }

    public Envelope getBBOX() {
        if (this.bbox != null) {
            return this.bbox;
        }
        this.bbox = new ReferencedEnvelope();
        this.bbox = (Envelope)this.filter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, (Object)this.bbox);
        return this.bbox;
    }
}

