/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.DataSourceException;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.gml3.GML;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.Converters;
import org.geotools.wfs.WFS;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class XmlFeatureParser<FT extends FeatureType, F extends Feature>
implements GetParser<F> {
    protected FT targetType;
    private GeometryFactory geomFac = new GeometryFactory();
    private InputStream inputStream;
    protected XmlPullParser parser;
    final String featureNamespace;
    final String featureName;
    private int numberOfFeatures = -1;
    private static final Logger LOGGER = Loggers.RESPONSES;

    public XmlFeatureParser(InputStream getFeatureResponseStream, FT targetType, QName featureDescriptorName) throws IOException {
        this.inputStream = getFeatureResponseStream;
        this.featureNamespace = featureDescriptorName.getNamespaceURI();
        this.featureName = featureDescriptorName.getLocalPart();
        this.targetType = targetType;
        try {
            this.parser = new MXParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(this.inputStream, "UTF-8");
            this.parser.nextTag();
            this.parser.require(2, "http://www.opengis.net/wfs", WFS.FeatureCollection.getLocalPart());
            String nof = this.parser.getAttributeValue(null, "numberOfFeatures");
            if (nof != null) {
                try {
                    this.numberOfFeatures = Integer.valueOf(nof);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Can't parse numberOfFeatures out of " + nof);
                }
            }
        }
        catch (XmlPullParserException e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    @Override
    public void setGeometryFactory(GeometryFactory geometryFactory) {
        if (null != geometryFactory) {
            this.geomFac = geometryFactory;
        }
    }

    public FT getFeatureType() {
        return this.targetType;
    }

    @Override
    public int getNumberOfFeatures() {
        return this.numberOfFeatures;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            try {
                this.parser.setInput(null);
                this.parser = null;
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (XmlPullParserException e) {
                throw new DataSourceException((Throwable)e);
            }
        }
    }

    protected Object parseAttributeValue(AttributeDescriptor attribute) throws XmlPullParserException, IOException {
        Object parsedValue;
        AttributeType type = attribute.getType();
        if (type instanceof GeometryType) {
            this.parser.nextTag();
            try {
                parsedValue = this.parseGeom();
            }
            catch (NoSuchAuthorityCodeException e) {
                throw new DataSourceException((Throwable)e);
            }
            catch (FactoryException e) {
                throw new DataSourceException((Throwable)e);
            }
        } else {
            String rawTextValue = this.parser.nextText();
            Class binding = type.getBinding();
            parsedValue = Converters.convert((Object)rawTextValue, (Class)binding);
        }
        return parsedValue;
    }

    protected Geometry parseGeom() throws NoSuchAuthorityCodeException, FactoryException, XmlPullParserException, IOException {
        Point geom;
        QName startingGeometryTagName = new QName(this.parser.getNamespace(), this.parser.getName());
        int dimension = this.crsDimension(2);
        CoordinateReferenceSystem crs = this.crs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        if (GML.Point.equals(startingGeometryTagName)) {
            geom = this.parsePoint(dimension, crs);
        } else if (GML.LineString.equals(startingGeometryTagName)) {
            geom = this.parseLineString(dimension, crs);
        } else if (GML.Polygon.equals(startingGeometryTagName)) {
            geom = this.parsePolygon(dimension, crs);
        } else if (GML.MultiPoint.equals(startingGeometryTagName)) {
            geom = this.parseMultiPoint(dimension, crs);
        } else if (GML.MultiLineString.equals(startingGeometryTagName)) {
            geom = this.parseMultiLineString(dimension, crs);
        } else if (GML.MultiSurface.equals(startingGeometryTagName)) {
            geom = this.parseMultiSurface(dimension, crs);
        } else if (GML.MultiPolygon.equals(startingGeometryTagName)) {
            geom = this.parseMultiPolygon(dimension, crs);
        } else {
            throw new IllegalStateException("Unrecognized geometry element " + startingGeometryTagName);
        }
        this.parser.require(3, startingGeometryTagName.getNamespaceURI(), startingGeometryTagName.getLocalPart());
        return geom;
    }

    private Geometry parseMultiPoint(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.nextTag();
        QName memberTag = new QName(this.parser.getNamespace(), this.parser.getName());
        ArrayList<Point> points = new ArrayList<Point>(4);
        if (GML.pointMembers.equals(memberTag)) {
            while (true) {
                this.parser.nextTag();
                if (3 == this.parser.getEventType() && GML.pointMembers.getLocalPart().equals(this.parser.getName())) break;
                Point p = this.parsePoint(dimension, crs);
                points.add(p);
            }
            this.parser.nextTag();
        } else if (GML.pointMember.equals(memberTag)) {
            do {
                this.parser.nextTag();
                this.parser.require(2, "http://www.opengis.net/gml", GML.Point.getLocalPart());
                Point p = this.parsePoint(dimension, crs);
                points.add(p);
                this.parser.nextTag();
                this.parser.require(3, "http://www.opengis.net/gml", GML.pointMember.getLocalPart());
                this.parser.nextTag();
            } while (3 != this.parser.getEventType() || !GML.MultiPoint.getLocalPart().equals(this.parser.getName()));
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.MultiPoint.getLocalPart());
        MultiPoint geom = this.geomFac.createMultiPoint(points.toArray(new Point[points.size()]));
        return geom;
    }

    private MultiLineString parseMultiLineString(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.MultiLineString.getLocalPart());
        ArrayList<LineString> lines = new ArrayList<LineString>(2);
        while (true) {
            this.parser.nextTag();
            if (3 == this.parser.getEventType() && GML.MultiLineString.getLocalPart().equals(this.parser.getName())) break;
            this.parser.require(2, "http://www.opengis.net/gml", GML.lineStringMember.getLocalPart());
            this.parser.nextTag();
            this.parser.require(2, "http://www.opengis.net/gml", GML.LineString.getLocalPart());
            LineString line = this.parseLineString(dimension, crs);
            lines.add(line);
            this.parser.nextTag();
            this.parser.require(3, "http://www.opengis.net/gml", GML.lineStringMember.getLocalPart());
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.MultiLineString.getLocalPart());
        MultiLineString geom = this.geomFac.createMultiLineString(lines.toArray(new LineString[lines.size()]));
        return geom;
    }

    private Geometry parseMultiSurface(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.MultiSurface.getLocalPart());
        this.parser.nextTag();
        QName memberTag = new QName(this.parser.getNamespace(), this.parser.getName());
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(2);
        if (GML.surfaceMembers.equals(memberTag)) {
            while (true) {
                this.parser.nextTag();
                if (3 == this.parser.getEventType() && GML.surfaceMembers.getLocalPart().equals(this.parser.getName())) break;
                Polygon p = this.parsePolygon(dimension, crs);
                polygons.add(p);
            }
            this.parser.nextTag();
        } else if (GML.surfaceMember.equals(memberTag)) {
            do {
                this.parser.nextTag();
                Polygon p = this.parsePolygon(dimension, crs);
                polygons.add(p);
                this.parser.nextTag();
                this.parser.require(3, "http://www.opengis.net/gml", GML.surfaceMember.getLocalPart());
                this.parser.nextTag();
            } while (3 != this.parser.getEventType() || !GML.MultiSurface.getLocalPart().equals(this.parser.getName()));
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.MultiSurface.getLocalPart());
        MultiPolygon geom = this.geomFac.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        return geom;
    }

    private Geometry parseMultiPolygon(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.MultiPolygon.getLocalPart());
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(2);
        this.parser.nextTag();
        do {
            this.parser.require(2, "http://www.opengis.net/gml", GML.polygonMember.getLocalPart());
            this.parser.nextTag();
            this.parser.require(2, "http://www.opengis.net/gml", GML.Polygon.getLocalPart());
            Polygon p = this.parsePolygon(dimension, crs);
            polygons.add(p);
            this.parser.nextTag();
            this.parser.require(3, "http://www.opengis.net/gml", GML.polygonMember.getLocalPart());
            this.parser.nextTag();
        } while (3 != this.parser.getEventType() || !GML.MultiPolygon.getLocalPart().equals(this.parser.getName()));
        this.parser.require(3, "http://www.opengis.net/gml", GML.MultiPolygon.getLocalPart());
        MultiPolygon geom = this.geomFac.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        return geom;
    }

    private Polygon parsePolygon(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        LinearRing shell;
        ArrayList<LinearRing> holes = null;
        this.parser.nextTag();
        this.parser.require(2, "http://www.opengis.net/gml", null);
        QName name = new QName(this.parser.getNamespace(), this.parser.getName());
        if (GML.exterior.equals(name)) {
            this.parser.nextTag();
            shell = this.parseLinearRing(dimension, crs);
            this.parser.nextTag();
            this.parser.require(3, "http://www.opengis.net/gml", GML.exterior.getLocalPart());
        } else if (GML.outerBoundaryIs.equals(name)) {
            this.parser.nextTag();
            this.parser.require(2, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
            shell = this.parseLinearRing(dimension, crs);
            this.parser.nextTag();
            this.parser.require(3, "http://www.opengis.net/gml", GML.outerBoundaryIs.getLocalPart());
        } else {
            throw new IllegalStateException("Unknown polygon boundary element: " + name);
        }
        this.parser.nextTag();
        name = new QName(this.parser.getNamespace(), this.parser.getName());
        if (2 == this.parser.getEventType() && (GML.interior.equals(name) || GML.innerBoundaryIs.equals(name))) {
            holes = new ArrayList<LinearRing>(2);
            do {
                this.parser.require(2, "http://www.opengis.net/gml", name.getLocalPart());
                this.parser.nextTag();
                this.parser.require(2, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
                LinearRing hole = this.parseLinearRing(dimension, crs);
                this.parser.require(3, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
                holes.add(hole);
                this.parser.nextTag();
                this.parser.require(3, "http://www.opengis.net/gml", name.getLocalPart());
                this.parser.nextTag();
            } while (3 != this.parser.getEventType());
            this.parser.require(3, "http://www.opengis.net/gml", GML.Polygon.getLocalPart());
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.Polygon.getLocalPart());
        LinearRing[] holesArray = null;
        if (holes != null) {
            holesArray = holes.toArray(new LinearRing[holes.size()]);
        }
        Polygon geom = this.geomFac.createPolygon(shell, holesArray);
        geom.setUserData((Object)crs);
        return geom;
    }

    private LinearRing parseLinearRing(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
        crs = this.crs(crs);
        Coordinate[] lineCoords = this.parseLineStringInternal(dimension, crs);
        this.parser.require(3, "http://www.opengis.net/gml", GML.LinearRing.getLocalPart());
        LinearRing linearRing = this.geomFac.createLinearRing(lineCoords);
        linearRing.setUserData((Object)crs);
        return linearRing;
    }

    private LineString parseLineString(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.LineString.getLocalPart());
        crs = this.crs(crs);
        Coordinate[] coordinates = this.parseLineStringInternal(dimension, crs);
        this.parser.require(3, "http://www.opengis.net/gml", GML.LineString.getLocalPart());
        LineString geom = this.geomFac.createLineString(coordinates);
        geom.setUserData((Object)crs);
        return geom;
    }

    private Coordinate[] parseLineStringInternal(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException {
        Coordinate[] lineCoords;
        QName lineElementName = new QName(this.parser.getNamespace(), this.parser.getName());
        this.parser.nextTag();
        QName coordsName = new QName(this.parser.getNamespace(), this.parser.getName());
        String tagName = this.parser.getName();
        if (GML.pos.equals(coordsName)) {
            int eventType;
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            do {
                Coordinate[] point = this.parseCoordList(dimension);
                coords.add(point[0]);
                this.parser.nextTag();
                tagName = this.parser.getName();
            } while ((eventType = this.parser.getEventType()) == 2 && tagName == GML.pos.getLocalPart());
            lineCoords = coords.toArray(new Coordinate[coords.size()]);
        } else if (GML.posList.equals(coordsName)) {
            lineCoords = this.parseCoordList(dimension);
            this.parser.nextTag();
        } else if (GML.coordinates.equals(coordsName)) {
            lineCoords = this.parseCoordinates(dimension);
            this.parser.nextTag();
        } else if (GML.coord.equals(coordsName)) {
            int eventType;
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            do {
                Coordinate point = this.parseCoord();
                coords.add(point);
                this.parser.nextTag();
                tagName = this.parser.getName();
            } while ((eventType = this.parser.getEventType()) == 2 && GML.coord.getLocalPart().equals(tagName));
            lineCoords = coords.toArray(new Coordinate[coords.size()]);
        } else {
            throw new IllegalStateException("Expected posList or pos inside LinearRing: " + tagName);
        }
        this.parser.require(3, lineElementName.getNamespaceURI(), lineElementName.getLocalPart());
        return lineCoords;
    }

    private Point parsePoint(int dimension, CoordinateReferenceSystem crs) throws XmlPullParserException, IOException, NoSuchAuthorityCodeException, FactoryException {
        Coordinate point;
        this.parser.require(2, "http://www.opengis.net/gml", GML.Point.getLocalPart());
        crs = this.crs(crs);
        this.parser.nextTag();
        this.parser.require(2, "http://www.opengis.net/gml", null);
        if (GML.pos.getLocalPart().equals(this.parser.getName())) {
            Coordinate[] coords = this.parseCoordList(dimension);
            point = coords[0];
            this.parser.nextTag();
        } else if (GML.coordinates.getLocalPart().equals(this.parser.getName())) {
            Coordinate[] coords = this.parseCoordinates(dimension);
            point = coords[0];
            this.parser.nextTag();
        } else if (GML.coord.getLocalPart().equals(this.parser.getName())) {
            point = this.parseCoord();
            this.parser.nextTag();
        } else {
            throw new IllegalStateException("Unknown coordinate element for Point: " + this.parser.getName());
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.Point.getLocalPart());
        Point geom = this.geomFac.createPoint(point);
        geom.setUserData((Object)crs);
        return geom;
    }

    private Coordinate parseCoord() throws XmlPullParserException, IOException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.coord.getLocalPart());
        double z = 0.0;
        this.parser.nextTag();
        this.parser.require(2, "http://www.opengis.net/gml", "X");
        double x = Double.parseDouble(this.parser.nextText());
        this.parser.nextTag();
        this.parser.require(2, "http://www.opengis.net/gml", "Y");
        double y = Double.parseDouble(this.parser.nextText());
        this.parser.nextTag();
        if (2 == this.parser.getEventType()) {
            this.parser.require(2, "http://www.opengis.net/gml", "Z");
            z = Double.parseDouble(this.parser.nextText());
            this.parser.nextTag();
        }
        this.parser.require(3, "http://www.opengis.net/gml", GML.coord.getLocalPart());
        Coordinate point = new Coordinate(x, y, z);
        return point;
    }

    private CoordinateReferenceSystem crs(CoordinateReferenceSystem defaultValue) throws NoSuchAuthorityCodeException, FactoryException {
        String srsName = this.parser.getAttributeValue(null, "srsName");
        if (srsName == null) {
            return defaultValue;
        }
        boolean forceXY = false;
        if (srsName.startsWith("http://")) {
            forceXY = true;
            srsName = "EPSG:" + srsName.substring(1 + srsName.lastIndexOf(35));
        } else if (srsName.startsWith("EPSG:")) {
            forceXY = true;
        }
        CoordinateReferenceSystem crs = CRS.decode((String)srsName, (boolean)forceXY);
        return crs;
    }

    private int crsDimension(int defaultValue) {
        String srsDimension = this.parser.getAttributeValue(null, "srsDimension");
        if (srsDimension == null) {
            return defaultValue;
        }
        int dimension = Integer.valueOf(srsDimension);
        return dimension;
    }

    private Coordinate[] parseCoordList(int dimension) throws XmlPullParserException, IOException {
        dimension = this.crsDimension(dimension);
        String rawTextValue = this.parser.nextText();
        Coordinate[] coords = this.toCoordList(rawTextValue, dimension);
        return coords;
    }

    private Coordinate[] parseCoordinates(int dimension) throws XmlPullParserException, IOException {
        this.parser.require(2, "http://www.opengis.net/gml", GML.coordinates.getLocalPart());
        dimension = this.crsDimension(dimension);
        String decimalSeparator = this.parser.getAttributeValue("", "decimal");
        String coordSeparator = this.parser.getAttributeValue("", "cs");
        String tupleSeparator = this.parser.getAttributeValue("", "ts");
        String rawTextValue = this.parser.nextText();
        Coordinate[] coords = this.toCoordList(rawTextValue, decimalSeparator, coordSeparator, tupleSeparator, dimension);
        this.parser.require(3, "http://www.opengis.net/gml", GML.coordinates.getLocalPart());
        return coords;
    }

    private Coordinate[] toCoordList(String rawTextValue, int dimension) {
        rawTextValue = rawTextValue.trim();
        rawTextValue = rawTextValue.replaceAll("\n", " ");
        String[] split = (rawTextValue = rawTextValue.replaceAll("\r", " ")).trim().split(" +");
        int ordinatesLength = split.length;
        if (ordinatesLength % dimension != 0) {
            throw new IllegalArgumentException("Number of ordinates (" + ordinatesLength + ") does not match crs dimension: " + dimension);
        }
        int nCoords = ordinatesLength / dimension;
        Coordinate[] coords = new Coordinate[nCoords];
        int currCoordIdx = 0;
        for (int i = 0; i < ordinatesLength; i += dimension) {
            Coordinate coord;
            double x = Double.valueOf(split[i]);
            double y = Double.valueOf(split[i + 1]);
            if (dimension > 2) {
                double z = Double.valueOf(split[i + 2]);
                coord = new Coordinate(x, y, z);
            } else {
                coord = new Coordinate(x, y);
            }
            coords[currCoordIdx] = coord;
            ++currCoordIdx;
        }
        return coords;
    }

    private Coordinate[] toCoordList(String rawTextValue, String decimalSeparator, String coordSeparator, String tupleSeparator, int dimension) {
        rawTextValue = rawTextValue.trim();
        rawTextValue = rawTextValue.replaceAll("\n", " ");
        rawTextValue = rawTextValue.replaceAll("\r", " ");
        String[] tuples = rawTextValue.trim().split("\\" + tupleSeparator + "+");
        int nCoords = tuples.length;
        Coordinate[] coords = new Coordinate[nCoords];
        for (int i = 0; i < nCoords; ++i) {
            Coordinate coord;
            String tuple = tuples[i];
            String[] oridnates = tuple.split("\\" + coordSeparator + "+");
            double[] parsedOrdinates = new double[oridnates.length];
            for (int o = 0; o < oridnates.length; ++o) {
                String ordinate = oridnates[o];
                if (!".".equals(decimalSeparator)) {
                    String[] split = ordinate.split("\\" + decimalSeparator);
                    ordinate = split[0] + '.' + split[1];
                }
                parsedOrdinates[o] = Double.parseDouble(ordinate);
            }
            double x = parsedOrdinates[0];
            double y = parsedOrdinates[1];
            if (dimension > 2 && parsedOrdinates.length > 2) {
                double z = parsedOrdinates[2];
                coord = new Coordinate(x, y, z);
            } else {
                coord = new Coordinate(x, y);
            }
            coords[i] = coord;
        }
        return coords;
    }

    protected String seekFeature() throws IOException, XmlPullParserException {
        while (true) {
            int tagType;
            if ((tagType = this.parser.next()) == 1) {
                this.close();
                return null;
            }
            if (2 != tagType) continue;
            String namespace = this.parser.getNamespace();
            String name = this.parser.getName();
            if (this.featureNamespace.equals(namespace) && this.featureName.equals(name)) break;
        }
        String featureId = this.parser.getAttributeValue(GML.id.getNamespaceURI(), GML.id.getLocalPart());
        if (featureId == null) {
            featureId = this.parser.getAttributeValue(null, "fid");
        }
        if (featureId == null) {
            featureId = this.parser.getAttributeValue(null, "id");
        }
        return featureId;
    }
}

