/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.geotools.data.wfs.internal.GetFeatureParser;
import org.geotools.xml.Configuration;
import org.geotools.xml.PullParser;
import org.geotools.xml.impl.ParserHandler;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;
import org.xml.sax.SAXException;

public class PullParserFeatureReader
implements GetFeatureParser {
    private PullParser parser;
    private InputStream inputStream;
    private FeatureType featureType;

    public PullParserFeatureReader(Configuration wfsConfiguration, InputStream getFeatureResponseStream, FeatureType featureType) throws IOException {
        this.inputStream = getFeatureResponseStream;
        this.featureType = featureType;
        this.parser = new PullParser(wfsConfiguration, getFeatureResponseStream, new QName(featureType.getName().getNamespaceURI(), featureType.getName().getLocalPart()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            finally {
                this.inputStream = null;
                this.parser = null;
            }
        }
    }

    @Override
    public SimpleFeature parse() throws IOException {
        Object parsed;
        try {
            parsed = this.parser.parse();
        }
        catch (XMLStreamException | SAXException e) {
            throw new IOException(e);
        }
        SimpleFeature feature = (SimpleFeature)parsed;
        return feature;
    }

    @Override
    public int getNumberOfFeatures() {
        return -1;
    }

    @Override
    public FeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public void setGeometryFactory(GeometryFactory geometryFactory) {
    }

    public void setContextCustomizer(ParserHandler.ContextCustomizer contextCustomizer) {
        this.parser.setContextCustomizer(contextCustomizer);
    }
}

