/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wfs.internal.GetFeatureParser;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.GetFeatureResponse;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.WFSResponseFactory;
import org.geotools.ows.ServiceException;

public abstract class AbstractGetFeatureResponseParserFactory
implements WFSResponseFactory {
    private static final Logger LOGGER = Loggers.MODULE;

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean canProcess(WFSRequest request, String contentType) {
        if (!WFSOperationType.GET_FEATURE.equals((Object)request.getOperation())) {
            return false;
        }
        if (!this.getSupportedVersions().contains(request.getStrategy().getVersion())) {
            return false;
        }
        boolean matches = this.getSupportedOutputFormats().contains(contentType);
        if (!matches) {
            for (String supported : this.getSupportedOutputFormats()) {
                if (!supported.startsWith(contentType) && !contentType.startsWith(supported)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    @Override
    public WFSResponse createResponse(WFSRequest request, HTTPResponse response) throws IOException {
        GetFeatureParser parser;
        GetFeatureRequest getFeature = (GetFeatureRequest)request;
        String contentType = response.getContentType();
        if (this.getSupportedOutputFormats().contains(contentType)) {
            parser = this.parser(getFeature, response.getResponseStream());
        } else {
            String line;
            int r;
            int buffSize = LOGGER.isLoggable(Level.FINER) ? 4096 : 512;
            PushbackInputStream pushbackIn = new PushbackInputStream(response.getResponseStream(), buffSize);
            byte[] buff = new byte[buffSize];
            int readCount = 0;
            while ((r = pushbackIn.read(buff, readCount, buffSize - readCount)) != -1 && (readCount += r) != buffSize) {
            }
            String charset = response.getResponseHeader("Charset");
            try {
                Charset.forName(charset);
            }
            catch (Exception e) {
                charset = "UTF-8";
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buff), charset));
            StringBuilder head = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                head.append(line).append('\n');
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                System.err.println("Response head:");
                System.err.println(head);
            }
            pushbackIn.unread(buff, 0, readCount);
            if (head.indexOf("FeatureCollection") > 0) {
                parser = this.parser(getFeature, pushbackIn);
            } else {
                if (head.indexOf("ExceptionReport") > 0) {
                    throw new UnsupportedOperationException("implement!");
                }
                throw new IllegalStateException("Unkown server response: " + head);
            }
        }
        try {
            return new GetFeatureResponse(request, response, parser);
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean canProcess(WFSOperationType operation) {
        return WFSOperationType.GET_FEATURE.equals((Object)operation);
    }

    protected abstract GetFeatureParser parser(GetFeatureRequest var1, InputStream var2) throws IOException;

    protected abstract List<String> getSupportedVersions();
}

