/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.wfs.internal.GetFeatureParser;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.ows.ServiceException;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class GetFeatureResponse
extends WFSResponse {
    private final GetFeatureParser features;
    private boolean featuresReturned;

    public GetFeatureResponse(WFSRequest originatingRequest, HTTPResponse httpResponse, GetFeatureParser features) throws ServiceException, IOException {
        super(originatingRequest, httpResponse);
        this.features = features;
    }

    public GetFeatureParser getFeatures() {
        return this.features;
    }

    public GetFeatureParser getFeatures(GeometryFactory geometryFactory) {
        if (this.featuresReturned) {
            throw new IllegalStateException("getFeatures can be called only once");
        }
        GetFeatureParser features = this.getFeatures();
        if (geometryFactory != null) {
            features.setGeometryFactory(geometryFactory);
        }
        this.featuresReturned = true;
        return features;
    }

    public GetFeatureParser getSimpleFeatures(GeometryFactory geometryFactory) {
        GetFeatureParser rawFeatures = this.getFeatures(geometryFactory);
        FeatureType featureType = rawFeatures.getFeatureType();
        if (featureType instanceof SimpleFeatureType) {
            return rawFeatures;
        }
        throw new UnsupportedOperationException("implementa adapting to SimpleFeature");
    }
}

