/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class PropertyExistsFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("PropertyExists", FunctionNameImpl.parameter("exists", Boolean.class), FunctionNameImpl.parameter("propertyName", Object.class));

    public PropertyExistsFunction() {
        super(NAME);
    }

    private String getPropertyName() {
        Expression expr = this.getParameters().get(0);
        return this.getPropertyName(expr);
    }

    private String getPropertyName(Expression expr) {
        String propertyName;
        if (expr instanceof Literal) {
            propertyName = String.valueOf(((Literal)expr).getValue());
        } else if (expr instanceof PropertyName) {
            propertyName = ((PropertyName)expr).getPropertyName();
        } else {
            throw new IllegalStateException("Not a property name expression: " + expr);
        }
        return propertyName;
    }

    public Object evaluate(SimpleFeature feature) {
        String propName = this.getPropertyName();
        AttributeDescriptor attributeType = feature.getFeatureType().getDescriptor(propName);
        return attributeType != null;
    }

    @Override
    public Object evaluate(Object bean) {
        if (bean instanceof SimpleFeature) {
            return this.evaluate((SimpleFeature)bean);
        }
        String propName = this.getPropertyName();
        try {
            Class<?> type = bean.getClass();
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                if (!descriptor.getName().equals(propName)) continue;
                if (descriptor.getReadMethod() != null) {
                    return true;
                }
                return false;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("PropertyExists('");
        sb.append(this.getPropertyName());
        sb.append("')");
        String stringVal = sb.toString();
        return stringVal;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyExistsFunction)) {
            return false;
        }
        PropertyExistsFunction other = (PropertyExistsFunction)obj;
        if (other.getParameters().size() != this.getParameters().size()) {
            return false;
        }
        if (other.getParameters().size() > 0) {
            String propName = this.getPropertyName();
            Expression otherPropNameExpr = other.getParameters().get(0);
            String otherPropName = this.getPropertyName(otherPropNameExpr);
            return Utilities.equals((Object)propName, (Object)otherPropName);
        }
        return true;
    }
}

