/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web.publish;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.web.publish.LayerConfigurationPanel;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.SimpleChoiceRenderer;

public class WCSLayerConfig
extends LayerConfigurationPanel {
    private static final List<String> WCS_FORMATS = Arrays.asList("GIF", "PNG", "JPEG", "TIFF", "GTOPO30", "GEOTIFF", "IMAGEMOSAIC", "ARCGRID");
    private static final List<String> INTERPOLATIONS = Arrays.asList("nearest neighbor", "bilinear", "bicubic");
    private List<String> selectedRequestSRSs;
    private List<String> selectedResponseSRSs;
    private List<String> selectedInterpolationMethods;
    private String newRequestSRS;
    private String newResponseSRS;
    private String newInterpolationMethod;

    public WCSLayerConfig(String id, IModel model) {
        super(id, model);
        final CoverageInfo coverage = (CoverageInfo)this.getLayerInfo().getResource();
        this.add(new Component[]{new ListMultipleChoice("requestSRS", (IModel)new PropertyModel((Object)this, "selectedRequestSRSs"), coverage.getRequestSRS())});
        this.add(new Component[]{new TextField("newRequestSRS", (IModel)new PropertyModel((Object)this, "newRequestSRS"))});
        this.add(new Component[]{new Button("deleteSelectedRequestSRSs"){

            public void onSubmit() {
                coverage.getRequestSRS().removeAll(WCSLayerConfig.this.selectedRequestSRSs);
                WCSLayerConfig.this.selectedRequestSRSs.clear();
            }
        }});
        this.add(new Component[]{new Button("addNewRequestSRS"){

            public void onSubmit() {
                coverage.getRequestSRS().add(WCSLayerConfig.this.newRequestSRS);
                WCSLayerConfig.this.newRequestSRS = "";
            }
        }});
        this.add(new Component[]{new ListMultipleChoice("responseSRS", (IModel)new PropertyModel((Object)this, "selectedResponseSRSs"), coverage.getResponseSRS())});
        this.add(new Component[]{new TextField("newResponseSRS", (IModel)new PropertyModel((Object)this, "newResponseSRS"))});
        this.add(new Component[]{new Button("deleteSelectedResponseSRSs"){

            public void onSubmit() {
                coverage.getResponseSRS().removeAll(WCSLayerConfig.this.selectedResponseSRSs);
                WCSLayerConfig.this.selectedResponseSRSs.clear();
            }
        }});
        this.add(new Component[]{new Button("addNewResponseSRS"){

            public void onSubmit() {
                coverage.getResponseSRS().add(WCSLayerConfig.this.newResponseSRS);
                WCSLayerConfig.this.newResponseSRS = "";
            }
        }});
        this.add(new Component[]{new DropDownChoice("defaultInterpolationMethod", (IModel)new PropertyModel((Object)coverage, "defaultInterpolationMethod"), (IModel)new WCSInterpolationModel())});
        Palette interpolationMethods = new Palette("interpolationMethods", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)coverage, "interpolationMethods")), (IModel)new WCSInterpolationModel(), (IChoiceRenderer)new SimpleChoiceRenderer(), 7, false){

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("InterpolationMethodsPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("InterpolationMethodsPalette.availableHeader"));
            }
        };
        this.add(new Component[]{interpolationMethods});
        TextField nativeFormat = new TextField("nativeFormat", (IModel)new PropertyModel((Object)coverage, "nativeFormat"));
        nativeFormat.setEnabled(false);
        this.add(new Component[]{nativeFormat});
        Palette formatPalette = new Palette("formatPalette", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)coverage, "supportedFormats")), (IModel)new WCSFormatsModel(), (IChoiceRenderer)new SimpleChoiceRenderer(), 10, false){

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("FormatsPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("FormatsPalette.availableHeader"));
            }
        };
        this.add(new Component[]{formatPalette});
    }

    static class WCSInterpolationModel
    extends LoadableDetachableModel {
        WCSInterpolationModel() {
            super(new ArrayList(INTERPOLATIONS));
        }

        protected Object load() {
            return new ArrayList(INTERPOLATIONS);
        }
    }

    static class WCSFormatsModel
    extends LoadableDetachableModel {
        WCSFormatsModel() {
            super(new ArrayList(WCS_FORMATS));
        }

        protected Object load() {
            return new ArrayList(WCS_FORMATS);
        }
    }
}

