/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.servlet;

import com.noelios.restlet.http.HttpServerCall;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Server;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletCall
extends HttpServerCall {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Series<Parameter> requestHeaders;

    public ServletCall(Server server, HttpServletRequest request, HttpServletResponse response) {
        super(server);
        this.request = request;
        this.response = response;
    }

    public ServletCall(Logger logger, String serverAddress, int serverPort, HttpServletRequest request, HttpServletResponse response) {
        super(logger, serverAddress, serverPort);
        this.request = request;
        this.response = response;
    }

    @Override
    public String getClientAddress() {
        return this.getRequest().getRemoteAddr();
    }

    @Override
    public int getClientPort() {
        return this.getRequest().getRemotePort();
    }

    @Override
    public String getHostDomain() {
        return this.getRequest().getServerName();
    }

    @Override
    public String getMethod() {
        return this.getRequest().getMethod();
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.valueOf(this.getRequest().getScheme());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public ReadableByteChannel getRequestChannel() {
        return null;
    }

    @Override
    public Series<Parameter> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new Form();
            Enumeration names = this.getRequest().getHeaderNames();
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                Enumeration values = this.getRequest().getHeaders(headerName);
                while (values.hasMoreElements()) {
                    String headerValue = (String)values.nextElement();
                    this.requestHeaders.add(new Parameter(headerName, headerValue));
                }
            }
        }
        return this.requestHeaders;
    }

    @Override
    public InputStream getRequestStream() {
        try {
            return this.getRequest().getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getRequestUri() {
        String queryString = this.getRequest().getQueryString();
        if (queryString == null || queryString.equals("")) {
            return this.getRequest().getRequestURI();
        }
        return this.getRequest().getRequestURI() + '?' + queryString;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public WritableByteChannel getResponseChannel() {
        return null;
    }

    @Override
    public OutputStream getResponseStream() {
        try {
            return this.getResponse().getOutputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getServerAddress() {
        return this.getRequest().getLocalAddr();
    }

    @Override
    public int getServerPort() {
        return this.getRequest().getServerPort();
    }

    @Override
    public String getVersion() {
        String result = null;
        int index = this.getRequest().getProtocol().indexOf(47);
        if (index != -1) {
            result = this.getRequest().getProtocol().substring(index + 1);
        }
        return result;
    }

    @Override
    public boolean isConfidential() {
        return this.getRequest().isSecure();
    }

    @Override
    public void sendResponse(Response response) throws IOException {
        for (Parameter header : this.getResponseHeaders()) {
            this.getResponse().addHeader(header.getName(), header.getValue());
        }
        if (Status.isError(this.getStatusCode()) && response == null) {
            try {
                this.getResponse().sendError(this.getStatusCode(), this.getReasonPhrase());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to set the response error status", ioe);
            }
        } else {
            this.getResponse().setStatus(this.getStatusCode());
            super.sendResponse(response);
        }
    }
}

