/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map.png;

import ar.com.hjg.pngj.FilterType;
import it.geosolutions.imageio.plugins.png.PNGWriter;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMSMapContent;
import org.geotools.image.ImageWorker;
import org.geotools.map.Layer;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;

public class PNGJWriter {
    private static final Logger LOGGER = Logging.getLogger(PNGJWriter.class);

    public RenderedImage writePNG(RenderedImage image, OutputStream outStream, float quality, WMSMapContent mapContent) {
        FilterType filterType = this.getFilterType(mapContent);
        PNGWriter writer = new PNGWriter();
        boolean isScanlineSupported = writer.isScanlineSupported(image);
        if (!isScanlineSupported) {
            image = new ImageWorker(image).rescaleToBytes().forceComponentColorModel().getRenderedImage();
        }
        RenderedImage output = null;
        try {
            output = writer.writePNG(image, outStream, quality, filterType);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to encode the PNG", e);
            throw new ServiceException((Throwable)e);
        }
        return output;
    }

    private FilterType getFilterType(WMSMapContent mapContent) {
        RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor();
        for (Layer layer : mapContent.layers()) {
            Style style = layer.getStyle();
            if (style == null) continue;
            style.accept((StyleVisitor)visitor);
            if (!visitor.highChangeRasterSymbolizer) continue;
            return FilterType.FILTER_SUB;
        }
        return FilterType.FILTER_NONE;
    }

    class RasterSymbolizerVisitor
    extends AbstractStyleVisitor {
        boolean highChangeRasterSymbolizer;

        RasterSymbolizerVisitor() {
        }

        public void visit(RasterSymbolizer raster) {
            if (raster.getColorMap() == null) {
                this.highChangeRasterSymbolizer = true;
                return;
            }
            int cmType = raster.getColorMap().getType();
            if (cmType != 2 && cmType != 3) {
                this.highChangeRasterSymbolizer = true;
            }
        }
    }
}

