/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.vividsolutions.jts.geom.Envelope;
import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.lookup.LookupTableFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSPartialMapException;
import org.geoserver.wms.WMSServiceExceptionHandler;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.decoration.MetatiledMapDecorationLayout;
import org.geoserver.wms.decoration.WatermarkDecoration;
import org.geoserver.wms.map.AbstractMapOutputFormat;
import org.geoserver.wms.map.ImageUtils;
import org.geoserver.wms.map.KMLStyleFilteringVisitor;
import org.geoserver.wms.map.MaxErrorEnforcer;
import org.geoserver.wms.map.MetatileMapOutputFormat;
import org.geoserver.wms.map.PaletteExtractor;
import org.geoserver.wms.map.RasterSymbolizerVisitor;
import org.geoserver.wms.map.RenderExceptionStrategy;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geoserver.wms.map.RenderingTimeoutEnforcer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.Query;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.StyleLayer;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.RenderingTransformationHelper;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.BoundingBox;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class RenderedImageMapOutputFormat
extends AbstractMapOutputFormat {
    private static final Interpolation NN_INTERPOLATION = new InterpolationNearest();
    private static final Interpolation BIL_INTERPOLATION = new InterpolationBilinear();
    private static final Interpolation BIC_INTERPOLATION = new InterpolationBicubic2(0);
    private static final String AA_NONE = "NONE";
    private static final String AA_TEXT = "TEXT";
    private static final String AA_FULL = "FULL";
    private static final List<String> AA_SETTINGS = Arrays.asList("NONE", "TEXT", "FULL");
    private static final int KB = 1024;
    private static LookupTableJAI IDENTITY_TABLE = new LookupTableJAI(RenderedImageMapOutputFormat.getTable());
    private static final Logger LOGGER = Logging.getLogger(RenderedImageMapOutputFormat.class);
    private static final String DEFAULT_MAP_FORMAT = "image/png";
    protected final WMS wms;
    private boolean palleteSupported = true;
    private boolean transparencySupported = true;
    private String extension = null;
    private final Map<String, MapProducerCapabilities> capabilities = new HashMap<String, MapProducerCapabilities>();

    private static byte[] getTable() {
        byte[] arr = new byte[256];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)i;
        }
        return arr;
    }

    public RenderedImageMapOutputFormat(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public RenderedImageMapOutputFormat(String mime, WMS wms) {
        this(mime, new String[]{mime}, wms);
    }

    public RenderedImageMapOutputFormat(String mime, String[] outputFormats, WMS wms) {
        super(mime, outputFormats);
        this.wms = wms;
        Collection<RenderedImageMapResponse> responses = this.wms.getAvailableMapResponses();
        for (RenderedImageMapResponse response : responses) {
            for (String outFormat : outputFormats) {
                MapProducerCapabilities cap;
                if (!response.getOutputFormats().contains(outFormat) || (cap = response.getCapabilities(outFormat)) == null) continue;
                this.capabilities.put(outFormat, cap);
            }
        }
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        return this.capabilities.get(format);
    }

    @Override
    public final RenderedImageMap produceMap(WMSMapContent mapContent) throws ServiceException {
        return this.produceMap(mapContent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImageMap produceMap(final WMSMapContent mapContent, boolean tiled) throws ServiceException {
        GetMapRequest request;
        String antialias;
        Rectangle paintArea = new Rectangle(0, 0, mapContent.getMapWidth(), mapContent.getMapHeight());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + paintArea.width + "x" + paintArea.height + " image");
        }
        if ((antialias = (String)(request = mapContent.getRequest()).getFormatOptions().get("antialias")) != null) {
            antialias = antialias.toUpperCase();
        }
        IndexColorModel potentialPalette = null;
        boolean transparent = mapContent.isTransparent() && this.isTransparencySupported();
        Color bgColor = mapContent.getBgColor();
        if (AA_NONE.equals(antialias)) {
            potentialPalette = mapContent.getPalette();
        } else if (AA_NONE.equals(antialias)) {
            PaletteExtractor pe = new PaletteExtractor(transparent ? null : bgColor);
            List layers = mapContent.layers();
            for (int i = 0; i < layers.size(); ++i) {
                pe.visit(((Layer)layers.get(i)).getStyle());
                if (!pe.canComputePalette()) break;
            }
            if (pe.canComputePalette()) {
                potentialPalette = pe.getPalette();
            }
        }
        final IndexColorModel palette = potentialPalette;
        long maxMemory = this.wms.getMaxRequestMemory() * 1024;
        long memory = this.getDrawingSurfaceMemoryUse(paintArea.width, paintArea.height, palette, transparent);
        StreamingRenderer testRenderer = new StreamingRenderer();
        testRenderer.setMapContent((MapContent)mapContent);
        if (maxMemory > 0L && (memory += (long)testRenderer.getMaxBackBufferMemory(paintArea.width, paintArea.height)) > maxMemory) {
            long kbUsed = memory / 1024L;
            long kbMax = maxMemory / 1024L;
            throw new ServiceException("Rendering request would use " + kbUsed + "KB, whilst the " + "maximum memory allowed is " + kbMax + "KB");
        }
        MapDecorationLayout layout = this.findDecorationLayout(request, tiled);
        RenderedImage image = null;
        if (DefaultWebMapService.isDirectRasterPathEnabled() && mapContent.layers().size() == 1 && mapContent.getAngle() == 0.0 && (layout == null || layout.isEmpty())) {
            ArrayList<GridCoverage2D> renderedCoverages = new ArrayList<GridCoverage2D>(2);
            try {
                Interpolation interpolation = null;
                if (request.getInterpolations() != null && request.getInterpolations().size() > 0) {
                    interpolation = request.getInterpolations().get(0);
                }
                image = this.directRasterRender(mapContent, 0, renderedCoverages, interpolation);
            }
            catch (Exception e) {
                throw new ServiceException("Error rendering coverage on the fast path", (Throwable)e);
            }
            if (image != null) {
                return this.buildMap(mapContent, image);
            }
        }
        boolean useAlpha = transparent || MetatileMapOutputFormat.isRequestTiled(request, this);
        final RenderedImage preparedImage = this.prepareImage(paintArea.width, paintArea.height, palette, useAlpha);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D graphic = this.getGraphics(transparent, bgColor, preparedImage, hintsMap);
        if (AA_NONE.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (preparedImage.getColorModel() instanceof IndexColorModel) {
                hintsMap.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            }
        } else if (AA_TEXT.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            if (antialias != null && !AA_FULL.equals(antialias)) {
                LOGGER.warning("Unrecognized antialias setting '" + antialias + "', valid values are " + AA_SETTINGS);
            }
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        hintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        hintsMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.wms != null) {
            if (WMSInfo.WMSInterpolation.Nearest.equals((Object)this.wms.getInterpolation())) {
                hintsMap.put(JAI.KEY_INTERPOLATION, NN_INTERPOLATION);
                hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            } else if (WMSInfo.WMSInterpolation.Bilinear.equals((Object)this.wms.getInterpolation())) {
                hintsMap.put(JAI.KEY_INTERPOLATION, BIL_INTERPOLATION);
                hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else if (WMSInfo.WMSInterpolation.Bicubic.equals((Object)this.wms.getInterpolation())) {
                hintsMap.put(JAI.KEY_INTERPOLATION, BIC_INTERPOLATION);
                hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        graphic.setRenderingHints(hintsMap);
        RenderingHints hints = new RenderingHints(hintsMap);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setThreadPool(DefaultWebMapService.getRenderingPool());
        renderer.setMapContent((MapContent)mapContent);
        renderer.setJava2DHints(hints);
        HashMap<String, Object> rendererParams = new HashMap<String, Object>();
        rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
        rendererParams.put("renderingBuffer", new Integer(mapContent.getBuffer()));
        rendererParams.put("maxFiltersToSendToDatastore", DefaultWebMapService.getMaxFilterRules());
        rendererParams.put("scaleComputationMethod", mapContent.getRendererScaleMethod());
        if (AA_NONE.equals(antialias)) {
            rendererParams.put("textRenderingMethod", StreamingRenderer.TEXT_RENDERING_STRING);
        } else {
            rendererParams.put("textRenderingMethod", StreamingRenderer.TEXT_RENDERING_OUTLINE);
        }
        if (DefaultWebMapService.isLineWidthOptimizationEnabled()) {
            rendererParams.put("lineWidthOptimization", true);
        }
        if (this.wms.isAdvancedProjectionHandlingEnabled()) {
            rendererParams.put("advancedProjectionHandling", true);
            if (this.wms.isContinuousMapWrappingEnabled()) {
                rendererParams.put("continuousMapWrapping", true);
            }
        }
        if (request.getFormatOptions().get("dpi") != null) {
            rendererParams.put("dpi", request.getFormatOptions().get("dpi"));
        }
        boolean kmplacemark = false;
        if (request.getFormatOptions().get("kmplacemark") != null) {
            kmplacemark = (Boolean)request.getFormatOptions().get("kmplacemark");
        }
        if (kmplacemark) {
            KMLStyleFilteringVisitor dupVisitor = new KMLStyleFilteringVisitor();
            List layers = mapContent.layers();
            for (int i = 0; i < layers.size(); ++i) {
                if (!(layers.get(i) instanceof StyleLayer)) continue;
                StyleLayer layer = (StyleLayer)layers.get(i);
                Style style = layer.getStyle();
                style.accept((StyleVisitor)dupVisitor);
                Style copy = (Style)dupVisitor.getCopy();
                layer.setStyle(copy);
            }
        }
        if (request.getInterpolations() != null && !request.getInterpolations().isEmpty()) {
            int count = 0;
            List<Interpolation> interpolations = request.getInterpolations();
            for (StyleLayer layer : mapContent.layers()) {
                Interpolation interpolation;
                if (count < interpolations.size() && (interpolation = interpolations.get(count)) != null) {
                    layer.getUserData().put("byLayerInterpolation", interpolation);
                }
                ++count;
            }
        }
        renderer.setRendererHints(rendererParams);
        int maxErrors = this.wms.getMaxRenderingErrors();
        MaxErrorEnforcer errorChecker = new MaxErrorEnforcer((GTRenderer)renderer, maxErrors);
        RenderExceptionStrategy nonIgnorableExceptionListener = new RenderExceptionStrategy((GTRenderer)renderer);
        renderer.addRenderListener((RenderListener)nonIgnorableExceptionListener);
        this.onBeforeRender(renderer);
        int localMaxRenderingTime = 0;
        Object timeoutOption = request.getFormatOptions().get("timeout");
        if (timeoutOption != null) {
            try {
                localMaxRenderingTime = Integer.parseInt(timeoutOption.toString());
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not parse format_option \"timeout\": " + timeoutOption, e);
            }
        }
        int maxRenderingTime = this.getMaxRenderingTime(localMaxRenderingTime);
        ServiceException serviceException = null;
        boolean saveMap = request.getRawKvp() != null && WMSServiceExceptionHandler.isPartialMapExceptionType(request.getRawKvp().get("EXCEPTIONS"));
        RenderingTimeoutEnforcer timeout = new RenderingTimeoutEnforcer(maxRenderingTime, (GTRenderer)renderer, graphic, saveMap){

            @Override
            public void saveMap() {
                this.map = RenderedImageMapOutputFormat.this.optimizeAndBuildMap(palette, preparedImage, mapContent);
            }
        };
        timeout.start();
        try {
            Object renderError;
            renderer.paint(graphic, paintArea, mapContent.getRenderingArea(), mapContent.getRenderingTransform());
            if (layout != null) {
                try {
                    layout.paint(graphic, paintArea, mapContent);
                }
                catch (Exception e) {
                    throw new ServiceException("Problem occurred while trying to watermark data", (Throwable)e);
                }
            }
            timeout.stop();
            if (errorChecker.exceedsMaxErrors()) {
                serviceException = new ServiceException("More than " + maxErrors + " rendering errors occurred, bailing out.", (Throwable)errorChecker.getLastException(), "internalError");
            }
            if (timeout.isTimedOut()) {
                serviceException = new ServiceException("This request used more time than allowed and has been forcefully stopped. Max rendering time is " + (double)maxRenderingTime / 1000.0 + "s");
            }
            if (nonIgnorableExceptionListener.exceptionOccurred()) {
                renderError = nonIgnorableExceptionListener.getException();
                serviceException = new ServiceException("Rendering process failed", (Throwable)renderError, "internalError");
            }
            if (serviceException == null) {
                renderError = this.optimizeAndBuildMap(palette, preparedImage, mapContent);
                return renderError;
            }
            if (saveMap) {
                RenderedImageMap map = (RenderedImageMap)timeout.getMap();
                if (map == null) {
                    map = this.optimizeAndBuildMap(palette, preparedImage, mapContent);
                }
                serviceException = new WMSPartialMapException(serviceException, (WebMap)map);
            }
        }
        finally {
            timeout.stop();
            graphic.dispose();
        }
        throw serviceException;
    }

    private RenderedImageMap optimizeAndBuildMap(IndexColorModel palette, RenderedImage preparedImage, WMSMapContent mapContent) {
        RenderedImage image = palette != null && palette.getMapSize() < 256 ? RenderedImageMapOutputFormat.optimizeSampleModel(preparedImage) : preparedImage;
        return this.buildMap(mapContent, image);
    }

    protected Graphics2D getGraphics(boolean transparent, Color bgColor, RenderedImage preparedImage, Map<RenderingHints.Key, Object> hintsMap) {
        return ImageUtils.prepareTransparency(transparent, bgColor, preparedImage, hintsMap);
    }

    public int getMaxRenderingTime(int localMaxRenderingTime) {
        int maxRenderingTime = this.wms.getMaxRenderingTime() * 1000;
        if (maxRenderingTime == 0) {
            maxRenderingTime = localMaxRenderingTime;
        } else if (localMaxRenderingTime != 0) {
            maxRenderingTime = Math.min(maxRenderingTime, localMaxRenderingTime);
        }
        return maxRenderingTime;
    }

    protected void onBeforeRender(StreamingRenderer renderer) {
    }

    protected RenderedImageMap buildMap(WMSMapContent mapContent, RenderedImage image) {
        RenderedImageMap map = new RenderedImageMap(mapContent, image, this.getMimeType());
        if (this.extension != null) {
            map.setContentDispositionHeader(mapContent, "." + this.extension, false);
        }
        return map;
    }

    protected MapDecorationLayout findDecorationLayout(GetMapRequest request, boolean tiled) {
        MapDecorationLayout.Block watermark;
        String layoutName = null;
        if (request.getFormatOptions() != null) {
            layoutName = (String)request.getFormatOptions().get("layout");
        }
        MapDecorationLayout layout = null;
        if (layoutName != null) {
            try {
                GeoServerResourceLoader loader = this.wms.getCatalog().getResourceLoader();
                Resource layouts = loader.get("layouts");
                if (layouts.getType() == Resource.Type.DIRECTORY) {
                    Resource layoutConfig = layouts.get(layoutName + ".xml");
                    if (layoutConfig.getType() == Resource.Type.RESOURCE) {
                        File layoutConfigFile = layoutConfig.file();
                        layout = MapDecorationLayout.fromFile(layoutConfigFile, tiled);
                    } else {
                        LOGGER.log(Level.WARNING, "Unknown layout requested: " + layoutName);
                    }
                } else {
                    LOGGER.log(Level.WARNING, "No layouts directory defined");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to load layout: " + layoutName, e);
            }
        }
        if (layout == null) {
            MapDecorationLayout mapDecorationLayout = layout = tiled ? new MetatiledMapDecorationLayout() : new MapDecorationLayout();
        }
        if ((watermark = RenderedImageMapOutputFormat.getWatermark(this.wms.getServiceInfo())) != null) {
            layout.addBlock(watermark);
        }
        return layout;
    }

    public static MapDecorationLayout.Block getWatermark(WMSInfo wms) {
        WatermarkInfo watermark;
        WatermarkInfo watermarkInfo = watermark = wms == null ? null : wms.getWatermark();
        if (watermark != null && watermark.isEnabled()) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("url", watermark.getURL());
            options.put("opacity", Float.toString((255.0f - (float)watermark.getTransparency()) / 2.55f));
            WatermarkDecoration d = new WatermarkDecoration();
            try {
                d.loadOptions(options);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Couldn't construct watermark from configuration", e);
                throw new ServiceException((Throwable)e);
            }
            MapDecorationLayout.Block.Position p = null;
            switch (watermark.getPosition()) {
                case TOP_LEFT: {
                    p = MapDecorationLayout.Block.Position.UL;
                    break;
                }
                case TOP_CENTER: {
                    p = MapDecorationLayout.Block.Position.UC;
                    break;
                }
                case TOP_RIGHT: {
                    p = MapDecorationLayout.Block.Position.UR;
                    break;
                }
                case MID_LEFT: {
                    p = MapDecorationLayout.Block.Position.CL;
                    break;
                }
                case MID_CENTER: {
                    p = MapDecorationLayout.Block.Position.CC;
                    break;
                }
                case MID_RIGHT: {
                    p = MapDecorationLayout.Block.Position.CR;
                    break;
                }
                case BOT_LEFT: {
                    p = MapDecorationLayout.Block.Position.LL;
                    break;
                }
                case BOT_CENTER: {
                    p = MapDecorationLayout.Block.Position.LC;
                    break;
                }
                case BOT_RIGHT: {
                    p = MapDecorationLayout.Block.Position.LR;
                    break;
                }
                default: {
                    throw new ServiceException("Unknown WatermarkInfo.Position value.  Something is seriously wrong.");
                }
            }
            return new MapDecorationLayout.Block(d, p, null, new Point(0, 0));
        }
        return null;
    }

    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        return ImageUtils.createImage(width, height, this.isPaletteSupported() ? palette : null, transparent && this.isTransparencySupported());
    }

    public boolean isTransparencySupported() {
        return this.transparencySupported;
    }

    public void setTransparencySupported(boolean supportsTransparency) {
        this.transparencySupported = supportsTransparency;
    }

    public boolean isPaletteSupported() {
        return this.palleteSupported;
    }

    public void setPaletteSupported(boolean supportsPalette) {
        this.palleteSupported = supportsPalette;
    }

    protected long getDrawingSurfaceMemoryUse(int width, int height, IndexColorModel palette, boolean transparent) {
        return ImageUtils.getDrawingSurfaceMemoryUse(width, height, this.isPaletteSupported() ? palette : null, transparent && this.isTransparencySupported());
    }

    private static RenderedImage optimizeSampleModel(RenderedImage source) {
        int w = source.getWidth();
        int h = source.getHeight();
        ImageLayout layout = new ImageLayout();
        layout.setColorModel(source.getColorModel());
        layout.setSampleModel(source.getColorModel().createCompatibleSampleModel(w, h));
        layout.setTileWidth(w);
        layout.setTileHeight(h);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        LookupTable table = LookupTableFactory.create((LookupTableJAI)IDENTITY_TABLE);
        ImageWorker worker = new ImageWorker(source);
        worker.setRenderingHints(hints);
        worker.lookup(table);
        return worker.getRenderedImage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RenderedImage directRasterRender(WMSMapContent mapContent, int layerIndex, List<GridCoverage2D> renderedCoverages, Interpolation layerInterpolation) throws IOException, FactoryException {
        RenderedImage image;
        int tileSizeX;
        int tileSizeY;
        Color bgColor;
        boolean transparent;
        Rectangle mapRasterArea;
        int mapHeight;
        int mapWidth;
        block46: {
            double scaleDenominator = mapContent.getScaleDenominator(true);
            Layer layer = (Layer)mapContent.layers().get(layerIndex);
            FeatureType featureType = layer.getFeatureSource().getSchema();
            Style style = layer.getStyle();
            RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(scaleDenominator, featureType);
            style.accept((StyleVisitor)visitor);
            List<RasterSymbolizer> symbolizers = visitor.getRasterSymbolizers();
            if (symbolizers.size() != 1) {
                return null;
            }
            RasterSymbolizer symbolizer = symbolizers.get(0);
            Expression transformation = visitor.getRasterRenderingTransformation();
            mapWidth = mapContent.getMapWidth();
            mapHeight = mapContent.getMapHeight();
            ReferencedEnvelope mapEnvelope = this.getEastNorthEnvelope(mapContent.getRenderingArea());
            CoordinateReferenceSystem mapCRS = mapEnvelope.getCoordinateReferenceSystem();
            mapRasterArea = new Rectangle(0, 0, mapWidth, mapHeight);
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapEnvelope, (Rectangle)mapRasterArea);
            transparent = mapContent.isTransparent() && this.isTransparencySupported();
            bgColor = mapContent.getBgColor();
            bgColor = transparent ? new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 0) : new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 255);
            final Interpolation interpolation = layerInterpolation != null ? layerInterpolation : (this.wms != null ? (WMSInfo.WMSInterpolation.Nearest.equals((Object)this.wms.getInterpolation()) ? Interpolation.getInstance((int)0) : (WMSInfo.WMSInterpolation.Bilinear.equals((Object)this.wms.getInterpolation()) ? Interpolation.getInstance((int)1) : (WMSInfo.WMSInterpolation.Bicubic.equals((Object)this.wms.getInterpolation()) ? Interpolation.getInstance((int)2) : Interpolation.getInstance((int)0)))) : Interpolation.getInstance((int)0));
            if (mapContent.getTileSize() != -1) {
                tileSizeX = tileSizeY = mapContent.getTileSize();
            } else {
                tileSizeX = mapContent.getMapWidth();
                tileSizeY = mapContent.getMapHeight();
            }
            image = null;
            GridCoverage2D coverage = null;
            RenderingHints interpolationHints = new RenderingHints(JAI.KEY_INTERPOLATION, interpolation);
            try {
                GridGeometry2D readGG;
                boolean needsGutter;
                boolean sameCRS;
                Color readerBgColor;
                Color color = readerBgColor = transparent ? null : bgColor;
                if (transformation == null && this.wms.isAdvancedProjectionHandlingEnabled()) {
                    Feature feature = ((Layer)mapContent.layers().get(0)).getFeatureSource().getFeatures().features().next();
                    GridCoverage2DReader reader = (GridCoverage2DReader)feature.getProperty("grid").getValue();
                    Object params = feature.getProperty("params").getValue();
                    GeneralParameterValue[] readParameters = RenderedImageMapOutputFormat.getReadParameters(params, null, null, interpolation, readerBgColor);
                    GridCoverageRenderer gcr = new GridCoverageRenderer(mapEnvelope.getCoordinateReferenceSystem(), (Envelope)mapEnvelope, mapRasterArea, worldToScreen, interpolationHints);
                    gcr.setAdvancedProjectionHandlingEnabled(true);
                    gcr.setWrapEnabled(this.wms.isContinuousMapWrappingEnabled());
                    image = gcr.renderImage(reader, readParameters, symbolizer, interpolation, mapContent.getBgColor(), tileSizeX, tileSizeY);
                    if (image == null) {
                        image = RenderedImageMapOutputFormat.createBkgImage(mapWidth, mapHeight, bgColor, null);
                    }
                    break block46;
                }
                CoordinateReferenceSystem coverageCRS = layer.getFeatureSource().getSchema().getCoordinateReferenceSystem();
                boolean equalsMetadata = CRS.equalsIgnoreMetadata((Object)mapCRS, (Object)coverageCRS);
                try {
                    sameCRS = equalsMetadata ? true : CRS.findMathTransform((CoordinateReferenceSystem)mapCRS, (CoordinateReferenceSystem)coverageCRS, (boolean)true).isIdentity();
                }
                catch (FactoryException e1) {
                    IOException ioe = new IOException();
                    ioe.initCause(e1);
                    throw ioe;
                }
                boolean bl = needsGutter = !sameCRS || !(interpolation instanceof InterpolationNearest);
                if (!needsGutter) {
                    readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(mapRasterArea), (org.opengis.geometry.Envelope)mapEnvelope);
                } else {
                    Rectangle bufferedTargetArea = (Rectangle)mapRasterArea.clone();
                    bufferedTargetArea.add(mapRasterArea.x + mapRasterArea.width + 10, mapRasterArea.y + mapRasterArea.height + 10);
                    bufferedTargetArea.add(mapRasterArea.x - 10, mapRasterArea.y - 10);
                    try {
                        readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(bufferedTargetArea), PixelInCell.CELL_CORNER, (MathTransform)new AffineTransform2D(worldToScreen.createInverse()), mapCRS, null);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                if (transformation != null) {
                    RenderingTransformationHelper helper = new RenderingTransformationHelper(){

                        protected GridCoverage2D readCoverage(GridCoverage2DReader reader, Object params, GridGeometry2D readGG) throws IOException {
                            return RenderedImageMapOutputFormat.readBestCoverage(reader, params, ReferencedEnvelope.reference((org.opengis.geometry.Envelope)readGG.getEnvelope()), (Rectangle)readGG.getGridRange2D(), interpolation, readerBgColor);
                        }
                    };
                    Object result = helper.applyRenderingTransformation(transformation, layer.getFeatureSource(), layer.getQuery(), Query.ALL, readGG, coverageCRS, interpolationHints);
                    if (result == null) {
                        coverage = null;
                    } else {
                        if (!(result instanceof GridCoverage2D)) return null;
                        coverage = (GridCoverage2D)result;
                    }
                } else {
                    Object params;
                    Feature feature = ((Layer)mapContent.layers().get(0)).getFeatureSource().getFeatures().features().next();
                    GridCoverage2DReader reader = (GridCoverage2DReader)feature.getProperty("grid").getValue();
                    coverage = RenderedImageMapOutputFormat.readBestCoverage(reader, params = feature.getProperty("params").getValue(), ReferencedEnvelope.reference((org.opengis.geometry.Envelope)readGG.getEnvelope()), (Rectangle)readGG.getGridRange2D(), interpolation, readerBgColor);
                    if (coverage == null) {
                        image = RenderedImageMapOutputFormat.createBkgImage(mapWidth, mapHeight, bgColor, null);
                    }
                }
                if (image == null) {
                    GridCoverageRenderer gcr = new GridCoverageRenderer(mapCRS, (Envelope)ReferencedEnvelope.reference((org.opengis.geometry.Envelope)readGG.getEnvelope()), (Rectangle)readGG.getGridRange2D(), worldToScreen, interpolationHints);
                    gcr.setAdvancedProjectionHandlingEnabled(false);
                    image = gcr.renderImage(coverage, symbolizer, interpolation, mapContent.getBgColor(), tileSizeX, tileSizeY);
                }
            }
            catch (Throwable e) {
                throw new ServiceException(e);
            }
        }
        if (image == null) {
            return null;
        }
        Rectangle imageBounds = PlanarImage.wrapRenderedImage((RenderedImage)image).getBounds();
        ImageLayout layout = new ImageLayout();
        layout.setMinX(0);
        layout.setMinY(0);
        layout.setWidth(mapWidth);
        layout.setHeight(mapHeight);
        layout.setTileGridXOffset(0);
        layout.setTileGridYOffset(0);
        layout.setTileWidth(tileSizeX);
        layout.setTileHeight(tileSizeY);
        ColorModel cm = image.getColorModel();
        double[] bgValues = null;
        PlanarImage[] alphaChannels = null;
        ImageWorker worker = new ImageWorker(image);
        int transparencyType = cm.getTransparency();
        if (cm instanceof IndexColorModel) {
            int bgColorIndex;
            IndexColorModel icm = (IndexColorModel)cm;
            if (transparent) {
                bgColorIndex = icm.getTransparentPixel();
            } else if (icm.hasAlpha() && icm.isAlphaPremultiplied()) {
                bgColorIndex = -1;
            } else {
                if (icm.getTransparency() != 1) {
                    icm = ColorUtilities.applyBackgroundColor((IndexColorModel)icm, (Color)bgColor);
                    cm = icm;
                    ImageLayout ilColorModel = new ImageLayout(image);
                    ilColorModel.setColorModel((ColorModel)icm);
                    RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, ilColorModel);
                    worker.setRenderingHints(hints);
                    worker.format(image.getSampleModel().getDataType());
                    image = worker.getRenderedImage();
                }
                bgColorIndex = ColorUtilities.findColorIndex((Color)bgColor, (IndexColorModel)icm);
            }
            if (bgColorIndex == -1) {
                image = worker.forceComponentColorModel().getRenderedImage();
                if (transparent) {
                    image = this.addAlphaChannel(image);
                    worker.setImage(image);
                }
                bgValues = new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), transparent ? 0.0 : 255.0};
                cm = image.getColorModel();
            } else {
                bgValues = new double[]{bgColorIndex};
            }
            if (cm.hasAlpha() && bgColorIndex == -1) {
                worker.forceComponentColorModel();
                RenderedImage alpha = worker.retainLastBand().getRenderedImage();
                alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
            }
        }
        if (cm instanceof ComponentColorModel) {
            RenderedImage alpha;
            ImageWorker iw;
            ComponentColorModel ccm = (ComponentColorModel)cm;
            boolean hasAlpha = cm.hasAlpha();
            if (ccm.getNumColorComponents() == 1) {
                if (!RenderedImageMapOutputFormat.isLevelOfGray(bgColor) && !transparent || ccm.getTransferType() == 5 || ccm.getTransferType() == 4 || ccm.getTransferType() == 32) {
                    iw = new ImageWorker(image);
                    if (hasAlpha) {
                        alpha = iw.retainLastBand().getRenderedImage();
                        RenderedImage gray = new ImageWorker(image).retainFirstBand().getRenderedImage();
                        image = new ImageWorker(gray).bandMerge(3).addBand(alpha, false).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
                    } else {
                        image = iw.bandMerge(3).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
                    }
                } else if (!hasAlpha) {
                    if (transparent) {
                        image = this.addAlphaChannel(image);
                        bgValues = new double[]{this.mapToGrayColor(bgColor, ccm), 0.0};
                    } else {
                        bgValues = new double[]{this.mapToGrayColor(bgColor, ccm)};
                    }
                } else {
                    iw = new ImageWorker(image);
                    alpha = iw.retainLastBand().getRenderedImage();
                    alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
                    bgValues = transparent ? new double[]{this.mapToGrayColor(bgColor, ccm), 0.0} : new double[]{this.mapToGrayColor(bgColor, ccm), 255.0};
                }
                cm = image.getColorModel();
                ccm = (ComponentColorModel)cm;
                hasAlpha = cm.hasAlpha();
            }
            if (bgValues == null) {
                if (hasAlpha) {
                    iw = new ImageWorker(image);
                    alpha = iw.retainLastBand().getRenderedImage();
                    alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
                    bgValues = transparent ? new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 0.0} : new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 255.0};
                } else if (transparent) {
                    image = this.addAlphaChannel(image);
                    bgValues = new double[]{0.0, 0.0, 0.0, 0.0};
                } else {
                    bgValues = new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()};
                }
            }
        }
        if (!imageBounds.contains(mapRasterArea) && !imageBounds.equals(mapRasterArea) || transparencyType != 1) {
            ROI[] rois = new ROI[]{new ROIShape((Shape)imageBounds)};
            double[][] thresholds = new double[][]{{ColorUtilities.getThreshold((int)image.getSampleModel().getDataType())}};
            ImageWorker w = new ImageWorker(image);
            w.setRenderingHint(JAI.KEY_IMAGE_LAYOUT, (Object)layout);
            w.setBackground(bgValues);
            w.mosaic(new RenderedImage[]{image}, alphaChannels != null && transparencyType == 3 ? MosaicDescriptor.MOSAIC_TYPE_BLEND : MosaicDescriptor.MOSAIC_TYPE_OVERLAY, alphaChannels, rois, (double[][])thresholds, null);
            return w.getRenderedImage();
        }
        if (!imageBounds.contains(mapRasterArea)) return image;
        if (imageBounds.equals(mapRasterArea)) return image;
        ImageWorker iw = new ImageWorker(image);
        iw.setBackground(bgValues);
        iw.crop(0.0f, 0.0f, (float)mapWidth, (float)mapHeight);
        return iw.getRenderedImage();
    }

    private ReferencedEnvelope getEastNorthEnvelope(ReferencedEnvelope envelope) throws FactoryException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        if (CRS.getAxisOrder((CoordinateReferenceSystem)crs) != CRS.AxisOrder.NORTH_EAST) {
            return envelope;
        }
        Integer epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
        if (epsg == null) {
            return envelope;
        }
        CoordinateReferenceSystem eastNorthCrs = CRS.decode((String)("EPSG:" + epsg), (boolean)true);
        return new ReferencedEnvelope(envelope.getMinY(), envelope.getMaxY(), envelope.getMinX(), envelope.getMaxX(), eastNorthCrs);
    }

    private RenderedImage addAlphaChannel(RenderedImage image) {
        ImageLayout tempLayout = new ImageLayout(image);
        tempLayout.unsetValid(512).unsetValid(256);
        RenderedOp alpha = ConstantDescriptor.create((Float)Float.valueOf(image.getWidth()), (Float)Float.valueOf(image.getHeight()), (Number[])new Byte[]{(byte)-1}, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, tempLayout));
        ImageWorker iw = new ImageWorker(image);
        iw.addBand((RenderedImage)alpha, false, true, null);
        return iw.getRenderedImage();
    }

    double mapToGrayColor(Color gray, ComponentColorModel cm) {
        double[] rescaleFactors = new double[33];
        rescaleFactors[0] = 1.0;
        rescaleFactors[2] = 255.0;
        rescaleFactors[3] = 8421504.0;
        rescaleFactors[1] = 512.0;
        rescaleFactors[5] = 0.00392156862745098;
        rescaleFactors[4] = 0.00392156862745098;
        rescaleFactors[32] = 1.0;
        return (double)gray.getRed() / rescaleFactors[cm.getTransferType()];
    }

    private static boolean isLevelOfGray(Color color) {
        return color.getRed() == color.getBlue() && color.getRed() == color.getGreen();
    }

    private static final RenderedImage createBkgImage(float width, float height, Color bgColor, RenderingHints renderingHints) {
        Number[] bands = new Byte[]{(byte)bgColor.getRed(), (byte)bgColor.getGreen(), (byte)bgColor.getBlue(), (byte)bgColor.getAlpha()};
        return ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])bands, (RenderingHints)renderingHints);
    }

    private static GridCoverage2D readBestCoverage(GridCoverage2DReader reader, Object params, ReferencedEnvelope envelope, Rectangle requestedRasterArea, Interpolation interpolation, Color bgColor) throws IOException {
        try {
            ReferencedEnvelope requestEnvelopeWGS84;
            ReferencedEnvelope dataEnvelopeWGS84;
            CoordinateReferenceSystem coverageCRS = reader.getCoordinateReferenceSystem();
            CoordinateReferenceSystem requestCRS = envelope.getCoordinateReferenceSystem();
            ReferencedEnvelope coverageEnvelope = new ReferencedEnvelope((org.opengis.geometry.Envelope)reader.getOriginalEnvelope());
            if (CRS.equalsIgnoreMetadata((Object)coverageCRS, (Object)requestCRS) ? !coverageEnvelope.intersects((BoundingBox)envelope) : !(dataEnvelopeWGS84 = coverageEnvelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true)).intersects((BoundingBox)(requestEnvelopeWGS84 = envelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true)))) {
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to compare data and request envelopes, proceeding with rendering anyways", e);
        }
        GeneralParameterValue[] readParams = RenderedImageMapOutputFormat.getReadParameters(params, envelope, requestedRasterArea, interpolation, bgColor);
        GridCoverage2D coverage = reader.read(readParams);
        return coverage;
    }

    private static GeneralParameterValue[] getReadParameters(Object params, ReferencedEnvelope envelope, Rectangle requestedRasterArea, Interpolation interpolation, Color bgColor) {
        int length;
        Parameter bgColorParam;
        Parameter readGG = null;
        if (envelope != null) {
            readGG = (Parameter)AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            readGG.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(requestedRasterArea), (org.opengis.geometry.Envelope)envelope));
        }
        Parameter readInterpolation = (Parameter)ImageMosaicFormat.INTERPOLATION.createValue();
        readInterpolation.setValue((Object)interpolation);
        if (bgColor != null) {
            bgColorParam = (Parameter)AbstractGridFormat.BACKGROUND_COLOR.createValue();
            bgColorParam.setValue((Object)bgColor);
        } else {
            bgColorParam = null;
        }
        GeneralParameterValue[] readParams = (GeneralParameterValue[])params;
        int n = length = readParams == null ? 0 : readParams.length;
        if (length > 0) {
            String readGGName = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
            String readInterpolationName = ImageMosaicFormat.INTERPOLATION.getName().toString();
            String bgColorName = AbstractGridFormat.BACKGROUND_COLOR.getName().toString();
            boolean foundInterpolation = false;
            boolean foundGG = false;
            boolean foundBgColor = false;
            for (int i = 0; i < length; ++i) {
                String paramName = readParams[i].getDescriptor().getName().toString();
                if (paramName.equalsIgnoreCase(readGGName) && readGG != null) {
                    ((Parameter)readParams[i]).setValue((Object)readGG);
                    foundGG = true;
                    continue;
                }
                if (paramName.equalsIgnoreCase(readInterpolationName)) {
                    ((Parameter)readParams[i]).setValue((Object)interpolation);
                    foundInterpolation = true;
                    continue;
                }
                if (!paramName.equalsIgnoreCase(bgColorName) || bgColor == null) continue;
                ((Parameter)readParams[i]).setValue((Object)bgColor);
                foundBgColor = true;
            }
            if (!(foundGG && foundInterpolation && foundBgColor && bgColor != null)) {
                ArrayList<Object> paramList = new ArrayList<Object>();
                paramList.addAll(Arrays.asList(readParams));
                if (!foundGG && readGG != null) {
                    paramList.add(readGG);
                }
                if (!foundInterpolation) {
                    paramList.add(readInterpolation);
                }
                if (!foundBgColor && bgColor != null) {
                    paramList.add(bgColorParam);
                }
                readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
            }
        } else {
            ArrayList<Parameter> paramList = new ArrayList<Parameter>();
            if (readGG != null) {
                paramList.add(readGG);
            }
            if (bgColor != null) {
                paramList.add(bgColorParam);
            }
            paramList.add(readInterpolation);
            readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
        }
        return readParams;
    }
}

