/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geotools.image.ImageWorker;
import org.geotools.image.palette.CustomPaletteBuilder;
import org.geotools.image.palette.InverseColorMapOp;
import org.geotools.util.logging.Logging;

public class ImageUtils {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map");
    private static boolean DEBUG = Boolean.valueOf(GeoServerExtensions.getProperty((String)"org.geoserver.wms.map.ImageUtils.debug"));
    private static String DEBUG_DIR;

    private ImageUtils() {
    }

    public static BufferedImage createImage(int width, int height, IndexColorModel palette, boolean transparent) {
        if (palette != null) {
            WritableRaster raster = Raster.createInterleavedRaster(palette.getTransferType(), width, height, 1, null);
            return new BufferedImage(palette, raster, false, null);
        }
        if (transparent) {
            return new BufferedImage(width, height, 6);
        }
        return new BufferedImage(width, height, 5);
    }

    public static long getDrawingSurfaceMemoryUse(int width, int height, IndexColorModel palette, boolean transparent) {
        long memory = width * height;
        if (palette != null) {
            return memory;
        }
        if (transparent) {
            return memory * 4L;
        }
        return memory * 3L;
    }

    public static Graphics2D prepareTransparency(boolean transparent, Color bgColor, RenderedImage preparedImage, Map<RenderingHints.Key, Object> extraHints) {
        Graphics2D graphic;
        if (preparedImage instanceof BufferedImage) {
            graphic = ((BufferedImage)preparedImage).createGraphics();
        } else if (preparedImage instanceof TiledImage) {
            graphic = ((TiledImage)preparedImage).createGraphics();
        } else if (preparedImage instanceof VolatileImage) {
            graphic = ((VolatileImage)((Object)preparedImage)).createGraphics();
        } else {
            throw new ServiceException("Unrecognized back-end image type");
        }
        HashMap<Object, Object> hintsMap = extraHints == null ? new HashMap() : new HashMap<RenderingHints.Key, Object>(extraHints);
        hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphic.setRenderingHints(hintsMap);
        if (transparent) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("setting to transparent");
            }
            int type = 2;
            graphic.setComposite(AlphaComposite.getInstance(type));
            Color c = new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 0);
            graphic.setBackground(bgColor);
            graphic.setColor(c);
            graphic.fillRect(0, 0, preparedImage.getWidth(), preparedImage.getHeight());
            type = 3;
            graphic.setComposite(AlphaComposite.getInstance(type));
        } else {
            graphic.setColor(bgColor);
            graphic.fillRect(0, 0, preparedImage.getWidth(), preparedImage.getHeight());
        }
        return graphic;
    }

    public static RenderedImage forceIndexed8Bitmask(RenderedImage originalImage, InverseColorMapOp invColorMap) {
        RenderedImage image;
        boolean dataTypeByte;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Method forceIndexed8Bitmask called ");
            LOGGER.finer("invColorMap is null? " + (invColorMap == null));
            String type = "RI";
            if (originalImage instanceof PlanarImage) {
                type = "PI";
            } else if (originalImage instanceof BufferedImage) {
                type = "BI";
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("OriginalImage type " + type);
                LOGGER.finer("OriginalImage info: " + originalImage.toString());
            }
        }
        ColorModel cm = originalImage.getColorModel();
        boolean bl = dataTypeByte = originalImage.getSampleModel().getDataType() == 0;
        if (cm instanceof IndexColorModel && dataTypeByte) {
            IndexColorModel icm;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Image has IndexColorModel and type byte!");
            }
            if ((icm = (IndexColorModel)cm).getTransparency() != 3) {
                image = originalImage;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Image has Transparency  != TRANSLUCENT, do nothing");
                }
            } else {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Image has Transparency TRANSLUCENT, forceBitmaskIndexColorModel");
                }
                image = new ImageWorker(originalImage).forceBitmaskIndexColorModel().getRenderedImage();
                if (DEBUG) {
                    ImageUtils.writeRenderedImage(image, "indexed8translucent");
                }
            }
        } else {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Image has generic color model and/or type");
            }
            image = new ImageWorker(originalImage).rescaleToBytes().getRenderedImage();
            if (invColorMap != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("We have an invColorMap");
                }
                image = invColorMap.filterRenderedImage(image);
                if (DEBUG) {
                    ImageUtils.writeRenderedImage(image, "invColorMap");
                }
            } else {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("We do not have an invColorMap");
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Making sure we start from a componentcolormodel");
                }
                image = new ImageWorker(image).forceComponentColorModel().getRenderedImage();
                if (DEBUG) {
                    ImageUtils.writeRenderedImage(image, "forceComponentColorModel");
                }
                int subsx = 1 + (int)(Math.log(image.getWidth()) / Math.log(32.0));
                int subsy = 1 + (int)(Math.log(image.getHeight()) / Math.log(32.0));
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("CustomPaletteBuilder[subsx=" + subsx + ",subsy=" + subsy + "]");
                    LOGGER.finer("InputImage is:" + image.toString());
                }
                CustomPaletteBuilder cpb = new CustomPaletteBuilder(image, 256, subsx, subsy, 1).buildPalette();
                image = cpb.getIndexedImage();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Computed Palette:" + ImageUtils.paletteRepresentation(cpb.getIndexColorModel()));
                }
                if (DEBUG) {
                    ImageUtils.writeRenderedImage(image, "buildPalette");
                }
            }
        }
        return image;
    }

    private static String paletteRepresentation(IndexColorModel indexColorModel) {
        StringBuilder builder = new StringBuilder();
        int mapSize = indexColorModel.getMapSize();
        builder.append("PaletteSize:").append(mapSize).append("\n");
        builder.append("Transparency:").append(indexColorModel.getTransparency()).append("\n");
        builder.append("TransparentPixel:").append(indexColorModel.getTransparentPixel()).append("\n");
        for (int i = 0; i < mapSize; ++i) {
            builder.append("[r=").append(indexColorModel.getRed(i)).append(",");
            builder.append("[g=").append(indexColorModel.getGreen(i)).append(",");
            builder.append("[b=").append(indexColorModel.getBlue(i)).append("]\n");
        }
        return builder.toString();
    }

    static void writeRenderedImage(RenderedImage raster, String fileName) {
        if (DEBUG_DIR == null) {
            throw new NullPointerException("Unable to write the provided coverage in the debug directory");
        }
        if (!DEBUG) {
            throw new IllegalStateException("Unable to write the provided coverage since we are not in debug mode");
        }
        try {
            ImageIO.write(raster, "tiff", new File(DEBUG_DIR, fileName + ".tiff"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    static {
        if (DEBUG) {
            File tempDir = new File(GeoServerExtensions.getProperty((String)"user.home"), ".geoserver");
            if (!tempDir.exists()) {
                if (!tempDir.mkdir()) {
                    System.out.println("Unable to create debug dir, exiting application!!!");
                }
                DEBUG = false;
                DEBUG_DIR = null;
            } else {
                DEBUG_DIR = tempDir.getAbsolutePath();
                System.out.println("MetatileMapOutputFormat debug dir " + DEBUG_DIR);
            }
        }
    }
}

