/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.PlanarImage;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.io.ImageIOExt;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;

public class GeoTIFFMapResponse
extends RenderedImageMapResponse {
    private static final Logger LOGGER = Logging.getLogger(GeoTIFFMapResponse.class);
    private static final String IMAGE_GEOTIFF = "image/geotiff";
    private static final String IMAGE_GEOTIFF8 = "image/geotiff8";
    private static final String[] OUTPUT_FORMATS = new String[]{"image/geotiff", "image/geotiff8"};
    private static final GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(true, false, true, true, null);

    public GeoTIFFMapResponse(WMS wms) {
        super(OUTPUT_FORMATS, wms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatImageOutputStream(RenderedImage image, OutputStream outStream, WMSMapContent mapContent) throws ServiceException, IOException {
        ImageOutputStream imageOutStream;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image ...");
        }
        image = this.applyPalette(image, mapContent, IMAGE_GEOTIFF8, false);
        GridCoverage2D gc = factory.create((CharSequence)"geotiff", image, (Envelope)new GeneralEnvelope((Envelope)mapContent.getRenderingArea()));
        if (image instanceof PlanarImage) {
            Object property;
            HashMap properties = gc.getProperties();
            if (properties == null) {
                properties = new HashMap();
            }
            if ((property = ((PlanarImage)image).getProperty("GC_NODATA")) != null) {
                CoverageUtilities.setNoDataProperty(properties, (Object)property);
                gc = factory.create((CharSequence)gc.getName(), gc.getRenderedImage(), gc.getEnvelope(), gc.getSampleDimensions(), null, properties);
            }
        }
        if ((imageOutStream = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)outStream)) == null) {
            throw new ServiceException("Unable to create ImageOutputStream.");
        }
        GeoTiffWriter writer = null;
        try {
            writer = new GeoTiffWriter((Object)imageOutStream);
            writer.write((GridCoverage)gc, null);
        }
        finally {
            block20: {
                block19: {
                    try {
                        imageOutStream.close();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block19;
                        LOGGER.log(Level.FINEST, "Unable to properly close output stream", e);
                    }
                }
                try {
                    if (writer != null) {
                        writer.dispose();
                    }
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block20;
                    LOGGER.log(Level.FINEST, "Unable to properly dispose writer", e);
                }
            }
            RasterCleaner.addCoverage(gc);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image done!");
        }
    }

    @Override
    public MapProducerCapabilities getCapabilities(String outputFormat) {
        return CAPABILITIES;
    }
}

