/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.sun.media.imageioimpl.plugins.gif.GIFImageWriter;
import com.sun.media.imageioimpl.plugins.gif.GIFImageWriterSpi;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedImageList;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.image.ImageWorker;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;

public final class GIFMapResponse
extends RenderedImageMapResponse {
    private static final String GIF_FRAMES_DELAY = "gif_frames_delay";
    private static final String GIF_LOOP_CONTINUOSLY = "gif_loop_continuosly";
    private static final String GIF_LOOP_CONTINUOUSLY = "gif_loop_continuously";
    private static final Logger LOGGER = Logging.getLogger(GIFMapResponse.class);
    public static final String IMAGE_GIF_SUBTYPE_ANIMATED = "image/gif;subtype=animated";
    private static final GIFImageWriterSpi ORIGINATING_PROVIDER = new GIFImageWriterSpi();
    static final String MIME_TYPE = "image/gif";
    static final String[] OUTPUT_FORMATS = new String[]{"image/gif", "image/gif;subtype=animated"};
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(true, false, true, true, "image/gif");
    private static MapProducerCapabilities CAPABILITIES_ANIM = new MapProducerCapabilities(true, true, true, true, "image/gif");

    public GIFMapResponse(WMS wms) {
        super(OUTPUT_FORMATS, wms);
    }

    @Override
    public void formatImageOutputStream(RenderedImage originalImage, OutputStream outStream, WMSMapContent mapContent) throws ServiceException, IOException {
        RenderedImageList ril;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing gif image ...");
        }
        String format = mapContent.getRequest().getFormat();
        boolean animatedGIF = false;
        if (format.equalsIgnoreCase(IMAGE_GIF_SUBTYPE_ANIMATED)) {
            animatedGIF = true;
        }
        int numfiles = 1;
        if (originalImage instanceof RenderedImageList) {
            ril = (RenderedImageList)originalImage;
            numfiles = ril.size();
        } else {
            ril = new RenderedImageList(Arrays.asList(originalImage));
        }
        if (numfiles == 1 || !animatedGIF) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Preparing to write a gif...");
            }
            try {
                originalImage = this.applyPalette(originalImage, mapContent, MIME_TYPE, false);
                ImageWorker iw = new ImageWorker(originalImage);
                iw.writeGIF((Object)outStream, "LZW", 0.75f);
                RasterCleaner.addImage(iw.getRenderedImage());
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            return;
        }
        if (numfiles <= 0) {
            throw new ServiceException("The number of frames for this GIF is less than 1");
        }
        GIFImageWriter gifWriter = new GIFImageWriter(ORIGINATING_PROVIDER);
        ImageWriteParam param = gifWriter.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType("LZW");
        param.setCompressionQuality(0.75f);
        ImageOutputStream otStream = null;
        ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
        try {
            Integer delay;
            otStream = ImageIO.createImageOutputStream(outStream);
            gifWriter.setOutput((Object)otStream);
            gifWriter.prepareWriteSequence(null);
            GetMapRequest request = mapContent.getRequest();
            Object loopContinuouslyString = request.getFormatOptions().get(GIF_LOOP_CONTINUOUSLY);
            if (loopContinuouslyString == null) {
                loopContinuouslyString = request.getFormatOptions().get(GIF_LOOP_CONTINUOSLY);
            }
            Boolean loopContinuosly = loopContinuouslyString != null ? Boolean.valueOf((String)loopContinuouslyString) : this.wms.getLoopContinuously();
            Object frameDelayString = request.getFormatOptions().get(GIF_FRAMES_DELAY);
            Integer n = delay = frameDelayString != null ? Integer.valueOf((String)frameDelayString) : this.wms.getFramesDelay();
            if (delay <= 0) {
                throw new ServiceException("Animate GIF delay invalid: " + delay);
            }
            for (int i = 0; i < numfiles; ++i) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Writing image " + i);
                }
                RenderedImage ri = (RenderedImage)ril.get(i);
                if ((ri = this.applyPalette(ri, mapContent, MIME_TYPE, false)) == null) continue;
                IIOMetadata imageMetadata = gifWriter.getDefaultImageMetadata(new ImageTypeSpecifier(ri), param);
                GIFMapResponse.prepareMetadata(ri, imageMetadata, loopContinuosly, delay);
                gifWriter.writeToSequence(new IIOImage(ri, null, imageMetadata), param);
                images.add(ri);
            }
            gifWriter.endWriteSequence();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            try {
                otStream.flush();
            }
            catch (Exception e) {}
            try {
                otStream.close();
            }
            catch (Exception e) {}
            try {
                gifWriter.dispose();
            }
            catch (Exception e) {}
            for (RenderedImage image : images) {
                if (image instanceof PlanarImage) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)image));
                    continue;
                }
                if (!(image instanceof BufferedImage)) continue;
                ((BufferedImage)image).flush();
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Done writing animated gif");
        }
    }

    public String getContentDisposition() {
        return null;
    }

    private static void prepareMetadata(RenderedImage ri, IIOMetadata imageMetadata, boolean loopContinuously, int timeBetweenFramesMS) throws IOException {
        String metaFormatName = imageMetadata.getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)imageMetadata.getAsTree(metaFormatName);
        IIOMetadataNode graphicsControlExtensionNode = GIFMapResponse.getNode(root, "GraphicControlExtension");
        graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
        graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("delayTime", Integer.toString(timeBetweenFramesMS / 10));
        IndexColorModel icm = (IndexColorModel)ri.getColorModel();
        int transparentColorIndex = -1;
        if (icm.getTransparency() == 2 && (transparentColorIndex = icm.getTransparentPixel()) >= 0) {
            graphicsControlExtensionNode.setAttribute("transparentColorIndex", String.valueOf(transparentColorIndex));
            graphicsControlExtensionNode.setAttribute("transparentColorFlag", "TRUE");
        } else {
            graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
            graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
        }
        IIOMetadataNode commentsNode = GIFMapResponse.getNode(root, "CommentExtensions");
        commentsNode.setAttribute("CommentExtension", "Created by MAH");
        IIOMetadataNode appEntensionsNode = GIFMapResponse.getNode(root, "ApplicationExtensions");
        IIOMetadataNode child = new IIOMetadataNode("ApplicationExtension");
        child.setAttribute("applicationID", "NETSCAPE");
        child.setAttribute("authenticationCode", "2.0");
        int loop = loopContinuously ? 0 : 1;
        byte[] userObject = new byte[]{1, (byte)(loop & 0xFF), (byte)(loop >> 8 & 0xFF)};
        child.setUserObject(userObject);
        appEntensionsNode.appendChild(child);
        imageMetadata.setFromTree(metaFormatName, root);
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }

    @Override
    public MapProducerCapabilities getCapabilities(String outputFormat) {
        if (IMAGE_GIF_SUBTYPE_ANIMATED.equals(outputFormat)) {
            return CAPABILITIES_ANIM;
        }
        return CAPABILITIES;
    }
}

