/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.wms.GetMapOutputFormat;
import org.springframework.util.Assert;

public abstract class AbstractMapOutputFormat
implements GetMapOutputFormat {
    private final String mime;
    private final Set<String> outputFormatNames;

    protected AbstractMapOutputFormat(String mime) {
        this(mime, new String[]{mime});
    }

    protected AbstractMapOutputFormat(String mime, String[] outputFormats) {
        this(mime, (Set<String>)(outputFormats == null ? Collections.EMPTY_SET : new HashSet<String>(Arrays.asList(outputFormats))));
    }

    protected AbstractMapOutputFormat(String mime, Set<String> outputFormats) {
        Assert.notNull((Object)mime);
        this.mime = mime;
        if (outputFormats == null) {
            outputFormats = Collections.emptySet();
        }
        Set<String> formats = AbstractMapOutputFormat.caseInsensitiveOutputFormats(outputFormats);
        formats.add(mime);
        this.outputFormatNames = Collections.unmodifiableSet(formats);
    }

    private static Set<String> caseInsensitiveOutputFormats(Set<String> outputFormats) {
        TreeSet<String> caseInsensitiveFormats = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveFormats.addAll(outputFormats);
        return caseInsensitiveFormats;
    }

    protected AbstractMapOutputFormat() {
        this(null, (String[])null);
    }

    @Override
    public String getMimeType() {
        return this.mime;
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return this.outputFormatNames;
    }
}

