/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.SchemaException;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.ProgressListener;

public class GetLegendGraphicKvpReader
extends KvpRequestReader {
    private static final Logger LOGGER = Logging.getLogger(GetLegendGraphicKvpReader.class);
    private static final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    private WMS wms;

    public GetLegendGraphicKvpReader(WMS wms) {
        super(GetLegendGraphicRequest.class);
        this.wms = wms;
    }

    public GetLegendGraphicRequest read(Object req, Map kvp, Map rawKvp) throws Exception {
        String language;
        GetLegendGraphicRequest request = (GetLegendGraphicRequest)super.read(req, kvp, rawKvp);
        request.setRawKvp(rawKvp);
        if (request.getVersion() == null || request.getVersion().length() == 0) {
            String version = (String)rawKvp.get("WMTVER");
            if (version == null) {
                version = this.wms.getVersion();
            }
            request.setVersion(version);
        }
        if ((language = (String)rawKvp.get("LANGUAGE")) != null) {
            request.setLocale(new Locale(language));
        }
        String layer = (String)rawKvp.get("LAYER");
        boolean strict = rawKvp.containsKey("STRICT") ? Boolean.valueOf((String)rawKvp.get("STRICT")).booleanValue() : request.isStrict();
        request.setStrict(strict);
        if (strict && layer == null) {
            throw new ServiceException("LAYER parameter not present for GetLegendGraphic", "LayerNotDefined");
        }
        if (strict && request.getFormat() == null) {
            throw new ServiceException("Missing FORMAT parameter for GetLegendGraphic", "MissingFormat");
        }
        LayerInfo infoObject = null;
        ArrayList<FeatureType> layers = new ArrayList<FeatureType>();
        if (layer != null) {
            try {
                LayerInfo layerInfo = this.wms.getLayerByName(layer);
                if (layerInfo != null) {
                    this.addLayer(layers, layerInfo, request);
                    infoObject = layerInfo;
                } else {
                    LayerGroupInfo layerGroupInfo = this.wms.getLayerGroupByName(layer);
                    if (layerGroupInfo != null) {
                        for (LayerInfo singleLayer : layerGroupInfo.layers()) {
                            this.addLayer(layers, singleLayer, request);
                        }
                        infoObject = layerGroupInfo;
                    } else {
                        throw new ServiceException(layer + " layer does not exist.");
                    }
                }
                request.setLayers(layers);
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (NoSuchElementException ne) {
                throw new ServiceException(new StringBuffer(layer).append(" layer does not exists.").toString(), (Throwable)ne);
            }
            catch (Exception te) {
                throw new ServiceException("Can't obtain the schema for the required layer.", (Throwable)te);
            }
        } else {
            layers.add(null);
            request.setLayers(layers);
        }
        if (request.getFormat() == null) {
            request.setFormat("image/png");
        }
        if (null == this.wms.getLegendGraphicOutputFormat(request.getFormat())) {
            throw new ServiceException(new StringBuffer("Invalid graphic format: ").append(request.getFormat()).toString(), "InvalidFormat");
        }
        try {
            String msg;
            this.parseOptionalParameters(request, infoObject, rawKvp);
            if (layers.size() != request.getStyles().size()) {
                msg = layers.size() + " layers requested, but found " + request.getStyles().size() + " styles specified. ";
                throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
            }
            if (request.getRules().size() > 0 && layers.size() != request.getRules().size()) {
                msg = layers.size() + " layers requested, but found " + request.getRules().size() + " rules specified. ";
                throw new ServiceException(msg, ((Object)((Object)this)).getClass().getName());
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return request;
    }

    private void addLayer(List<FeatureType> layers, LayerInfo layerInfo, GetLegendGraphicRequest req) throws FactoryRegistryException, IOException, TransformException, SchemaException {
        FeatureType featureType = this.getLayerFeatureType(layerInfo);
        if (featureType != null) {
            MapLayerInfo mli = new MapLayerInfo(layerInfo);
            if (mli.getLabel() != null) {
                req.setTitle(featureType.getName(), mli.getLabel());
            }
        } else {
            throw new ServiceException("Cannot get FeatureType for Layer", "MissingFeatureType");
        }
        layers.add(featureType);
    }

    private FeatureType getLayerFeatureType(LayerInfo layerInfo) throws IOException, FactoryRegistryException, TransformException, SchemaException {
        MapLayerInfo mli = new MapLayerInfo(layerInfo);
        if (layerInfo.getType() == PublishedType.VECTOR) {
            FeatureType featureType = mli.getFeature().getFeatureType();
            return featureType;
        }
        if (layerInfo.getType() == PublishedType.RASTER) {
            CoverageInfo coverageInfo = mli.getCoverage();
            GridCoverage2DReader reader = (GridCoverage2DReader)coverageInfo.getGridCoverageReader((ProgressListener)new NullProgressListener(), GeoTools.getDefaultHints());
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverageReader((GridCoverage2DReader)reader, null);
            return feature.getSchema();
        }
        return null;
    }

    private void parseOptionalParameters(GetLegendGraphicRequest req, Object infoObj, Map rawKvp) throws IOException {
        this.parseStyleAndRule(req, infoObj, rawKvp);
    }

    private void parseStyleAndRule(GetLegendGraphicRequest req, Object infoObj, Map rawKvp) throws IOException {
        String listOfStyles = (String)rawKvp.get("STYLE");
        if (listOfStyles == null) {
            listOfStyles = "";
        }
        List styleNames = KvpUtils.readFlat((String)listOfStyles);
        String sldUrl = (String)rawKvp.get("SLD");
        String sldBody = (String)rawKvp.get("SLD_BODY");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("looking for styles ").append(listOfStyles).toString());
        }
        ArrayList<Style> sldStyles = new ArrayList<Style>();
        if (sldUrl != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD parameter");
            }
            this.addStylesFrom(sldStyles, styleNames, this.loadRemoteStyle(sldUrl));
        } else if (sldBody != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD_BODY parameter");
            }
            this.addStylesFrom(sldStyles, styleNames, this.parseSldBody(sldBody));
        } else if (styleNames.size() > 0) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from STYLE parameter");
            }
            int pos = 0;
            for (String styleName : styleNames) {
                if (styleName.equals("") && infoObj instanceof LayerGroupInfo) {
                    LayerGroupInfo layerGroupInfo = (LayerGroupInfo)infoObj;
                    List groupLayers = layerGroupInfo.layers();
                    if (pos < groupLayers.size()) {
                        sldStyles.add(this.getStyleFromLayer((LayerInfo)groupLayers.get(pos)));
                    }
                } else {
                    sldStyles.add(this.wms.getStyleByName(styleName));
                }
                ++pos;
            }
        } else if (infoObj instanceof LayerInfo) {
            sldStyles.add(this.getStyleFromLayer((LayerInfo)infoObj));
        } else if (infoObj instanceof LayerGroupInfo) {
            LayerGroupInfo layerGroupInfo = (LayerGroupInfo)infoObj;
            List groupLayers = layerGroupInfo.layers();
            List groupStyles = layerGroupInfo.styles();
            for (int count = 0; count < groupLayers.size(); ++count) {
                if (count < groupStyles.size() && groupStyles.get(count) != null) {
                    sldStyles.add(((StyleInfo)groupStyles.get(count)).getStyle());
                    continue;
                }
                LayerInfo layerInfo = (LayerInfo)groupLayers.get(count);
                sldStyles.add(this.getStyleFromLayer(layerInfo));
            }
        }
        req.setStyles(sldStyles);
        String rule = (String)rawKvp.get("RULE");
        if (rule != null) {
            List ruleNames = KvpUtils.readFlat((String)rule);
            req.setRules(ruleNames);
        }
    }

    private Style getStyleFromLayer(LayerInfo layerInfo) {
        MapLayerInfo mli = new MapLayerInfo(layerInfo);
        return mli.getDefaultStyle();
    }

    private void addStylesFrom(List<Style> sldStyles, List<String> styleNames, Style[] source) {
        if (styleNames.size() == 0) {
            sldStyles.add(this.findStyle(null, source));
        } else {
            for (String styleName : styleNames) {
                sldStyles.add(this.findStyle(styleName, source));
            }
        }
    }

    private Style findStyle(String styleName, Style[] styles) throws NoSuchElementException {
        if (styles == null || styles.length == 0) {
            throw new NoSuchElementException("No styles have been provided to search for " + styleName);
        }
        if (styleName == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("styleName is null, request in literal mode, returning first style");
            }
            return styles[0];
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("request in library mode, looking for style ").append(styleName).toString());
        }
        StringBuffer noMatchNames = new StringBuffer();
        for (int i = 0; i < styles.length; ++i) {
            if (styles[i] != null && styleName.equals(styles[i].getName())) {
                return styles[i];
            }
            noMatchNames.append(styles[i].getName());
            if (i >= styles.length) continue;
            noMatchNames.append(", ");
        }
        throw new NoSuchElementException(styleName + " not found. Provided style names: " + noMatchNames);
    }

    private Style[] loadRemoteStyle(String sldUrl) throws ServiceException {
        InputStream in;
        try {
            URL url = new URL(sldUrl);
            in = url.openStream();
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e, "Not a valid URL to an SLD document " + sldUrl, "loadRemoteStyle");
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e, "Can't open the SLD URL " + sldUrl, "loadRemoteStyle");
        }
        return this.parseSld(new InputStreamReader(in));
    }

    private Style[] parseSldBody(String sldBody) throws ServiceException {
        return this.parseSld(new StringReader(sldBody));
    }

    private Style[] parseSld(Reader xmlIn) throws ServiceException {
        SLDParser parser = new SLDParser(styleFactory, xmlIn);
        Style[] styles = null;
        try {
            styles = parser.readXML();
        }
        catch (RuntimeException e) {
            throw new ServiceException((Throwable)e);
        }
        if (styles == null || styles.length == 0) {
            throw new ServiceException("Document contains no styles");
        }
        return styles;
    }
}

