/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geotools.styling.ColorMapEntry;

public abstract class Cell {
    protected final Color bkgColor;
    protected final double bkgOpacity;
    protected final String text;
    protected final LegendUtils.HAlign hAlign;
    protected final LegendUtils.VAlign vAlign;
    protected final Dimension requestedDimension;
    protected final Font labelFont;
    protected final Color labelFontColor;
    protected final boolean fontAntiAliasing;
    protected final Color borderColor;

    protected Cell(Color bkgColor, double bkgOpacity, String text, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAlign, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor) {
        this.bkgColor = bkgColor;
        this.bkgOpacity = bkgOpacity;
        this.text = text;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
        this.requestedDimension = requestedDimension;
        this.labelFont = labelFont;
        this.labelFontColor = labelFontColor;
        this.fontAntiAliasing = fontAntiAliasing;
        this.borderColor = borderColor;
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, boolean var3);

    public abstract Dimension getPreferredDimension(Graphics2D var1);

    public static abstract class ColorManager
    extends Cell {
        public ColorManager(Color color, double opacity, Dimension requestedDimension, Color borderColor) {
            super(color, opacity, null, null, null, requestedDimension, null, null, false, borderColor);
        }

        @Override
        public abstract void draw(Graphics2D var1, Rectangle2D var2, boolean var3);

        @Override
        public Dimension getPreferredDimension(Graphics2D graphics) {
            return new Dimension(this.requestedDimension);
        }

        public static class SimpleColorManager
        extends ColorManager {
            public SimpleColorManager(Color color, double opacity, Dimension requestedDimension, Color borderColor) {
                super(color, opacity, requestedDimension, borderColor);
            }

            @Override
            public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
                if (this.bkgOpacity > 0.0) {
                    Color oldColor = graphics.getColor();
                    Color newColor = new Color(this.bkgColor.getRed(), this.bkgColor.getGreen(), this.bkgColor.getBlue(), (int)(255.0 * this.bkgOpacity + 0.5));
                    graphics.setColor(newColor);
                    graphics.fill(clipBox);
                    graphics.setColor(this.borderColor);
                    if (completeBorder) {
                        int minx = (int)(clipBox.getMinX() + 0.5);
                        int miny = (int)(clipBox.getMinY() + 0.5);
                        int w = (int)(clipBox.getWidth() + 0.5) - 1;
                        int h = (int)(clipBox.getHeight() + 0.5) - 1;
                        graphics.draw(new Rectangle2D.Double(minx, miny, w, h));
                    }
                    graphics.setColor(oldColor);
                } else {
                    Color oldColor = graphics.getColor();
                    graphics.setColor(Color.white);
                    graphics.fill(clipBox);
                    graphics.setColor(Color.RED);
                    int minx = (int)(clipBox.getMinX() + 0.5);
                    int miny = (int)(clipBox.getMinY() + 0.5);
                    int maxx = (int)((double)minx + clipBox.getWidth() - 1.0 + 0.5);
                    int maxy = (int)((double)miny + clipBox.getHeight() - 1.0 + 0.5);
                    graphics.drawLine(minx, miny, maxx, maxy);
                    graphics.drawLine(minx, maxy, maxx, miny);
                    graphics.setColor(this.borderColor);
                    if (completeBorder) {
                        int w = (int)(clipBox.getWidth() + 0.5) - 1;
                        int h = (int)(clipBox.getHeight() + 0.5) - 1;
                        graphics.draw(new Rectangle2D.Double(minx, miny, w, h));
                    }
                    graphics.setColor(oldColor);
                }
            }

            public static class GradientColorManager
            extends SimpleColorManager {
                private Color previousColor = null;
                private boolean leftEdge;

                @Override
                public Dimension getPreferredDimension(Graphics2D graphics) {
                    return new Dimension(this.requestedDimension.width, (int)(1.5 * (double)this.requestedDimension.height + 0.5));
                }

                public GradientColorManager(Color color, double opacity, Color previousColor, Dimension requestedDimension, Color borderColor) {
                    super(color, opacity, requestedDimension, borderColor);
                    this.previousColor = previousColor;
                    if (previousColor == null) {
                        this.leftEdge = true;
                    }
                }

                @Override
                public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
                    Rectangle2D.Double rectLegend;
                    double minx = clipBox.getMinX();
                    double miny = clipBox.getMinY();
                    double w = clipBox.getWidth();
                    double h = clipBox.getHeight();
                    if (!this.leftEdge) {
                        rectLegend = new Rectangle2D.Double(minx, miny, w, h / 2.0);
                        Paint oldPaint = graphics.getPaint();
                        GradientPaint paint = new GradientPaint((float)minx, (float)miny, this.previousColor, (float)minx, (float)(miny + h / 2.0), this.bkgColor);
                        graphics.setPaint(paint);
                        graphics.fill(rectLegend);
                        graphics.setPaint(oldPaint);
                    }
                    rectLegend = new Rectangle2D.Double(minx, miny + (this.leftEdge ? 0.0 : h / 2.0), w, !this.leftEdge ? h / 2.0 : h);
                    super.draw(graphics, rectLegend, completeBorder);
                    if (completeBorder) {
                        Color oldColor = graphics.getColor();
                        graphics.setColor(this.borderColor);
                        int minx_ = (int)(clipBox.getMinX() + 0.5);
                        int maxx = (int)(minx + clipBox.getWidth() + 0.5) - 1;
                        int maxy = (int)(miny + clipBox.getHeight() + 0.5) - 1;
                        graphics.drawLine(minx_, maxy, maxx, maxy);
                        graphics.setColor(oldColor);
                    }
                }
            }
        }
    }

    public static class TextManager
    extends Cell {
        public TextManager(String text, LegendUtils.VAlign vAlign, LegendUtils.HAlign hAlign, Color bkgColor, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor) {
            super(bkgColor, 1.0, text, hAlign, vAlign, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor);
        }

        @Override
        public Dimension getPreferredDimension(Graphics2D graphics) {
            Font oldFont = graphics.getFont();
            graphics.setFont(this.labelFont);
            int labelHeight = (int)Math.ceil(graphics.getFontMetrics().getStringBounds(this.text, graphics).getHeight());
            int labelWidth = (int)Math.ceil(graphics.getFontMetrics().getStringBounds(this.text, graphics).getWidth());
            graphics.setFont(oldFont);
            return new Dimension(labelWidth, labelHeight);
        }

        @Override
        public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
            int yText;
            int xText;
            Font oldFont = graphics.getFont();
            graphics.setColor(this.labelFontColor);
            graphics.setFont(this.labelFont);
            if (this.fontAntiAliasing) {
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            double minx = clipBox.getMinX();
            double miny = clipBox.getMinY();
            double w = clipBox.getWidth();
            double h = clipBox.getHeight();
            Dimension dimension = this.getPreferredDimension(graphics);
            switch (this.hAlign) {
                case CENTERED: {
                    xText = (int)(minx + (w - dimension.getWidth()) / 2.0 + 0.5);
                    break;
                }
                case LEFT: {
                    xText = (int)(minx + 0.5);
                    break;
                }
                case RIGHT: {
                    xText = (int)(minx + (w - dimension.getWidth()) + 0.5);
                    break;
                }
                case JUSTIFIED: {
                    throw new UnsupportedOperationException("Unsupported");
                }
                default: {
                    throw new IllegalStateException("Unsupported horizontal alignment " + (Object)((Object)this.hAlign));
                }
            }
            switch (this.vAlign) {
                case BOTTOM: {
                    yText = (int)(miny + h - (double)graphics.getFontMetrics().getDescent() + 0.5);
                    break;
                }
                case TOP: {
                    yText = (int)(miny + (double)graphics.getFontMetrics().getHeight() + 0.5);
                    break;
                }
                case MIDDLE: {
                    yText = (int)(miny + (h + (double)graphics.getFontMetrics().getHeight()) / 2.0 + 0.5);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported vertical alignment " + (Object)((Object)this.vAlign));
                }
            }
            graphics.drawString(this.text, xText, yText);
            graphics.setFont(oldFont);
        }
    }

    public static class ClassesEntryLegendBuilder
    extends ColorMapEntryLegendBuilder {
        public ClassesEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor) {
            this(mapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, null, 0, false);
        }

        public ClassesEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits) {
            this(mapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, unit, digits, true);
        }

        public ClassesEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits, boolean formatQuantity) {
            String rule;
            ColorMapEntry previousCME = mapEntries.get(0);
            ColorMapEntry currentCME = mapEntries.get(1);
            boolean leftEdge = previousCME == null;
            Color color = LegendUtils.color(currentCME);
            double opacity = LegendUtils.getOpacity(currentCME);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
            super.add(new ColorManager.SimpleColorManager(color, opacity, requestedDimension, borderColor));
            String label = currentCME.getLabel();
            double quantity1 = leftEdge ? LegendUtils.getQuantity(currentCME) : LegendUtils.getQuantity(previousCME);
            double quantity2 = LegendUtils.getQuantity(currentCME);
            String symbol1 = null;
            String symbol2 = null;
            if (formatQuantity) {
                rule = "";
                if (opacity > 0.0) {
                    if (leftEdge) {
                        symbol1 = " < ";
                    } else {
                        symbol1 = " <= ";
                        symbol2 = " < ";
                    }
                    String value1 = this.formatQuantity(quantity1, digits, unit);
                    String value2 = this.formatQuantity(quantity2, digits, unit);
                    rule = leftEdge ? value1 + " " + symbol1 + " x" : value1 + " " + symbol1 + " x " + symbol2 + " " + value2;
                }
            } else {
                if (leftEdge) {
                    symbol1 = " < ";
                } else {
                    symbol1 = " <= ";
                    symbol2 = " < ";
                }
                rule = leftEdge ? Double.toString(quantity1) + " " + symbol1 + " x" : Double.toString(quantity1) + " " + symbol1 + " x " + symbol2 + " " + Double.toString(quantity2);
            }
            super.add(new TextManager(rule, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor));
            if (label != null) {
                this.hasLabel = true;
                super.add(new TextManager(label, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor));
            } else {
                super.add(null);
            }
        }
    }

    public static class RampColorMapEntryLegendBuilder
    extends ColorMapEntryLegendBuilder {
        public RampColorMapEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor) {
            this(mapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, null, 0, false);
        }

        public RampColorMapEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits) {
            this(mapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, unit, digits, true);
        }

        public RampColorMapEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits, boolean formatQuantity) {
            String rule;
            Color previousColor;
            ColorMapEntry previousCME = mapEntries.get(0);
            ColorMapEntry currentCME = mapEntries.get(1);
            boolean leftEdge = previousCME == null;
            if (!leftEdge) {
                previousColor = LegendUtils.color(previousCME);
                double opacity = LegendUtils.getOpacity(previousCME);
                previousColor = new Color(previousColor.getRed(), previousColor.getGreen(), previousColor.getBlue(), (int)(255.0 * opacity + 0.5));
            } else {
                previousColor = null;
            }
            Color color = LegendUtils.color(currentCME);
            double opacity = LegendUtils.getOpacity(currentCME);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
            super.add(new ColorManager.SimpleColorManager.GradientColorManager(color, opacity, previousColor, requestedDimension, borderColor));
            String label = currentCME.getLabel();
            double quantity = LegendUtils.getQuantity(currentCME);
            if (formatQuantity) {
                rule = "";
                if (opacity > 0.0) {
                    String symbol = leftEdge ? " > " : " = ";
                    String value = this.formatQuantity(quantity, digits, unit);
                    rule = leftEdge ? value + " " + symbol + " x" : value + " ";
                }
            } else {
                String symbol = leftEdge ? " > " : " = ";
                rule = leftEdge ? Double.toString(quantity) + " " + symbol + " x" : Double.toString(quantity) + " " + symbol + " x";
            }
            super.add(new TextManager(rule, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor));
            if (label != null) {
                this.hasLabel = true;
                super.add(new TextManager(label, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor));
            } else {
                super.add(null);
            }
        }
    }

    public static class SingleColorMapEntryLegendBuilder
    extends ColorMapEntryLegendBuilder {
        public SingleColorMapEntryLegendBuilder(List<ColorMapEntry> cMapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits, boolean formatQuantity) {
            String rule;
            ColorMapEntry currentCME = cMapEntries.get(0);
            Color color = LegendUtils.color(currentCME);
            double opacity = LegendUtils.getOpacity(currentCME);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
            super.add(new ColorManager.SimpleColorManager(color, opacity, requestedDimension, borderColor));
            String label = currentCME.getLabel();
            double quantity = LegendUtils.getQuantity(currentCME);
            String symbol = " = ";
            if (formatQuantity) {
                String value = this.formatQuantity(quantity, digits, unit);
                rule = value + " " + " = " + " x";
            } else {
                rule = Double.toString(quantity) + " " + " = " + " x";
            }
            super.add(new TextManager(rule, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor));
            if (label != null) {
                this.hasLabel = true;
                super.add(new TextManager(label, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor));
            } else {
                super.add(null);
            }
        }

        public SingleColorMapEntryLegendBuilder(List<ColorMapEntry> cMapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor) {
            this(cMapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, null, 0, false);
        }

        public SingleColorMapEntryLegendBuilder(List<ColorMapEntry> cMapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor, String unit, int digits) {
            this(cMapEntries, hAlign, vAling, bkgColor, bkgOpacity, text, requestedDimension, labelFont, labelFontColor, fontAntiAliasing, borderColor, unit, digits, true);
        }
    }

    public static abstract class ColorMapEntryLegendBuilder
    extends Row {
        protected boolean hasLabel;

        protected ColorMapEntryLegendBuilder() {
        }

        protected ColorMapEntryLegendBuilder(List<Cell> columns) {
            super(columns);
        }

        protected ColorMapEntryLegendBuilder(ColorManager colorManager, TextManager labelManager, TextManager ruleManager) {
            super(Arrays.asList(colorManager, ruleManager, labelManager));
        }

        public boolean hasLabel() {
            return this.hasLabel;
        }

        public Cell getRuleManager() {
            return this.get(1);
        }

        public Cell getLabelManager() {
            return this.get(2);
        }

        public Cell getColorManager() {
            return this.get(0);
        }

        protected String formatQuantity(double quantity, int digits, String unit) {
            String format = "%." + digits + "f";
            return String.format(Locale.US, format, quantity) + (unit != null ? " " + unit : "");
        }
    }

    public static abstract class Row {
        private final List<Cell> cells = new ArrayList<Cell>();

        Row() {
        }

        Row(List<Cell> columns) {
            columns.addAll(columns);
        }

        protected Cell get(int index) {
            return this.cells.get(index);
        }

        protected void add(Cell cell) {
            this.cells.add(cell);
        }
    }
}

