/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.legendgraphic.RasterLayerLegendHelper;
import org.geoserver.wms.map.ImageUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataUtilities;
import org.geotools.data.Parameter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.process.Processors;
import org.geotools.process.function.ProcessFunction;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.Description;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DpiRescaleStyleVisitor;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.opengis.feature.Feature;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.style.GraphicLegend;
import org.opengis.util.InternationalString;

public class BufferedImageLegendGraphicBuilder {
    public static final double TOLERANCE = 1.0E-6;
    private static final StyledShapePainter shapePainter = new StyledShapePainter();
    private static final GeometryFactory geomFac = new GeometryFactory();
    private LiteShape2 sampleRect;
    private LiteShape2 sampleLine;
    private LiteShape2 samplePoint;
    private final double MINIMUM_SYMBOL_SIZE = 3.0;

    public BufferedImage buildLegendGraphic(GetLegendGraphicRequest request) throws ServiceException {
        String forceTitlesOpt;
        ArrayList<RenderedImage> layersImages = new ArrayList<RenderedImage>();
        List<FeatureType> layers = request.getLayers();
        List<Style> styles = request.getStyles();
        List<String> rules = request.getRules();
        boolean forceLabelsOn = false;
        boolean forceLabelsOff = false;
        if (request.getLegendOptions().get("forceLabels") instanceof String) {
            String forceLabelsOpt = (String)request.getLegendOptions().get("forceLabels");
            if (forceLabelsOpt.equalsIgnoreCase("on")) {
                forceLabelsOn = true;
            } else if (forceLabelsOpt.equalsIgnoreCase("off")) {
                forceLabelsOff = true;
            }
        }
        boolean forceTitlesOff = false;
        if (request.getLegendOptions().get("forceTitles") instanceof String && (forceTitlesOpt = (String)request.getLegendOptions().get("forceTitles")).equalsIgnoreCase("off")) {
            forceTitlesOff = true;
        }
        for (int pos = 0; pos < layers.size(); ++pos) {
            Rule[] applicableRules;
            boolean buildRasterLegend;
            double standardDpi;
            FeatureType layer = layers.get(pos);
            Style gt2Style = styles.get(pos);
            String ruleName = null;
            if (gt2Style == null) {
                throw new NullPointerException("request.getStyle()");
            }
            if (rules.size() > 0) {
                ruleName = rules.get(pos);
            }
            if (ruleName != null && ruleName.equals("")) {
                ruleName = null;
            }
            int w = request.getWidth();
            int h = request.getHeight();
            double dpi = RendererUtilities.getDpi((Map)request.getLegendOptions());
            if (dpi != (standardDpi = RendererUtilities.getDpi(Collections.emptyMap()))) {
                double scaleFactor = dpi / standardDpi;
                w = (int)Math.round((double)w * scaleFactor);
                h = (int)Math.round((double)h * scaleFactor);
                DpiRescaleStyleVisitor dpiVisitor = new DpiRescaleStyleVisitor(scaleFactor);
                dpiVisitor.visit(gt2Style);
                gt2Style = (Style)dpiVisitor.getCopy();
            }
            if (request.getScale() > 0.0) {
                double pixelsPerMeters = RendererUtilities.calculatePixelsPerMeterRatio((double)request.getScale(), (Map)request.getLegendOptions());
                UomRescaleStyleVisitor rescaleVisitor = new UomRescaleStyleVisitor(pixelsPerMeters);
                rescaleVisitor.visit(gt2Style);
                gt2Style = (Style)rescaleVisitor.getCopy();
            }
            boolean strict = request.isStrict();
            boolean transparent = request.isTransparent();
            RenderedImage titleImage = null;
            if (layers.size() > 1 && !forceTitlesOff) {
                titleImage = this.getLayerTitle(layer, w, h, transparent, request);
            }
            boolean hasVectorTransformation = false;
            boolean hasRasterTransformation = false;
            List ftsList = gt2Style.featureTypeStyles();
            for (int i = 0; i < ftsList.size(); ++i) {
                ProcessFunction processFunction;
                Name processName;
                Map outputs;
                FeatureTypeStyle fts = (FeatureTypeStyle)ftsList.get(i);
                Expression exp = fts.getTransformation();
                if (exp == null || (outputs = Processors.getResultInfo((Name)(processName = (processFunction = (ProcessFunction)exp).getProcessName()), null)).isEmpty()) continue;
                Parameter output = (Parameter)outputs.values().iterator().next();
                if (SimpleFeatureCollection.class.isAssignableFrom(output.getType())) {
                    hasVectorTransformation = true;
                    break;
                }
                if (!GridCoverage2D.class.isAssignableFrom(output.getType())) continue;
                hasRasterTransformation = true;
                break;
            }
            boolean bl = buildRasterLegend = !strict && layer == null && LegendUtils.checkRasterSymbolizer(gt2Style) || LegendUtils.checkGridLayer(layer) && !hasVectorTransformation || hasRasterTransformation;
            if (buildRasterLegend) {
                RasterLayerLegendHelper rasterLegendHelper = new RasterLayerLegendHelper(request, gt2Style, ruleName);
                BufferedImage image = rasterLegendHelper.getLegend();
                if (image == null) continue;
                if (titleImage != null) {
                    layersImages.add(titleImage);
                }
                layersImages.add(image);
                continue;
            }
            Object sampleFeature = layer == null || hasVectorTransformation ? this.createSampleFeature() : this.createSampleFeature(layer);
            FeatureTypeStyle[] ftStyles = gt2Style.featureTypeStyles().toArray(new FeatureTypeStyle[0]);
            double scaleDenominator = request.getScale();
            if (ruleName != null) {
                Rule rule = LegendUtils.getRule(ftStyles, ruleName);
                if (rule == null) {
                    throw new ServiceException("Specified style does not contains a rule named " + ruleName);
                }
                applicableRules = new Rule[]{rule};
            } else {
                applicableRules = LegendUtils.getApplicableRules(ftStyles, scaleDenominator);
            }
            NumberRange scaleRange = NumberRange.create((double)scaleDenominator, (double)scaleDenominator);
            int ruleCount = applicableRules.length;
            ArrayList<RenderedImage> legendsStack = new ArrayList<RenderedImage>(ruleCount);
            SLDStyleFactory styleFactory = new SLDStyleFactory();
            double minimumSymbolSize = 3.0;
            if (request.getLegendOptions().get("minSymbolSize") instanceof String) {
                String minSymbolSizeOpt = (String)request.getLegendOptions().get("minSymbolSize");
                try {
                    minimumSymbolSize = Double.parseDouble(minSymbolSizeOpt);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid minSymbolSize value: should be a number");
                }
            }
            double symbolScale = this.calcSymbolScale(w, h, layer, (Feature)sampleFeature, applicableRules, minimumSymbolSize);
            for (int i = 0; i < ruleCount; ++i) {
                BufferedImage image = ImageUtils.createImage(w, h, null, transparent);
                HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
                Graphics2D graphics = ImageUtils.prepareTransparency(transparent, LegendUtils.getBackgroundColor(request), image, hintsMap);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Feature sample = this.getSampleFeatureForRule(layer, (Feature)sampleFeature, applicableRules[i]);
                FilterFactory ff = CommonFactoryFinder.getFilterFactory();
                Symbolizer[] symbolizers = applicableRules[i].getSymbolizers();
                GraphicLegend legend = applicableRules[i].getLegend();
                if (legend != null) {
                    if (this.samplePoint == null) {
                        Coordinate coord = new Coordinate((double)(w / 2), (double)(h / 2));
                        try {
                            this.samplePoint = new LiteShape2((Geometry)geomFac.createPoint(coord), null, null, false);
                        }
                        catch (Exception e) {
                            this.samplePoint = null;
                        }
                    }
                    shapePainter.paint(graphics, this.samplePoint, legend, scaleDenominator, false);
                } else {
                    for (int sIdx = 0; sIdx < symbolizers.length; ++sIdx) {
                        PointSymbolizer pointSymbolizer;
                        Symbolizer symbolizer = symbolizers[sIdx];
                        if (symbolizer instanceof RasterSymbolizer) continue;
                        if (symbolScale > 1.0 && symbolizer instanceof PointSymbolizer && (pointSymbolizer = this.cloneSymbolizer(symbolizer)).getGraphic() != null) {
                            double size = this.getPointSymbolizerSize(sample, pointSymbolizer, Math.min(w, h) - 4);
                            pointSymbolizer.getGraphic().setSize((Expression)ff.literal(size / symbolScale + minimumSymbolSize));
                            symbolizer = pointSymbolizer;
                        }
                        Style2D style2d = styleFactory.createStyle((Object)sample, symbolizer, (Range)scaleRange);
                        LiteShape2 shape = this.getSampleShape(symbolizer, w, h);
                        if (style2d == null) continue;
                        shapePainter.paint(graphics, shape, style2d, scaleDenominator);
                    }
                }
                if (image != null && titleImage != null) {
                    layersImages.add(titleImage);
                    titleImage = null;
                }
                legendsStack.add(image);
                graphics.dispose();
            }
            BufferedImage image = this.mergeLegends(legendsStack, applicableRules, request, forceLabelsOn, forceLabelsOff);
            if (image == null) continue;
            layersImages.add(image);
        }
        BufferedImage finalLegend = this.mergeLegends(layersImages, null, request, forceLabelsOn, forceLabelsOff);
        if (finalLegend == null) {
            throw new IllegalArgumentException("no legend passed");
        }
        return finalLegend;
    }

    private PointSymbolizer cloneSymbolizer(Symbolizer symbolizer) {
        DuplicatingStyleVisitor duplicator = new DuplicatingStyleVisitor();
        symbolizer.accept((StyleVisitor)duplicator);
        PointSymbolizer pointSymbolizer = (PointSymbolizer)duplicator.getCopy();
        return pointSymbolizer;
    }

    private double calcSymbolScale(int width, int height, FeatureType featureType, Feature feature, Rule[] rules, double minimumSymbolsSize) {
        double minSize = Double.MAX_VALUE;
        double maxSize = 0.0;
        int ruleCount = rules.length;
        for (int i = 0; i < ruleCount; ++i) {
            Feature sample = this.getSampleFeatureForRule(featureType, feature, rules[i]);
            Symbolizer[] symbolizers = rules[i].getSymbolizers();
            for (int sIdx = 0; sIdx < symbolizers.length; ++sIdx) {
                Symbolizer symbolizer = symbolizers[sIdx];
                if (!(symbolizer instanceof PointSymbolizer)) continue;
                double size = this.getPointSymbolizerSize(sample, (PointSymbolizer)symbolizer, Math.min(width, height));
                if (size < minSize) {
                    minSize = size;
                }
                if (!(size > maxSize)) continue;
                maxSize = size;
            }
        }
        if (minSize != maxSize) {
            return (maxSize - minSize + 1.0) / ((double)Math.min(width, height) - minimumSymbolsSize);
        }
        return maxSize / ((double)Math.min(width, height) - minimumSymbolsSize);
    }

    private double getPointSymbolizerSize(Feature feature, PointSymbolizer pointSymbolizer, int defaultSize) {
        Object size;
        Expression sizeExp;
        if (pointSymbolizer.getGraphic() != null && (sizeExp = pointSymbolizer.getGraphic().getSize()) instanceof Literal && (size = sizeExp.evaluate((Object)feature)) != null) {
            if (size instanceof Double) {
                return (Double)size;
            }
            try {
                return Double.parseDouble(size.toString());
            }
            catch (NumberFormatException e) {
                return defaultSize;
            }
        }
        return defaultSize;
    }

    private Feature getSampleFeatureForRule(FeatureType featureType, Feature sample, Rule rule) {
        Symbolizer[] symbolizers = rule.getSymbolizers();
        if (sample == null) {
            int dimensionality = 1;
            for (int sIdx = 0; sIdx < symbolizers.length; ++sIdx) {
                Symbolizer symbolizer = symbolizers[sIdx];
                if (LineSymbolizer.class.isAssignableFrom(symbolizer.getClass())) {
                    dimensionality = 2;
                }
                if (!PolygonSymbolizer.class.isAssignableFrom(symbolizer.getClass())) continue;
                dimensionality = 3;
            }
            return this.createSampleFeature(featureType, dimensionality);
        }
        return sample;
    }

    private RenderedImage getLayerTitle(FeatureType layer, int w, int h, boolean transparent, GetLegendGraphicRequest request) {
        String title = request.getTitle(layer.getName());
        if (title == null) {
            title = layer.getName().getLocalPart();
        }
        BufferedImage image = ImageUtils.createImage(w, h, null, transparent);
        return this.getRenderedLabel(image, title, request);
    }

    private BufferedImage getRenderedLabel(BufferedImage image, String label, GetLegendGraphicRequest request) {
        Font labelFont = LegendUtils.getLabelFont(request);
        boolean useAA = LegendUtils.isFontAntiAliasing(request);
        Graphics2D graphics = image.createGraphics();
        graphics.setFont(labelFont);
        if (useAA) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        return LegendUtils.renderLabel(label, graphics, request);
    }

    private BufferedImage mergeLegends(List<RenderedImage> imageStack, Rule[] rules, GetLegendGraphicRequest req, boolean forceLabelsOn, boolean forceLabelsOff) {
        BufferedImage finalLegend;
        Font labelFont = LegendUtils.getLabelFont(req);
        boolean useAA = LegendUtils.isFontAntiAliasing(req);
        if (imageStack.size() == 0) {
            return null;
        }
        if (!(imageStack.size() != 1 || forceLabelsOn && rules != null)) {
            finalLegend = (BufferedImage)imageStack.get(0);
        } else {
            int imgCount = imageStack.size();
            String[] labels = new String[imgCount];
            BufferedImage img = (BufferedImage)imageStack.get(0);
            int totalHeight = 0;
            int totalWidth = 0;
            int[] rowHeights = new int[imgCount];
            BufferedImage[] labelsGraphics = new BufferedImage[imgCount];
            for (int i = 0; i < imgCount; ++i) {
                img = (BufferedImage)imageStack.get(i);
                if (forceLabelsOff || rules == null) {
                    totalWidth = (int)Math.ceil(Math.max(img.getWidth(), totalWidth));
                    rowHeights[i] = img.getHeight();
                    totalHeight += img.getHeight();
                    continue;
                }
                Rule rule = rules[i];
                Description description = rule.getDescription();
                Locale locale = req.getLocale();
                if (description != null && description.getTitle() != null) {
                    InternationalString title = description.getTitle();
                    labels[i] = locale != null ? title.toString(locale) : title.toString();
                } else {
                    labels[i] = rule.getName() != null ? rule.getName() : "";
                }
                if (labels[i] != null && labels[i].length() > 0) {
                    BufferedImage renderedLabel;
                    labelsGraphics[i] = renderedLabel = this.getRenderedLabel(img, labels[i], req);
                    Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, renderedLabel.getWidth(), renderedLabel.getHeight());
                    totalWidth = (int)Math.ceil(Math.max((double)img.getWidth() + ((RectangularShape)bounds).getWidth(), (double)totalWidth));
                    rowHeights[i] = (int)Math.ceil(Math.max((double)img.getHeight(), ((RectangularShape)bounds).getHeight()));
                } else {
                    totalWidth = (int)Math.ceil(Math.max(img.getWidth(), totalWidth));
                    rowHeights[i] = (int)Math.ceil(img.getHeight());
                    labelsGraphics[i] = null;
                }
                totalHeight += rowHeights[i];
            }
            boolean transparent = req.isTransparent();
            Color backgroundColor = LegendUtils.getBackgroundColor(req);
            HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
            finalLegend = ImageUtils.createImage(totalWidth += 2, totalHeight, null, transparent);
            Graphics2D finalGraphics = ImageUtils.prepareTransparency(transparent, backgroundColor, finalLegend, hintsMap);
            int topOfRow = 0;
            for (int i = 0; i < imgCount; ++i) {
                img = (BufferedImage)imageStack.get(i);
                int y = topOfRow;
                if (img.getHeight() < rowHeights[i]) {
                    y += (int)((double)(rowHeights[i] - img.getHeight()) / 2.0);
                }
                finalGraphics.drawImage((Image)img, 0, y, null);
                if (forceLabelsOff || rules == null) {
                    topOfRow += rowHeights[i];
                    continue;
                }
                finalGraphics.setFont(labelFont);
                if (useAA) {
                    finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else {
                    finalGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
                if (labels[i] != null && labels[i].length() > 0) {
                    BufferedImage renderedLabel = labelsGraphics[i];
                    y = topOfRow;
                    if (renderedLabel.getHeight() < rowHeights[i]) {
                        y += (int)((double)(rowHeights[i] - renderedLabel.getHeight()) / 2.0);
                    }
                    finalGraphics.drawImage((Image)renderedLabel, img.getWidth(), y, null);
                    renderedLabel.flush();
                    labelsGraphics[i] = null;
                }
                topOfRow += rowHeights[i];
            }
            finalGraphics.dispose();
        }
        return finalLegend;
    }

    private LiteShape2 getSampleShape(Symbolizer symbolizer, int legendWidth, int legendHeight) {
        LiteShape2 sampleShape;
        float hpad = (float)legendWidth * 0.15f;
        float vpad = (float)legendHeight * 0.15f;
        if (symbolizer instanceof LineSymbolizer) {
            if (this.sampleLine == null) {
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)((float)legendHeight - vpad - 1.0f)), new Coordinate((double)((float)legendWidth - hpad - 1.0f), (double)vpad)};
                LineString geom = geomFac.createLineString(coords);
                try {
                    this.sampleLine = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleLine = null;
                }
            }
            sampleShape = this.sampleLine;
        } else if (symbolizer instanceof PolygonSymbolizer || symbolizer instanceof RasterSymbolizer) {
            if (this.sampleRect == null) {
                float w = (float)legendWidth - 2.0f * hpad - 1.0f;
                float h = (float)legendHeight - 2.0f * vpad - 1.0f;
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)vpad), new Coordinate((double)hpad, (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)vpad), new Coordinate((double)hpad, (double)vpad)};
                LinearRing shell = geomFac.createLinearRing(coords);
                Polygon geom = geomFac.createPolygon(shell, null);
                try {
                    this.sampleRect = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleRect = null;
                }
            }
            sampleShape = this.sampleRect;
        } else if (symbolizer instanceof PointSymbolizer || symbolizer instanceof TextSymbolizer) {
            if (this.samplePoint == null) {
                Coordinate coord = new Coordinate((double)(legendWidth / 2), (double)(legendHeight / 2));
                try {
                    this.samplePoint = new LiteShape2((Geometry)geomFac.createPoint(coord), null, null, false);
                }
                catch (Exception e) {
                    this.samplePoint = null;
                }
            }
            sampleShape = this.samplePoint;
        } else {
            throw new IllegalArgumentException("Unknown symbolizer: " + symbolizer);
        }
        return sampleShape;
    }

    private SimpleFeature createSampleFeature() {
        SimpleFeatureType type;
        try {
            type = DataUtilities.createType((String)"Sample", (String)"the_geom:Geometry");
        }
        catch (SchemaException e) {
            throw new RuntimeException(e);
        }
        return SimpleFeatureBuilder.template((SimpleFeatureType)type, null);
    }

    private Feature createSampleFeature(FeatureType schema, int dimensionality) throws ServiceException {
        if (schema instanceof SimpleFeatureType) {
            schema = this.cloneWithDimensionality(schema, dimensionality);
        }
        return this.createSampleFeature(schema);
    }

    private FeatureType cloneWithDimensionality(FeatureType schema, int dimensionality) {
        SimpleFeatureType simpleFt = (SimpleFeatureType)schema;
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(schema.getName());
        builder.setCRS(schema.getCoordinateReferenceSystem());
        for (AttributeDescriptor desc : simpleFt.getAttributeDescriptors()) {
            if (this.isMixedGeometry(desc)) {
                GeometryDescriptor geomDescriptor = (GeometryDescriptor)desc;
                GeometryType geomType = geomDescriptor.getType();
                Class<?> geometryClass = this.getGeometryForDimensionality(dimensionality);
                GeometryTypeImpl gt = new GeometryTypeImpl(geomType.getName(), geometryClass, geomType.getCoordinateReferenceSystem(), geomType.isIdentified(), geomType.isAbstract(), geomType.getRestrictions(), geomType.getSuper(), geomType.getDescription());
                builder.add((AttributeDescriptor)new GeometryDescriptorImpl((GeometryType)gt, geomDescriptor.getName(), geomDescriptor.getMinOccurs(), geomDescriptor.getMaxOccurs(), geomDescriptor.isNillable(), geomDescriptor.getDefaultValue()));
                continue;
            }
            builder.add(desc);
        }
        schema = builder.buildFeatureType();
        return schema;
    }

    private Class<?> getGeometryForDimensionality(int dimensionality) {
        if (dimensionality == 1) {
            return Point.class;
        }
        if (dimensionality == 2) {
            return LineString.class;
        }
        return Polygon.class;
    }

    private Feature createSampleFeature(FeatureType schema) throws ServiceException {
        Object sampleFeature;
        try {
            sampleFeature = schema instanceof SimpleFeatureType ? (this.hasMixedGeometry((SimpleFeatureType)schema) ? null : SimpleFeatureBuilder.template((SimpleFeatureType)((SimpleFeatureType)schema), null)) : DataUtilities.templateFeature((FeatureType)schema);
        }
        catch (IllegalAttributeException e) {
            throw new ServiceException((Throwable)e);
        }
        return sampleFeature;
    }

    private boolean hasMixedGeometry(SimpleFeatureType schema) {
        for (AttributeDescriptor attDesc : schema.getAttributeDescriptors()) {
            if (!this.isMixedGeometry(attDesc)) continue;
            return true;
        }
        return false;
    }

    private boolean isMixedGeometry(AttributeDescriptor attDesc) {
        return attDesc instanceof GeometryDescriptor && attDesc.getType().getBinding() == Geometry.class;
    }
}

