/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.opengis.wfs.FeatureCollectionType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.featureinfo.LayerIdentifier;
import org.geotools.data.ows.Layer;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.data.wms.WebMapServer;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.WMSLayer;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v1_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMSLayerIdentifier
implements LayerIdentifier {
    static final Logger LOGGER = Logging.getLogger(WMSLayerIdentifier.class);
    private EntityResolverProvider resolverProvider;

    public WMSLayerIdentifier(EntityResolverProvider resolverProvider) {
        this.resolverProvider = resolverProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeatureCollection> identify(FeatureInfoRequestParameters params, int maxFeatures) throws IOException {
        int x = params.getX();
        int y = params.getY();
        WMSLayerInfo info = (WMSLayerInfo)params.getLayer().getResource();
        WebMapServer wms = info.getStore().getWebMapServer(null);
        Layer layer = info.getWMSLayer(null);
        CoordinateReferenceSystem crs = params.getRequestedCRS();
        if (crs == null) {
            crs = info.getCRS();
        }
        ReferencedEnvelope bbox = params.getRequestedBounds();
        int width = params.getWidth();
        int height = params.getHeight();
        if (!layer.isQueryable()) {
            return null;
        }
        List infoFormats = wms.getCapabilities().getRequest().getGetFeatureInfo().getFormats();
        if (!infoFormats.contains("application/vnd.ogc.gml")) {
            return null;
        }
        WMSLayer ml = new WMSLayer(wms, layer);
        ArrayList<FeatureCollection> results = new ArrayList<FeatureCollection>();
        try (InputStream is = ml.getFeatureInfo(bbox, width, height, x, y, "application/vnd.ogc.gml", maxFeatures);){
            Parser parser = new Parser((Configuration)new WFSConfiguration());
            parser.setStrict(false);
            parser.setEntityResolver(this.resolverProvider.getEntityResolver());
            Object result = parser.parse(is);
            if (result instanceof FeatureCollectionType) {
                FeatureCollectionType fcList = (FeatureCollectionType)result;
                EList rawResults = fcList.getFeature();
                for (SimpleFeatureCollection fc : rawResults) {
                    SimpleFeatureType ft = (SimpleFeatureType)fc.getSchema();
                    SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                    builder.init(ft);
                    builder.setName(info.getName());
                    builder.setNamespaceURI(info.getNamespace().getURI());
                    SimpleFeatureType targetFeatureType = builder.buildFeatureType();
                    ReTypingFeatureCollection rfc = new ReTypingFeatureCollection(fc, targetFeatureType);
                    results.add((FeatureCollection)rfc);
                }
            }
        }
        return results;
    }

    @Override
    public boolean canHandle(MapLayerInfo layer) {
        return layer.getType() == MapLayerInfo.TYPE_WMS;
    }
}

