/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.LayerIdentifier;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.TransformedDirectPosition;
import org.geotools.parameter.Parameter;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.ProgressListener;

public class RasterLayerIdentifier
implements LayerIdentifier {
    static final Logger LOGGER = Logging.getLogger(RasterLayerIdentifier.class);
    private WMS wms;

    public RasterLayerIdentifier(WMS wms) {
        this.wms = wms;
    }

    @Override
    public boolean canHandle(MapLayerInfo layer) {
        int type = layer.getType();
        return type == MapLayerInfo.TYPE_RASTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeatureCollection> identify(FeatureInfoRequestParameters params, int maxFeatures) throws Exception {
        MapLayerInfo layer = params.getLayer();
        Filter filter = params.getFilter();
        CoverageInfo cinfo = layer.getCoverage();
        GridCoverage2DReader reader = (GridCoverage2DReader)cinfo.getGridCoverageReader((ProgressListener)new NullProgressListener(), GeoTools.getDefaultHints());
        Coordinate middle = WMS.pixelToWorld(params.getX(), params.getY(), params.getRequestedBounds(), params.getWidth(), params.getHeight());
        CoordinateReferenceSystem requestedCRS = params.getRequestedCRS();
        DirectPosition2D position = new DirectPosition2D(requestedCRS, middle.x, middle.y);
        if (requestedCRS != null) {
            CoordinateReferenceSystem targetCRS = cinfo.getProjectionPolicy() == ProjectionPolicy.NONE ? cinfo.getNativeCRS() : cinfo.getCRS();
            TransformedDirectPosition arbitraryToInternal = new TransformedDirectPosition(requestedCRS, targetCRS, new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
            try {
                arbitraryToInternal.transform((DirectPosition)position);
            }
            catch (TransformException exception) {
                throw new CannotEvaluateException("Unable to answer the geatfeatureinfo", (Throwable)exception);
            }
            position = arbitraryToInternal;
        }
        if (!reader.getOriginalEnvelope().contains((DirectPosition)position)) {
            return null;
        }
        GetMapRequest getMap = params.getGetMapRequest();
        GeneralParameterValue[] parameters = this.wms.getWMSReadParameters(getMap, layer, filter, params.getTimes(), params.getElevations(), reader, true);
        MathTransform worldToGrid = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER).inverse();
        DirectPosition rasterMid = worldToGrid.transform((DirectPosition)position, null);
        Rectangle2D.Double rasterArea = new Rectangle2D.Double();
        rasterArea.setFrameFromCenter(rasterMid.getOrdinate(0), rasterMid.getOrdinate(1), rasterMid.getOrdinate(0) + 10.0, rasterMid.getOrdinate(1) + 10.0);
        Rectangle integerRasterArea = rasterArea.getBounds();
        GridEnvelope gridEnvelope = reader.getOriginalGridRange();
        Object originalArea = gridEnvelope instanceof GridEnvelope2D ? (GridEnvelope2D)gridEnvelope : new Rectangle();
        XRectangle2D.intersect((Rectangle2D)integerRasterArea, (Rectangle2D)originalArea, (Rectangle2D)integerRasterArea);
        if (integerRasterArea.isEmpty()) {
            return null;
        }
        for (int k = 0; k < parameters.length; ++k) {
            Parameter parameter;
            if (!(parameters[k] instanceof Parameter) || !(parameter = (Parameter)parameters[k]).getDescriptor().getName().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
            parameter.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(integerRasterArea), reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCoordinateReferenceSystem()));
        }
        GridCoverage2D coverage = reader.read(parameters);
        if (coverage == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to load raster data for this request.");
            }
            return null;
        }
        SimpleFeatureCollection pixel = null;
        try {
            double[] pixelValues = coverage.evaluate((DirectPosition)position, (double[])null);
            pixel = this.wrapPixelInFeatureCollection(coverage, pixelValues, cinfo.getQualifiedName());
        }
        catch (PointOutsideCoverageException e) {
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            coverage.dispose(true);
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
        return Collections.singletonList(pixel);
    }

    private SimpleFeatureCollection wrapPixelInFeatureCollection(GridCoverage2D coverage, double[] pixelValues, Name coverageName) throws SchemaException {
        GridSampleDimension[] sampleDimensions = coverage.getSampleDimensions();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(coverageName);
        HashSet<String> bandNames = new HashSet<String>();
        for (int i = 0; i < sampleDimensions.length; ++i) {
            String name = sampleDimensions[i].getDescription().toString();
            if (bandNames.contains(name)) {
                name = name + "_Band" + i;
            }
            bandNames.add(name);
            builder.add(name, Double.class);
        }
        SimpleFeatureType gridType = builder.buildFeatureType();
        Object[] values = new Double[pixelValues.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new Double(pixelValues[i]);
        }
        return DataUtilities.collection((SimpleFeature)SimpleFeatureBuilder.build((SimpleFeatureType)gridType, (Object[])values, (String)""));
    }
}

