/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import net.opengis.wfs.FeatureCollectionType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.ServiceException;
import org.geoserver.template.DirectTemplateFeatureCollectionFactory;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.EnvironmentVariablesTemplateModel;
import org.geoserver.wms.featureinfo.FeatureCollectionDecorator;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class HTMLFeatureInfoOutputFormat
extends GetFeatureInfoOutputFormat {
    private static final String FORMAT = "text/html";
    private static Configuration templateConfig;
    private static DirectTemplateFeatureCollectionFactory tfcFactory;
    GeoServerTemplateLoader templateLoader;
    private WMS wms;

    public HTMLFeatureInfoOutputFormat(WMS wms) {
        super(FORMAT);
        this.wms = wms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FeatureCollectionType results, GetFeatureInfoRequest request, OutputStream out) throws ServiceException, IOException {
        Charset charSet = this.wms.getCharSet();
        OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
        try {
            Template header = null;
            Template footer = null;
            EList collections = results.getFeature();
            if (collections.size() == 1) {
                header = this.getTemplate(FeatureCollectionDecorator.getName((FeatureCollection)collections.get(0)), "header.ftl", charSet);
                footer = this.getTemplate(FeatureCollectionDecorator.getName((FeatureCollection)collections.get(0)), "footer.ftl", charSet);
            } else {
                header = this.getTemplate(null, "header.ftl", charSet);
                footer = this.getTemplate(null, "footer.ftl", charSet);
            }
            try {
                header.process(null, (Writer)osw);
            }
            catch (TemplateException e) {
                String msg = "Error occured processing header template.";
                throw (IOException)new IOException(msg).initCause(e);
            }
            for (int i = 0; i < collections.size(); ++i) {
                FeatureCollection fc = (FeatureCollection)collections.get(i);
                if (fc == null || fc.size() <= 0) continue;
                Template content = null;
                if (!(fc.getSchema() instanceof SimpleFeatureType)) {
                    content = this.getTemplate(FeatureCollectionDecorator.getName(fc), "complex_content.ftl", charSet);
                }
                if (content == null) {
                    content = this.getTemplate(FeatureCollectionDecorator.getName(fc), "content.ftl", charSet);
                }
                try {
                    content.process((Object)fc, (Writer)osw);
                    continue;
                }
                catch (TemplateException e) {
                    String msg = "Error occured processing content template " + content.getName() + " for " + request.getQueryLayers().get(i);
                    throw (IOException)new IOException(msg).initCause(e);
                }
            }
            if (footer != null) {
                try {
                    footer.process(null, (Writer)osw);
                }
                catch (TemplateException e) {
                    String msg = "Error occured processing footer template.";
                    throw (IOException)new IOException(msg).initCause(e);
                }
            }
            osw.flush();
        }
        finally {
            tfcFactory.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Template getTemplate(Name name, String templateFileName, Charset charset) throws IOException {
        if (this.templateLoader == null) {
            this.templateLoader = new GeoServerTemplateLoader(this.getClass());
        }
        if (name != null) {
            ResourceInfo ri = this.wms.getResourceInfo(name);
            if (ri != null) {
                this.templateLoader.setResource(ri);
            } else {
                throw new IllegalArgumentException("Can't find neither a FeatureType nor a CoverageInfo or WMSLayerInfo named " + name);
            }
        }
        Configuration configuration = templateConfig;
        synchronized (configuration) {
            templateConfig.setTemplateLoader((TemplateLoader)this.templateLoader);
            Template t = templateConfig.getTemplate(templateFileName);
            t.setEncoding(charset.name());
            return t;
        }
    }

    @Override
    public String getCharset() {
        return this.wms.getGeoServer().getSettings().getCharset();
    }

    static {
        tfcFactory = new DirectTemplateFeatureCollectionFactory();
        templateConfig = new Configuration();
        templateConfig.setObjectWrapper((ObjectWrapper)new FeatureWrapper((FeatureWrapper.TemplateFeatureCollectionFactory)tfcFactory){

            public TemplateModel wrap(Object object) throws TemplateModelException {
                if (object instanceof FeatureCollection) {
                    SimpleHash map = (SimpleHash)super.wrap(object);
                    map.put("request", (Object)((Request)Dispatcher.REQUEST.get()).getKvp());
                    map.put("environment", (Object)new EnvironmentVariablesTemplateModel());
                    return map;
                }
                return super.wrap(object);
            }
        });
    }
}

