/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.GML3OutputFormat;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.FeatureCollectionDecorator;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GML3FeatureInfoOutputFormat
extends GetFeatureInfoOutputFormat {
    public static final String FORMAT = "application/vnd.ogc.gml/3.1.1";
    private WMS wms;

    public GML3FeatureInfoOutputFormat(WMS wms) {
        this(wms, FORMAT);
    }

    protected GML3FeatureInfoOutputFormat(WMS wms, String format) {
        super(format);
        this.wms = wms;
    }

    @Override
    public void write(FeatureCollectionType results, GetFeatureInfoRequest fInfoReq, OutputStream out) throws ServiceException, IOException {
        FeatureCollectionType features = WfsFactory.eINSTANCE.createFeatureCollectionType();
        GetFeatureType gfreq = WfsFactory.eINSTANCE.createGetFeatureType();
        gfreq.setBaseUrl(fInfoReq.getBaseUrl());
        for (int i = 0; i < results.getFeature().size(); ++i) {
            FeatureCollection fc = (FeatureCollection)results.getFeature().get(i);
            Name name = FeatureCollectionDecorator.getName(fc);
            QName qname = new QName(name.getNamespaceURI(), name.getLocalPart());
            features.getFeature().add((Object)fc);
            QueryType qt = WfsFactory.eINSTANCE.createQueryType();
            qt.setTypeName(Collections.singletonList(qname));
            String crs = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)fc.getSchema().getCoordinateReferenceSystem());
            if (crs != null) {
                String srsName = "EPSG:" + crs;
                try {
                    qt.setSrsName(new URI(srsName));
                }
                catch (URISyntaxException e) {
                    throw new ServiceException("Unable to determite coordinate system for featureType " + fc.getSchema().getName().getLocalPart() + ".  Schema told us '" + srsName + "'", (Throwable)e);
                }
            }
            gfreq.getQuery().add((Object)qt);
        }
        Service serviceDesc = new Service("wms", null, null, Collections.EMPTY_LIST);
        Operation opDescriptor = new Operation("", serviceDesc, null, new Object[]{gfreq});
        GeoServer gs = this.wms.getGeoServer();
        FeatureTypeSchemaBuilder.GML3 sb = new FeatureTypeSchemaBuilder.GML3(gs);
        WFSConfiguration configuration = new WFSConfiguration(gs, (FeatureTypeSchemaBuilder)sb, new WFS((FeatureTypeSchemaBuilder)sb));
        GML3OutputFormat format = new GML3OutputFormat(gs, configuration);
        format.write((Object)features, out, opDescriptor);
    }
}

